/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.python.core.BytecodeLoader;
import org.python.expose.generate.PyTypes;

public abstract class Exposer
implements Opcodes,
PyTypes {
    protected MethodVisitor mv;
    protected ClassVisitor cv;
    private Type superType;
    protected Type thisType;
    protected static final Map<Type, Type> PRIMITIVES = new HashMap<Type, Type>(){
        {
            this.put(PyTypes.BOOLEAN, Type.getType(Boolean.class));
            this.put(PyTypes.BYTE, Type.getType(Byte.class));
            this.put(PyTypes.CHAR, Type.getType(Character.class));
            this.put(Type.DOUBLE_TYPE, Type.getType(Double.class));
            this.put(Type.FLOAT_TYPE, Type.getType(Float.class));
            this.put(PyTypes.INT, Type.getType(Integer.class));
            this.put(Type.LONG_TYPE, Type.getType(Long.class));
            this.put(PyTypes.SHORT, Type.getType(Short.class));
            this.put(PyTypes.VOID, Type.getType(Void.class));
        }
    };

    public Exposer(Class superClass, String generatedName) {
        this.superType = Type.getType((Class)superClass);
        this.thisType = Type.getType((String)("L" + generatedName.replace('.', '/') + ";"));
    }

    protected abstract void generate();

    protected Class load(BytecodeLoader.Loader l) {
        ClassWriter cw = new ClassWriter(2);
        this.generate((ClassVisitor)cw);
        return l.loadClassFromBytes(this.getClassName(), cw.toByteArray());
    }

    protected Type getGeneratedType() {
        return this.thisType;
    }

    public String getClassName() {
        return this.thisType.getClassName();
    }

    public String getInternalName() {
        return this.thisType.getInternalName();
    }

    public void generate(ClassVisitor visitor) {
        assert (this.cv == null);
        this.cv = visitor;
        this.cv.visit(49, 1, this.getInternalName(), null, this.superType.getInternalName(), new String[0]);
        this.generate();
        assert (this.mv == null);
        this.cv.visitEnd();
        this.cv = null;
    }

    protected void superConstructor(Type ... args) {
        this.callConstructor(this.superType, args);
    }

    protected void instantiate(Type ofType) {
        this.instantiate(ofType, new Instantiator(new Type[0]));
    }

    protected void instantiate(Type ofType, Instantiator inst) {
        this.mv.visitTypeInsn(187, ofType.getInternalName());
        this.mv.visitInsn(89);
        inst.pushArgs();
        this.callConstructor(ofType, inst.getTypes());
    }

    protected void callConstructor(Type onType, Type ... args) {
        this.mv.visitMethodInsn(183, onType.getInternalName(), "<init>", this.methodDesc(VOID, args));
    }

    protected void call(Type onType, String methodName, Type returnType, Type ... args) {
        this.mv.visitMethodInsn(182, onType.getInternalName(), methodName, this.methodDesc(returnType, args));
    }

    protected void callStatic(Type onType, String methodName, Type returnType, Type ... args) {
        this.mv.visitMethodInsn(184, onType.getInternalName(), methodName, this.methodDesc(returnType, args));
    }

    protected String methodDesc(Type ret, Type ... args) {
        return Type.getMethodDescriptor((Type)ret, (Type[])args);
    }

    protected void startConstructor(Type ... args) {
        this.startMethod("<init>", VOID, args);
    }

    protected void endConstructor() {
        this.endMethod(177);
    }

    protected void startMethod(String name, Type ret, Type ... args) {
        assert (this.mv == null);
        this.mv = this.cv.visitMethod(1, name, this.methodDesc(ret, args), null, null);
        this.mv.visitCode();
    }

    protected void endMethod(int returnCode) {
        this.mv.visitInsn(returnCode);
        this.mv.visitMaxs(0, 0);
        this.mv.visitEnd();
        this.mv = null;
    }

    protected void get(String fieldName, Type ofType) {
        this.mv.visitVarInsn(25, 0);
        this.mv.visitFieldInsn(180, this.getInternalName(), fieldName, ofType.getDescriptor());
    }

    protected void toPy(Type inputType) {
        if (inputType.equals((Object)VOID)) {
            this.getStatic(PY, "None", PYOBJ);
        } else if (inputType.equals((Object)STRING)) {
            this.callStatic(PY, "newString", PYSTR, STRING);
        } else if (inputType.equals((Object)BOOLEAN)) {
            this.callStatic(PY, "newBoolean", PYBOOLEAN, BOOLEAN);
        } else if (inputType.equals((Object)INT) || inputType.equals((Object)BYTE) || inputType.equals((Object)SHORT)) {
            this.callStatic(PY, "newInteger", PYINTEGER, INT);
        } else if (inputType.equals((Object)CHAR)) {
            this.callStatic(PY, "makeCharacter", PYSTR, CHAR);
        } else if (inputType.equals((Object)Type.DOUBLE_TYPE)) {
            this.callStatic(PY, "newFloat", PYFLOAT, Type.DOUBLE_TYPE);
        } else if (inputType.equals((Object)Type.FLOAT_TYPE)) {
            this.callStatic(PY, "newFloat", PYFLOAT, Type.FLOAT_TYPE);
        } else if (inputType.equals((Object)Type.LONG_TYPE)) {
            this.callStatic(PY, "newLong", PYLONG, Type.LONG_TYPE);
        }
    }

    protected void getStatic(Type onType, String fieldName, Type ofType) {
        this.mv.visitFieldInsn(178, onType.getInternalName(), fieldName, ofType.getDescriptor());
    }

    class Instantiator {
        private Type[] types;

        public Instantiator(Type ... types2) {
            this.types = types2;
        }

        public void pushArgs() {
            if (this.types.length > 0) {
                throw new IllegalStateException("If the constuctor takes types as indicated by passing their types to Instantiator, pushArgs must be overriden to put those args on the stack before the call");
            }
        }

        public Type[] getTypes() {
            return this.types;
        }
    }
}

