/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.expose.MethodType;
import org.python.expose.generate.Exposer;
import org.python.expose.generate.InvalidExposingException;
import org.python.expose.generate.PyTypes;

public class MethodExposer
extends Exposer {
    private String methodName;
    protected String[] asNames;
    protected String[] defaults;
    private String prefix;
    private String typeName;
    private Type[] args;
    private Type onType;
    private Type returnType;
    protected MethodType type;

    public MethodExposer(Type onType, int access, String methodName, String desc, String typeName) {
        this(onType, access, methodName, desc, typeName, new String[0], new String[0], MethodType.DEFAULT);
    }

    public MethodExposer(Type onType, int access, String methodName, String desc, String typeName, String[] asNames, String[] defaults, MethodType type) {
        super(MethodExposer.isWide(desc) ? PyBuiltinMethod.class : PyBuiltinMethodNarrow.class, onType.getClassName() + "$" + methodName + "_exposer");
        this.onType = onType;
        this.methodName = methodName;
        if ((access & 8) != 0) {
            this.throwInvalid("@ExposedMethod can't be applied to static methods");
        }
        this.args = Type.getArgumentTypes((String)desc);
        if (MethodExposer.isWide(this.args) && defaults.length > 0) {
            this.throwInvalid("Can't have defaults on a method that takes PyObject[], String[]");
        }
        this.returnType = Type.getReturnType((String)desc);
        this.typeName = typeName;
        String prefix = typeName;
        int lastDot = prefix.lastIndexOf(46);
        if (lastDot != -1) {
            prefix = prefix.substring(lastDot + 1);
        }
        this.prefix = prefix;
        this.asNames = asNames;
        for (String name : this.getNames()) {
            if (!name.equals("__new__")) continue;
            this.throwInvalid("@ExposedNew must be used to create __new__, not @ExposedMethod");
        }
        this.defaults = defaults;
        this.type = type;
    }

    private void throwInvalid(String msg) {
        throw new InvalidExposingException(msg + "[method=" + this.onType.getClassName() + "." + this.methodName + "]");
    }

    public String[] getNames() {
        if (this.asNames.length == 0) {
            String name = this.methodName;
            if (name.startsWith(this.prefix + "_")) {
                name = this.methodName.substring((this.prefix + "_").length());
            }
            return new String[]{name};
        }
        return this.asNames;
    }

    String[] getDefaults() {
        return this.defaults;
    }

    protected void generate() {
        this.generateNamedConstructor();
        this.generateFullConstructor();
        this.generateBind();
        if (MethodExposer.isWide(this.args)) {
            this.generateWideCall();
        } else {
            for (int i = 0; i < this.defaults.length + 1; ++i) {
                this.generateCall(i);
            }
        }
    }

    private void generateFullConstructor() {
        this.startConstructor(PYTYPE, PYOBJ, BUILTIN_INFO);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        this.mv.visitVarInsn(25, 2);
        this.mv.visitVarInsn(25, 3);
        this.superConstructor(PYTYPE, PYOBJ, BUILTIN_INFO);
        this.endConstructor();
    }

    private void generateNamedConstructor() {
        this.startConstructor(STRING);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitVarInsn(25, 1);
        if (MethodExposer.isWide(this.args)) {
            this.superConstructor(STRING);
        } else {
            this.mv.visitLdcInsn((Object)(this.args.length + 1 - this.defaults.length));
            this.mv.visitLdcInsn((Object)(this.args.length + 1));
            this.superConstructor(STRING, INT, INT);
        }
        this.endConstructor();
    }

    private void generateBind() {
        this.startMethod("bind", BUILTIN_FUNCTION, PYOBJ);
        this.instantiate(this.thisType, new Exposer.Instantiator(new Type[]{PYTYPE, PYOBJ, BUILTIN_INFO}){

            public void pushArgs() {
                MethodExposer.this.mv.visitVarInsn(25, 0);
                MethodExposer.this.call(MethodExposer.this.thisType, "getType", PyTypes.PYTYPE, new Type[0]);
                MethodExposer.this.mv.visitVarInsn(25, 1);
                MethodExposer.this.get("info", PyTypes.BUILTIN_INFO);
            }
        });
        this.endMethod(176);
    }

    private void generateWideCall() {
        this.startMethod("__call__", PYOBJ, APYOBJ, ASTRING);
        this.get("self", PYOBJ);
        this.mv.visitTypeInsn(192, this.onType.getInternalName());
        this.mv.visitVarInsn(25, 1);
        this.mv.visitVarInsn(25, 2);
        this.call(this.onType, this.methodName, this.returnType, this.args);
        this.toPy(this.returnType);
        this.endMethod(176);
    }

    private boolean hasDefault(int argIndex) {
        return this.defaults.length - this.args.length + argIndex >= 0;
    }

    private String getDefault(int argIndex) {
        return this.defaults[this.defaults.length - this.args.length + argIndex];
    }

    private void generateCall(int numDefaults) {
        int i;
        int usedLocals = 1;
        Type[] callArgs = new Type[this.args.length - numDefaults];
        for (i = 0; i < callArgs.length; ++i) {
            callArgs[i] = PYOBJ;
        }
        this.startMethod("__call__", PYOBJ, callArgs);
        this.get("self", PYOBJ);
        this.mv.visitTypeInsn(192, this.onType.getInternalName());
        for (i = 0; i < callArgs.length; ++i) {
            this.mv.visitVarInsn(25, usedLocals++);
            if (PRIMITIVES.containsKey(this.args[i])) {
                this.callStatic(PY, "py2" + this.args[i].getClassName(), this.args[i], PYOBJ);
                continue;
            }
            if (!this.args[i].equals((Object)STRING)) continue;
            if (this.hasDefault(i) && this.getDefault(i).equals("null")) {
                this.call(PYOBJ, "asStringOrNull", STRING, new Type[0]);
                continue;
            }
            this.call(PYOBJ, "asString", STRING, new Type[0]);
        }
        for (i = callArgs.length; i < this.args.length; ++i) {
            this.pushDefault(this.getDefault(i), this.args[i]);
        }
        this.call(this.onType, this.methodName, this.returnType, this.args);
        if (this.type == MethodType.BINARY) {
            this.checkBinaryResult();
        } else if (this.type == MethodType.CMP) {
            this.checkCmpResult();
        }
        this.toPy(this.returnType);
        this.endMethod(176);
    }

    private void checkBinaryResult() {
        this.mv.visitInsn(89);
        Label regularReturn = new Label();
        this.mv.visitJumpInsn(199, regularReturn);
        this.getStatic(PY, "NotImplemented", PYOBJ);
        this.mv.visitInsn(176);
        this.mv.visitLabel(regularReturn);
    }

    private void checkCmpResult() {
        this.mv.visitInsn(89);
        this.mv.visitIntInsn(16, -2);
        Label regularReturn = new Label();
        this.mv.visitJumpInsn(160, regularReturn);
        this.instantiate(STRING_BUILDER, new Exposer.Instantiator(new Type[]{STRING}){

            public void pushArgs() {
                MethodExposer.this.mv.visitLdcInsn((Object)(MethodExposer.this.typeName + ".__cmp__(x,y) requires y to be '" + MethodExposer.this.typeName + "', not a '"));
            }
        });
        this.mv.visitVarInsn(25, 1);
        this.call(PYOBJ, "getType", PYTYPE, new Type[0]);
        this.call(PYTYPE, "fastGetName", STRING, new Type[0]);
        this.call(STRING_BUILDER, "append", STRING_BUILDER, STRING);
        this.mv.visitLdcInsn((Object)"'");
        this.call(STRING_BUILDER, "append", STRING_BUILDER, STRING);
        this.call(STRING_BUILDER, "toString", STRING, new Type[0]);
        this.callStatic(PY, "TypeError", PYEXCEPTION, STRING);
        this.mv.visitInsn(191);
        this.mv.visitLabel(regularReturn);
    }

    private void pushDefault(String def, Type arg) {
        if (def.equals("Py.None")) {
            this.getStatic(PY, "None", PYOBJ);
        } else if (def.equals("null")) {
            this.mv.visitInsn(1);
        } else if (arg.equals((Object)Type.LONG_TYPE)) {
            this.mv.visitLdcInsn((Object)new Long(def));
        } else if (arg.equals((Object)INT)) {
            this.mv.visitLdcInsn((Object)new Integer(def));
        } else if (arg.equals((Object)BYTE)) {
            this.mv.visitLdcInsn((Object)new Byte(def).intValue());
        } else if (arg.equals((Object)SHORT)) {
            this.mv.visitLdcInsn((Object)new Short(def).intValue());
        } else if (arg.equals((Object)CHAR)) {
            if (def.length() != 1) {
                this.throwInvalid("A default for a char argument must be one character in length");
            }
            this.mv.visitLdcInsn((Object)new Character(def.charAt(0)).charValue());
        } else if (arg.equals((Object)BOOLEAN)) {
            this.mv.visitLdcInsn((Object)(Boolean.valueOf(def) != false ? 1 : 0));
        } else if (arg.equals((Object)Type.FLOAT_TYPE)) {
            this.mv.visitLdcInsn((Object)new Float(def));
        } else if (arg.equals((Object)Type.DOUBLE_TYPE)) {
            this.mv.visitLdcInsn((Object)new Double(def));
        }
    }

    private static boolean isWide(String methDescriptor) {
        return MethodExposer.isWide(Type.getArgumentTypes((String)methDescriptor));
    }

    private static boolean isWide(Type[] args) {
        return args.length == 2 && args[0].equals((Object)APYOBJ) && args[1].equals((Object)ASTRING);
    }
}

