/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.python.core.BytecodeLoader;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyException;
import org.python.expose.MethodType;
import org.python.expose.generate.InterpTestCase;
import org.python.expose.generate.InvalidExposingException;
import org.python.expose.generate.MethodExposer;
import org.python.expose.generate.PyTypes;
import org.python.expose.generate.SimpleExposed;

public class MethodExposerTest
extends InterpTestCase
implements Opcodes,
PyTypes {
    public static MethodExposer createExposer(String methodName, Type returnType, Type ... args) {
        return new MethodExposer(Type.getType(SimpleExposed.class), 1, methodName, Type.getMethodDescriptor((Type)returnType, (Type[])args), "simpleexposed");
    }

    public static PyBuiltinFunction createBound(String methodName, Type returnType, Type ... args) throws Exception {
        return MethodExposerTest.createBound(MethodExposerTest.createExposer(methodName, returnType, args));
    }

    public static PyBuiltinFunction createBound(MethodExposer me) throws Exception {
        Class descriptor = me.load(new BytecodeLoader.Loader());
        return MethodExposerTest.instantiate(descriptor, me.getNames()[0]).bind(new SimpleExposed());
    }

    public static PyBuiltinFunction instantiate(Class descriptor, String name) throws Exception {
        return (PyBuiltinFunction)descriptor.getConstructor(String.class).newInstance(name);
    }

    public void testSimpleMethod() throws Exception {
        MethodExposer mp = MethodExposerTest.createExposer("simple_method", VOID, new Type[0]);
        MethodExposerTest.assertEquals((String)"simple_method", (String)mp.getNames()[0]);
        MethodExposerTest.assertEquals((String)"org/python/expose/generate/SimpleExposed$simple_method_exposer", (String)mp.getInternalName());
        MethodExposerTest.assertEquals((String)"org.python.expose.generate.SimpleExposed$simple_method_exposer", (String)mp.getClassName());
        Class descriptor = mp.load(new BytecodeLoader.Loader());
        PyBuiltinFunction instance = MethodExposerTest.instantiate(descriptor, "simple_method");
        MethodExposerTest.assertSame((Object)"simple_method", (Object)instance.__getattr__("__name__").toString());
        SimpleExposed simpleExposed = new SimpleExposed();
        PyBuiltinFunction bound = instance.bind(simpleExposed);
        MethodExposerTest.assertEquals(instance.getClass(), bound.getClass());
        MethodExposerTest.assertEquals((Object)Py.None, (Object)bound.__call__());
        MethodExposerTest.assertEquals((int)1, (int)simpleExposed.timesCalled);
    }

    public void testPrefixing() throws Exception {
        MethodExposerTest.assertEquals((String)"prefixed", (String)MethodExposerTest.createExposer("simpleexposed_prefixed", VOID, new Type[0]).getNames()[0]);
    }

    public void testStringReturn() throws Exception {
        MethodExposerTest.assertEquals((Object)Py.newString("A simple test class"), (Object)MethodExposerTest.createBound("toString", STRING, new Type[0]).__call__());
    }

    public void testBooleanReturn() throws Exception {
        MethodExposerTest.assertEquals((Object)Py.False, (Object)MethodExposerTest.createBound("__nonzero__", BOOLEAN, new Type[0]).__call__());
    }

    public void testArgumentPassing() throws Exception {
        PyBuiltinFunction bound = MethodExposerTest.createBound("takesArgument", Type.DOUBLE_TYPE, PYOBJ);
        MethodExposerTest.assertEquals((Object)1.0, (Object)Py.py2double(bound.__call__(Py.One)));
        try {
            bound.__call__();
            MethodExposerTest.fail((String)"Need to pass an argument to takesArgument");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBinary() throws Exception {
        MethodExposer exposer = MethodExposerTest.createExposer("__add__", PYOBJ, PYOBJ);
        exposer.type = MethodType.BINARY;
        PyBuiltinFunction bound = MethodExposerTest.createBound(exposer);
        MethodExposerTest.assertEquals((Object)Py.NotImplemented, (Object)bound.__call__(Py.None));
        MethodExposerTest.assertEquals((Object)Py.One, (Object)bound.__call__(Py.False));
    }

    public void testCmp() throws Exception {
        PyBuiltinFunction bound;
        block2: {
            MethodExposer exp = MethodExposerTest.createExposer("__cmp__", INT, PYOBJ);
            exp.type = MethodType.CMP;
            bound = MethodExposerTest.createBound(exp);
            try {
                bound.__call__(Py.None);
                MethodExposerTest.fail((String)"Returning -2 from __cmp__ should yield a type error");
            }
            catch (PyException e) {
                if (Py.matchException(e, Py.TypeError)) break block2;
                MethodExposerTest.fail((String)"Returning -2 from __cmp__ should yield a type error");
            }
        }
        MethodExposerTest.assertEquals((Object)Py.One, (Object)bound.__call__(Py.False));
    }

    public void testNoneDefault() throws Exception {
        MethodExposer exp = MethodExposerTest.createExposer("defaultToNone", PYOBJ, PYOBJ);
        exp.defaults = new String[]{"Py.None"};
        PyBuiltinFunction bound = MethodExposerTest.createBound(exp);
        MethodExposerTest.assertEquals((Object)Py.One, (Object)bound.__call__(Py.One));
        MethodExposerTest.assertEquals((Object)Py.None, (Object)bound.__call__());
    }

    public void testNullDefault() throws Exception {
        MethodExposer exp = MethodExposerTest.createExposer("defaultToNull", PYOBJ, PYOBJ);
        exp.defaults = new String[]{"null"};
        PyBuiltinFunction bound = MethodExposerTest.createBound(exp);
        MethodExposerTest.assertEquals((Object)Py.One, (Object)bound.__call__(Py.One));
        MethodExposerTest.assertEquals(null, (Object)bound.__call__());
    }

    public void testIntDefault() throws Exception {
        MethodExposer exp = MethodExposerTest.createExposer("defaultToOne", PYOBJ, INT);
        exp.defaults = new String[]{"1"};
        PyBuiltinFunction bound = MethodExposerTest.createBound(exp);
        MethodExposerTest.assertEquals((Object)Py.Zero, (Object)bound.__call__(Py.Zero));
        MethodExposerTest.assertEquals((Object)Py.One, (Object)bound.__call__());
        exp.defaults = new String[]{"X"};
        try {
            MethodExposerTest.createBound(exp);
            MethodExposerTest.fail((String)"Shouldn't be able to create the exposer with a non-int default value");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void testPrimitiveDefaults() throws Exception {
        MethodExposer exp = MethodExposerTest.createExposer("manyPrimitives", STRING, CHAR, SHORT, Type.DOUBLE_TYPE, BYTE);
        exp.defaults = new String[]{"a", "1", "2", "3"};
        PyBuiltinFunction bound = MethodExposerTest.createBound(exp);
        MethodExposerTest.assertEquals((String)"a12.03", (String)bound.__call__().toString());
        MethodExposerTest.assertEquals((String)"b12.03", (String)bound.__call__(Py.newString('b')).toString());
        exp.defaults = new String[]{"ab", "1", "2", "3"};
        try {
            MethodExposerTest.createBound(exp);
            MethodExposerTest.fail((String)"Char should only be one character");
        }
        catch (InvalidExposingException invalidExposingException) {
            // empty catch block
        }
    }

    public void testFullArguments() throws Exception {
        MethodExposer exp = new MethodExposer(Type.getType(SimpleExposed.class), 1, "fullArgs", Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[]{APYOBJ, ASTRING}), "simpleexposed");
        PyBuiltinFunction bound = MethodExposerTest.createBound(exp);
        MethodExposerTest.assertEquals((Object)Py.Zero, (Object)bound.__call__());
        MethodExposerTest.assertEquals((Object)Py.One, (Object)bound.__call__(Py.One));
        try {
            new MethodExposer(Type.getType(SimpleExposed.class), 1, "fullArgs", Type.getMethodDescriptor((Type)PYOBJ, (Type[])new Type[]{APYOBJ, ASTRING}), "simpleexposed", new String[0], new String[]{"X"}, MethodType.DEFAULT);
            MethodExposerTest.fail((String)"Shouldn't be able to create the exposer with a default value");
        }
        catch (InvalidExposingException invalidExposingException) {
            // empty catch block
        }
    }

    public void testExposingStatic() {
        try {
            new MethodExposer(Type.getType(SimpleExposed.class), 9, "fullArgs", Type.getMethodDescriptor((Type)PYOBJ, (Type[])new Type[]{APYOBJ, ASTRING}), "simpleexposed");
            MethodExposerTest.fail((String)"Shouldn't be able to create an exposer on a static method");
        }
        catch (InvalidExposingException invalidExposingException) {
            // empty catch block
        }
    }

    public void testPrimitiveReturns() throws Exception {
        MethodExposerTest.assertEquals((int)12, (int)Py.py2int(MethodExposerTest.createBound("shortReturn", SHORT, new Type[0]).__call__()));
        MethodExposerTest.assertEquals((int)0, (int)Py.py2int(MethodExposerTest.createBound("byteReturn", BYTE, new Type[0]).__call__()));
        MethodExposerTest.assertEquals((String)"a", (String)MethodExposerTest.createBound("charReturn", CHAR, new Type[0]).__call__().toString());
    }

    public void test__new__() throws Exception {
        try {
            MethodExposerTest.createExposer("__new__", VOID, new Type[0]);
            MethodExposerTest.fail((String)"Shouldn't be able to make a MethodExposer with the name __new__");
        }
        catch (InvalidExposingException invalidExposingException) {
            // empty catch block
        }
    }
}

