/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import java.util.Collection;
import java.util.HashSet;
import org.objectweb.asm.Type;
import org.python.core.BytecodeLoader;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyDataDescr;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.PyType;
import org.python.expose.TypeBuilder;
import org.python.expose.generate.DescriptorExposer;
import org.python.expose.generate.Exposer;
import org.python.expose.generate.InvalidExposingException;
import org.python.expose.generate.MethodExposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeExposer
extends Exposer {
    private Type baseType;
    private Type onType;
    private String name;
    private Collection<MethodExposer> methods;
    private Collection<DescriptorExposer> descriptors;
    private int numNames;
    private Exposer ne;

    public TypeExposer(Type onType, Type baseType, String name, Collection<MethodExposer> methods, Collection<DescriptorExposer> descriptors, Exposer ne) {
        super(BaseTypeBuilder.class, TypeExposer.makeGeneratedName(onType));
        this.baseType = baseType;
        this.onType = onType;
        this.name = name;
        this.methods = methods;
        this.descriptors = descriptors;
        HashSet<String> names = new HashSet<String>();
        for (DescriptorExposer exposer : descriptors) {
            if (names.add(exposer.getName())) continue;
            this.throwDupe(exposer.getName());
        }
        for (MethodExposer method : methods) {
            String[] methNames;
            for (String methName : methNames = method.getNames()) {
                if (names.add(methName)) continue;
                this.throwDupe(methName);
            }
            this.numNames += methNames.length;
        }
        this.ne = ne;
    }

    private void throwDupe(String exposedName) {
        throw new InvalidExposingException("Only one item may be exposed on a type with a given name[name=" + exposedName + ", class=" + this.onType.getClassName() + "]");
    }

    public static String makeGeneratedName(Type onType) {
        return onType.getClassName() + "$PyExposer";
    }

    public TypeBuilder makeBuilder() {
        BytecodeLoader.Loader l = new BytecodeLoader.Loader();
        if (this.ne != null) {
            this.ne.load(l);
        }
        for (DescriptorExposer de : this.descriptors) {
            de.load(l);
        }
        for (MethodExposer me : this.methods) {
            me.load(l);
        }
        Class descriptor = this.load(l);
        try {
            return (TypeBuilder)descriptor.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create generated builder", e);
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    protected void generate() {
        this.startConstructor(new Type[0]);
        this.mv.visitVarInsn(25, 0);
        this.mv.visitLdcInsn((Object)this.getName());
        this.mv.visitLdcInsn((Object)this.onType);
        this.mv.visitLdcInsn((Object)this.baseType);
        this.mv.visitLdcInsn((Object)this.numNames);
        this.mv.visitTypeInsn(189, BUILTIN_FUNCTION.getInternalName());
        this.mv.visitVarInsn(58, 1);
        int i = 0;
        for (MethodExposer exposer : this.methods) {
            for (final String name : exposer.getNames()) {
                this.mv.visitVarInsn(25, 1);
                this.mv.visitLdcInsn((Object)i++);
                this.instantiate(exposer.getGeneratedType(), new Exposer.Instantiator(new Type[]{STRING}){

                    public void pushArgs() {
                        TypeExposer.this.mv.visitLdcInsn((Object)name);
                    }
                });
                this.mv.visitInsn(83);
            }
        }
        this.mv.visitVarInsn(25, 1);
        this.mv.visitLdcInsn((Object)this.descriptors.size());
        this.mv.visitTypeInsn(189, DATA_DESCR.getInternalName());
        this.mv.visitVarInsn(58, 2);
        i = 0;
        for (DescriptorExposer desc : this.descriptors) {
            this.mv.visitVarInsn(25, 2);
            this.mv.visitLdcInsn((Object)i++);
            this.instantiate(desc.getGeneratedType());
            this.mv.visitInsn(83);
        }
        this.mv.visitVarInsn(25, 2);
        if (this.ne != null) {
            this.instantiate(this.ne.getGeneratedType());
        } else {
            this.mv.visitInsn(1);
        }
        this.superConstructor(STRING, CLASS, CLASS, ABUILTIN_FUNCTION, ADATA_DESCR, PYNEWWRAPPER);
        this.endConstructor();
    }

    protected static class BaseTypeBuilder
    implements TypeBuilder {
        private PyNewWrapper newWrapper;
        private PyBuiltinFunction[] funcs;
        private PyDataDescr[] descrs;
        private Class typeClass;
        private Class baseClass;
        private String name;

        public BaseTypeBuilder(String name, Class typeClass, Class baseClass, PyBuiltinFunction[] funcs, PyDataDescr[] descrs, PyNewWrapper newWrapper) {
            this.typeClass = typeClass;
            this.baseClass = baseClass;
            this.name = name;
            this.descrs = descrs;
            this.funcs = funcs;
            this.newWrapper = newWrapper;
        }

        public PyObject getDict(PyType type) {
            PyStringMap dict = new PyStringMap();
            for (PyBuiltinFunction pyBuiltinFunction : this.funcs) {
                PyMethodDescr pmd = new PyMethodDescr(type, pyBuiltinFunction);
                ((PyObject)dict).__setitem__(pmd.getName(), (PyObject)pmd);
            }
            for (PyObject pyObject : this.descrs) {
                ((PyObject)dict).__setitem__(((PyDataDescr)pyObject).getName(), pyObject);
            }
            if (this.newWrapper != null) {
                ((PyObject)dict).__setitem__("__new__", (PyObject)this.newWrapper);
                this.newWrapper.setWrappedType(type);
            }
            return dict;
        }

        public String getName() {
            return this.name;
        }

        public Class getTypeClass() {
            return this.typeClass;
        }

        public Class getBase() {
            return this.baseClass;
        }
    }
}

