/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.generate.TypeExposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyTeeIterator
extends PyIterator {
    private final int position;
    private int count = 0;
    private final PyObject iterator;
    private final Map<Integer, PyObject> buffer;
    private final int[] offsets;

    PyTeeIterator(PyObject pyObject, Map<Integer, PyObject> map, int[] nArray, int n) {
        this.iterator = pyObject;
        this.buffer = map;
        this.offsets = nArray;
        this.position = n;
    }

    @ExposedNew
    static final PyObject tee___new__(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        int n = pyObjectArray.length;
        if (n < 1 || n > 1) {
            throw Py.TypeError("tee expected 1 arguments, got " + n);
        }
        return PyTeeIterator.makeTees(pyObjectArray[0], 1)[0];
    }

    public static PyTeeIterator[] makeTees(PyObject pyObject, int n) {
        if (n < 0) {
            throw Py.ValueError("n must be >= 0");
        }
        PyObject pyObject2 = pyObject.__iter__();
        ConcurrentHashMap<Integer, PyObject> concurrentHashMap = new ConcurrentHashMap<Integer, PyObject>();
        int[] nArray = new int[n];
        PyTeeIterator[] pyTeeIteratorArray = new PyTeeIterator[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = -1;
            pyTeeIteratorArray[i] = new PyTeeIterator(pyObject2, concurrentHashMap, nArray, i);
        }
        return pyTeeIteratorArray;
    }

    protected PyObject nextElement(PyObject pyObject) {
        PyObject pyObject2 = null;
        try {
            pyObject2 = pyObject.__iternext__();
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.StopIteration)) {
                this.stopException = pyException;
            }
            throw pyException;
        }
        return pyObject2;
    }

    public final PyObject tee_next() {
        return this.next();
    }

    @Override
    public PyObject __iternext__() {
        PyObject pyObject;
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.offsets.length; ++i) {
            if (n < this.offsets[i]) {
                n = this.offsets[i];
            }
            if (n2 <= this.offsets[i]) continue;
            n2 = this.offsets[i];
        }
        if (this.count > n) {
            pyObject = this.nextElement(this.iterator);
            if (pyObject != null) {
                this.buffer.put(this.count, pyObject);
            }
        } else {
            pyObject = this.count < n2 ? this.buffer.remove(this.count) : this.buffer.get(this.count);
        }
        this.offsets[this.position] = this.count++;
        return pyObject;
    }

    static {
        PyType.addBuilder(PyTeeIterator.class, new PyTeeIterator$PyExposer());
    }

    public class PyTeeIterator$tee_next_exposer
    extends PyBuiltinMethodNarrow {
        public PyTeeIterator$tee_next_exposer(String string) {
            super(string, 1, 1);
        }

        public PyTeeIterator$tee_next_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyTeeIterator$tee_next_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyTeeIterator)this.self).tee_next();
        }
    }

    public class PyTeeIterator$exposed___new__
    extends PyNewWrapper {
        public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
            return PyTeeIterator.tee___new__(this, bl, pyType, pyObjectArray, stringArray);
        }
    }

    public class PyTeeIterator$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public PyTeeIterator$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{new PyTeeIterator$tee_next_exposer("next")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("itertools.tee", PyTeeIterator.class, PyObject.class, pyBuiltinFunctionArray, pyDataDescrArray, new PyTeeIterator$exposed___new__());
        }
    }
}

