/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.collections;

import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyDataDescr;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyIterator;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PySequenceIter;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.ExposedNew;
import org.python.expose.generate.TypeExposer;
import org.python.modules.collections.PyDequeDerived;

public class PyDeque
extends PyObject {
    public static final PyType TYPE;
    private int size = 0;
    private Node header = new Node(null, null, null);

    public PyDeque() {
        this(TYPE);
    }

    public PyDeque(PyType pyType) {
        super(pyType);
        this.header.left = (this.header.right = this.header);
    }

    @ExposedNew
    final void deque___init__(PyObject[] pyObjectArray, String[] stringArray) {
        block7: {
            if (stringArray.length > 0) {
                throw Py.TypeError("deque() does not take keyword arguments");
            }
            int n = pyObjectArray.length;
            if (n > 1) {
                throw PyBuiltinFunction.DefaultInfo.unexpectedCall(n, false, "deque", 0, 1);
            }
            if (n == 0) {
                return;
            }
            PyObject pyObject = pyObjectArray[0];
            if (pyObject.__findattr__("__iter__") != null) {
                this.deque_extend(pyObject);
            } else {
                try {
                    this.deque_extend(new PySequenceIter(pyObject));
                }
                catch (PyException pyException) {
                    if (!Py.matchException(pyException, Py.AttributeError)) break block7;
                    throw Py.TypeError("'" + pyObject.getType().fastGetName() + "' object is not iterable");
                }
            }
        }
    }

    final void deque_append(PyObject pyObject) {
        this.addBefore(pyObject, this.header);
    }

    final void deque_appendleft(PyObject pyObject) {
        this.addBefore(pyObject, this.header.right);
    }

    private Node addBefore(PyObject pyObject, Node node) {
        Node node2 = new Node(pyObject, node, node.left);
        node2.left.right = node2;
        node2.right.left = node2;
        ++this.size;
        return node2;
    }

    final void deque_clear() {
        Node node = this.header.right;
        while (node != this.header) {
            Node node2 = node.right;
            node.left = null;
            node.right = null;
            node.data = null;
            node = node2;
        }
        this.header.right = (this.header.left = this.header);
        this.size = 0;
    }

    final void deque_extend(PyObject pyObject) {
        for (PyObject pyObject2 : pyObject.asIterable()) {
            this.deque_append(pyObject2);
        }
    }

    final void deque_extendleft(PyObject pyObject) {
        for (PyObject pyObject2 : pyObject.asIterable()) {
            this.deque_appendleft(pyObject2);
        }
    }

    final PyObject deque_pop() {
        return this.removeNode(this.header.left);
    }

    final PyObject deque_popleft() {
        return this.removeNode(this.header.right);
    }

    private PyObject removeNode(Node node) {
        if (node == this.header) {
            throw Py.IndexError("pop from an empty deque");
        }
        PyObject pyObject = node.data;
        node.left.right = node.right;
        node.right.left = node.left;
        node.right = null;
        node.left = null;
        node.data = null;
        --this.size;
        return pyObject;
    }

    final PyObject deque_remove(PyObject pyObject) {
        int n = this.size;
        Node node = this.header.right;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (node.data.equals(pyObject)) {
                bl = true;
            }
            if (n != this.size) {
                throw Py.IndexError("deque mutated during remove().");
            }
            if (bl) {
                return this.removeNode(node);
            }
            node = node.right;
        }
        throw Py.ValueError("deque.remove(x): x not in deque");
    }

    final void deque_rotate(int n) {
        int n2;
        if (this.size == 0) {
            return;
        }
        int n3 = this.size + 1 >> 1;
        if (n > n3 || n < -n3) {
            if ((n %= this.size) > n3) {
                n -= this.size;
            } else if (n < -n3) {
                n += this.size;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.deque_appendleft(this.deque_pop());
        }
        for (n2 = 0; n2 > n; --n2) {
            this.deque_append(this.deque_popleft());
        }
    }

    public String toString() {
        return this.deque_toString();
    }

    final String deque_toString() {
        ThreadState threadState = Py.getThreadState();
        if (!threadState.enterRepr(this)) {
            return "[...]";
        }
        StringBuffer stringBuffer = new StringBuffer("deque").append("([");
        Node node = this.header.right;
        while (node != this.header) {
            stringBuffer.append(node.data.__repr__().toString());
            if (node.right != this.header) {
                stringBuffer.append(", ");
            }
            node = node.right;
        }
        stringBuffer.append("])");
        threadState.exitRepr(this);
        return stringBuffer.toString();
    }

    public int __len__() {
        return this.deque___len__();
    }

    final int deque___len__() {
        return this.size;
    }

    public boolean __nonzero__() {
        return this.deque___nonzero__();
    }

    final boolean deque___nonzero__() {
        return this.size != 0;
    }

    public PyObject __finditem__(PyObject pyObject) {
        try {
            return this.deque___getitem__(pyObject);
        }
        catch (PyException pyException) {
            if (Py.matchException(pyException, Py.KeyError)) {
                return null;
            }
            throw pyException;
        }
    }

    final PyObject deque___getitem__(PyObject pyObject) {
        return this.getNode(pyObject).data;
    }

    public void __setitem__(PyObject pyObject, PyObject pyObject2) {
        this.deque___setitem__(pyObject, pyObject2);
    }

    final void deque___setitem__(PyObject pyObject, PyObject pyObject2) {
        Node node = this.getNode(pyObject).right;
        this.removeNode(node.left);
        this.addBefore(pyObject2, node);
    }

    public void __delitem__(PyObject pyObject) {
        this.deque___delitem__(pyObject);
    }

    final void deque___delitem__(PyObject pyObject) {
        this.removeNode(this.getNode(pyObject));
    }

    private Node getNode(PyObject pyObject) {
        int n = 0;
        if (!(pyObject instanceof PyInteger) && !(pyObject instanceof PyLong)) {
            throw Py.TypeError("an integer is required");
        }
        n = ((PyInteger)pyObject.__int__()).getValue();
        if (n < 0) {
            n += this.size;
        }
        if (n < 0 || n >= this.size) {
            throw Py.IndexError("index out of range: " + pyObject);
        }
        Node node = this.header;
        if (n < this.size >> 1) {
            for (int i = 0; i <= n; ++i) {
                node = node.right;
            }
        } else {
            for (int i = this.size - 1; i >= n; --i) {
                node = node.left;
            }
        }
        return node;
    }

    public PyObject __iter__() {
        return this.deque___iter__();
    }

    final PyObject deque___iter__() {
        return new PyDequeIter();
    }

    public synchronized PyObject __eq__(PyObject pyObject) {
        return this.deque___eq__(pyObject);
    }

    final synchronized PyObject deque___eq__(PyObject pyObject) {
        int n;
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n2 = this.__len__();
        if (n2 != (n = pyObject.__len__())) {
            return Py.False;
        }
        int n3 = PyDeque.cmp(this, n2, pyObject, n);
        return n3 < 0 ? Py.True : Py.False;
    }

    public synchronized PyObject __ne__(PyObject pyObject) {
        return this.deque___ne__(pyObject);
    }

    final synchronized PyObject deque___ne__(PyObject pyObject) {
        int n;
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n2 = this.__len__();
        if (n2 != (n = pyObject.__len__())) {
            return Py.True;
        }
        int n3 = PyDeque.cmp(this, n2, pyObject, n);
        return n3 < 0 ? Py.False : Py.True;
    }

    public synchronized PyObject __lt__(PyObject pyObject) {
        return this.deque___lt__(pyObject);
    }

    final synchronized PyObject deque___lt__(PyObject pyObject) {
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n = PyDeque.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -1 ? Py.True : Py.False;
        }
        return this.__finditem__(n)._lt(pyObject.__finditem__(n));
    }

    public synchronized PyObject __le__(PyObject pyObject) {
        return this.deque___le__(pyObject);
    }

    final synchronized PyObject deque___le__(PyObject pyObject) {
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n = PyDeque.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -1 || n == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(n)._le(pyObject.__finditem__(n));
    }

    public synchronized PyObject __gt__(PyObject pyObject) {
        return this.deque___gt__(pyObject);
    }

    final synchronized PyObject deque___gt__(PyObject pyObject) {
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n = PyDeque.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -3 ? Py.True : Py.False;
        }
        return this.__finditem__(n)._gt(pyObject.__finditem__(n));
    }

    public synchronized PyObject __ge__(PyObject pyObject) {
        return this.deque___ge__(pyObject);
    }

    final synchronized PyObject deque___ge__(PyObject pyObject) {
        if (this.getType() != pyObject.getType() && !this.getType().isSubType(pyObject.getType())) {
            return null;
        }
        int n = PyDeque.cmp(this, -1, pyObject, -1);
        if (n < 0) {
            return n == -3 || n == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(n)._ge(pyObject.__finditem__(n));
    }

    protected static int cmp(PyObject pyObject, int n, PyObject pyObject2, int n2) {
        if (n < 0) {
            n = pyObject.__len__();
        }
        if (n2 < 0) {
            n2 = pyObject2.__len__();
        }
        for (int i = 0; i < n && i < n2; ++i) {
            if (pyObject.__getitem__(i)._eq(pyObject2.__getitem__(i)).__nonzero__()) continue;
            return i;
        }
        if (n == n2) {
            return -2;
        }
        return n < n2 ? -1 : -3;
    }

    public int hashCode() {
        return this.deque_hashCode();
    }

    final int deque_hashCode() {
        throw Py.TypeError("deque objects are unhashable");
    }

    public PyObject __reduce__() {
        return this.deque___reduce__();
    }

    final PyObject deque___reduce__() {
        return new PyTuple(this.getType(), Py.EmptyTuple, Py.None, this.deque___iter__());
    }

    final PyObject deque___copy__() {
        PyDeque pyDeque = (PyDeque)this.getType().__call__();
        pyDeque.deque_extend(this);
        return pyDeque;
    }

    static {
        PyType.addBuilder(PyDeque.class, new PyDeque$PyExposer());
        TYPE = PyType.fromClass(PyDeque.class);
    }

    private class PyDequeIter
    extends PyIterator {
        private Node lastReturned;
        private int itersize;

        public PyDequeIter() {
            this.lastReturned = PyDeque.this.header;
            this.itersize = PyDeque.this.size;
        }

        public PyObject __iternext__() {
            if (this.itersize != PyDeque.this.size) {
                throw Py.RuntimeError("deque changed size during iteration");
            }
            if (this.lastReturned.right != PyDeque.this.header) {
                this.lastReturned = this.lastReturned.right;
                return this.lastReturned.data;
            }
            return null;
        }
    }

    private static class Node {
        private Node left;
        private Node right;
        private PyObject data;

        Node(PyObject data, Node right, Node left) {
            this.data = data;
            this.right = right;
            this.left = left;
        }
    }

    public class PyDeque$deque___init___exposer
    extends PyBuiltinMethod {
        public PyDeque$deque___init___exposer(String string) {
            super(string);
        }

        public PyDeque$deque___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((PyDeque)this.self).deque___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class PyDeque$deque_append_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_append_exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque_append_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_append_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyDeque)this.self).deque_append(pyObject);
            return Py.None;
        }
    }

    public class PyDeque$deque_appendleft_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_appendleft_exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque_appendleft_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_appendleft_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyDeque)this.self).deque_appendleft(pyObject);
            return Py.None;
        }
    }

    public class PyDeque$deque_clear_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_clear_exposer(String string) {
            super(string, 1, 1);
        }

        public PyDeque$deque_clear_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_clear_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            ((PyDeque)this.self).deque_clear();
            return Py.None;
        }
    }

    public class PyDeque$deque_extend_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_extend_exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque_extend_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_extend_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyDeque)this.self).deque_extend(pyObject);
            return Py.None;
        }
    }

    public class PyDeque$deque_extendleft_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_extendleft_exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque_extendleft_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_extendleft_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyDeque)this.self).deque_extendleft(pyObject);
            return Py.None;
        }
    }

    public class PyDeque$deque_pop_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_pop_exposer(String string) {
            super(string, 1, 1);
        }

        public PyDeque$deque_pop_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_pop_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyDeque)this.self).deque_pop();
        }
    }

    public class PyDeque$deque_popleft_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_popleft_exposer(String string) {
            super(string, 1, 1);
        }

        public PyDeque$deque_popleft_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_popleft_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyDeque)this.self).deque_popleft();
        }
    }

    public class PyDeque$deque_remove_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_remove_exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque_remove_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_remove_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyDeque)this.self).deque_remove(pyObject);
        }
    }

    public class PyDeque$deque_rotate_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_rotate_exposer(String string) {
            super(string, 1, 2);
        }

        public PyDeque$deque_rotate_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_rotate_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyDeque)this.self).deque_rotate(Py.py2int(pyObject));
            return Py.None;
        }

        public PyObject __call__() {
            ((PyDeque)this.self).deque_rotate(1);
            return Py.None;
        }
    }

    public class PyDeque$deque_toString_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_toString_exposer(String string) {
            super(string, 1, 1);
        }

        public PyDeque$deque_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((PyDeque)this.self).deque_toString());
        }
    }

    public class PyDeque$deque___len___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___len___exposer(String string) {
            super(string, 1, 1);
        }

        public PyDeque$deque___len___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___len___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyDeque)this.self).deque___len__());
        }
    }

    public class PyDeque$deque___nonzero___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___nonzero___exposer(String string) {
            super(string, 1, 1);
        }

        public PyDeque$deque___nonzero___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___nonzero___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newBoolean(((PyDeque)this.self).deque___nonzero__());
        }
    }

    public class PyDeque$deque___getitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___getitem___exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque___getitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___getitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((PyDeque)this.self).deque___getitem__(pyObject);
        }
    }

    public class PyDeque$deque___setitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___setitem___exposer(String string) {
            super(string, 3, 3);
        }

        public PyDeque$deque___setitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___setitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            ((PyDeque)this.self).deque___setitem__(pyObject, pyObject2);
            return Py.None;
        }
    }

    public class PyDeque$deque___delitem___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___delitem___exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque___delitem___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___delitem___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            ((PyDeque)this.self).deque___delitem__(pyObject);
            return Py.None;
        }
    }

    public class PyDeque$deque___iter___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___iter___exposer(String string) {
            super(string, 1, 1);
        }

        public PyDeque$deque___iter___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___iter___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyDeque)this.self).deque___iter__();
        }
    }

    public class PyDeque$deque___eq___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___eq___exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque___eq___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___eq___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyDeque)this.self).deque___eq__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyDeque$deque___ne___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___ne___exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque___ne___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___ne___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyDeque)this.self).deque___ne__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyDeque$deque___lt___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___lt___exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque___lt___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___lt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyDeque)this.self).deque___lt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyDeque$deque___le___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___le___exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque___le___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___le___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyDeque)this.self).deque___le__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyDeque$deque___gt___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___gt___exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque___gt___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___gt___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyDeque)this.self).deque___gt__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyDeque$deque___ge___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___ge___exposer(String string) {
            super(string, 2, 2);
        }

        public PyDeque$deque___ge___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___ge___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            PyObject pyObject2 = ((PyDeque)this.self).deque___ge__(pyObject);
            if (pyObject2 == null) {
                return Py.NotImplemented;
            }
            return pyObject2;
        }
    }

    public class PyDeque$deque_hashCode_exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque_hashCode_exposer(String string) {
            super(string, 1, 1);
        }

        public PyDeque$deque_hashCode_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque_hashCode_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newInteger(((PyDeque)this.self).deque_hashCode());
        }
    }

    public class PyDeque$deque___reduce___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___reduce___exposer(String string) {
            super(string, 1, 1);
        }

        public PyDeque$deque___reduce___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___reduce___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyDeque)this.self).deque___reduce__();
        }
    }

    public class PyDeque$deque___copy___exposer
    extends PyBuiltinMethodNarrow {
        public PyDeque$deque___copy___exposer(String string) {
            super(string, 1, 1);
        }

        public PyDeque$deque___copy___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new PyDeque$deque___copy___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return ((PyDeque)this.self).deque___copy__();
        }
    }

    public class PyDeque$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            PyDeque pyDeque = new PyDeque(this.for_type);
            if (bl) {
                pyDeque.deque___init__(pyObjectArray, stringArray);
            }
            return pyDeque;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new PyDequeDerived(pyType);
        }
    }

    public class PyDeque$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public PyDeque$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{new PyDeque$deque___init___exposer("__init__"), new PyDeque$deque_append_exposer("append"), new PyDeque$deque_appendleft_exposer("appendleft"), new PyDeque$deque_clear_exposer("clear"), new PyDeque$deque_extend_exposer("extend"), new PyDeque$deque_extendleft_exposer("extendleft"), new PyDeque$deque_pop_exposer("pop"), new PyDeque$deque_popleft_exposer("popleft"), new PyDeque$deque_remove_exposer("remove"), new PyDeque$deque_rotate_exposer("rotate"), new PyDeque$deque_toString_exposer("__repr__"), new PyDeque$deque___len___exposer("__len__"), new PyDeque$deque___nonzero___exposer("__nonzero__"), new PyDeque$deque___getitem___exposer("__getitem__"), new PyDeque$deque___setitem___exposer("__setitem__"), new PyDeque$deque___delitem___exposer("__delitem__"), new PyDeque$deque___iter___exposer("__iter__"), new PyDeque$deque___eq___exposer("__eq__"), new PyDeque$deque___ne___exposer("__ne__"), new PyDeque$deque___lt___exposer("__lt__"), new PyDeque$deque___le___exposer("__le__"), new PyDeque$deque___gt___exposer("__gt__"), new PyDeque$deque___ge___exposer("__ge__"), new PyDeque$deque_hashCode_exposer("__hash__"), new PyDeque$deque___reduce___exposer("__reduce__"), new PyDeque$deque___copy___exposer("__copy__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{};
            super("collections.deque", PyDeque.class, Object.class, pyBuiltinFunctionArray, pyDataDescrArray, new PyDeque$exposed___new__());
        }
    }
}

