/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.random;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.modules.random.PyRandomDerived;

public class PyRandom
extends PyObject {
    public static final String exposed_name = "random";
    private static final PyType RANDOMTYPE = PyType.fromClass(PyRandom.class);
    protected Random javaRandom = new Random();

    public static void typeSetup(PyObject dict, PyType.Newstyle marker) {
        class Exposed_random
        extends PyBuiltinMethodNarrow {
            Exposed_random(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_random(self, this.info);
            }

            public PyObject __call__() {
                return ((PyRandom)this.self).random_random();
            }
        }
        dict.__setitem__(exposed_name, (PyObject)new PyMethodDescr(exposed_name, PyRandom.class, 0, 0, (PyBuiltinFunction)new Exposed_random(null, null)));
        class Exposed_seed
        extends PyBuiltinMethodNarrow {
            Exposed_seed(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_seed(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return ((PyRandom)this.self).random_seed(arg0);
            }

            public PyObject __call__() {
                return ((PyRandom)this.self).random_seed();
            }
        }
        dict.__setitem__("seed", (PyObject)new PyMethodDescr("seed", PyRandom.class, 0, 1, (PyBuiltinFunction)new Exposed_seed(null, null)));
        class Exposed_getstate
        extends PyBuiltinMethodNarrow {
            Exposed_getstate(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_getstate(self, this.info);
            }

            public PyObject __call__() {
                return ((PyRandom)this.self).random_getstate();
            }
        }
        dict.__setitem__("getstate", (PyObject)new PyMethodDescr("getstate", PyRandom.class, 0, 0, (PyBuiltinFunction)new Exposed_getstate(null, null)));
        class Exposed_setstate
        extends PyBuiltinMethodNarrow {
            Exposed_setstate(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_setstate(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return ((PyRandom)this.self).random_setstate(arg0);
            }
        }
        dict.__setitem__("setstate", (PyObject)new PyMethodDescr("setstate", PyRandom.class, 1, 1, (PyBuiltinFunction)new Exposed_setstate(null, null)));
        class Exposed_jumpahead
        extends PyBuiltinMethodNarrow {
            Exposed_jumpahead(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed_jumpahead(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                return ((PyRandom)this.self).random_jumpahead(arg0);
            }
        }
        dict.__setitem__("jumpahead", (PyObject)new PyMethodDescr("jumpahead", PyRandom.class, 1, 1, (PyBuiltinFunction)new Exposed_jumpahead(null, null)));
        class Exposed___init__
        extends PyBuiltinMethod {
            Exposed___init__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___init__(self, this.info);
            }

            public PyObject __call__(PyObject[] args) {
                return this.__call__(args, Py.NoKeywords);
            }

            public PyObject __call__(PyObject[] args, String[] keywords) {
                ((PyRandom)this.self).random_init(args, keywords);
                return Py.None;
            }
        }
        dict.__setitem__("__init__", (PyObject)new PyMethodDescr("__init__", PyRandom.class, -1, -1, (PyBuiltinFunction)new Exposed___init__(null, null)));
        dict.__setitem__("__new__", (PyObject)new PyNewWrapper(PyRandom.class, "__new__", -1, -1){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                PyRandom newobj;
                if (this.for_type == subtype) {
                    newobj = new PyRandom();
                    if (init) {
                        newobj.random_init(args, keywords);
                    }
                } else {
                    newobj = new PyRandomDerived(subtype);
                }
                return newobj;
            }
        });
    }

    public PyRandom() {
        this(RANDOMTYPE);
    }

    public PyRandom(PyType subType) {
        super(subType);
    }

    public PyObject random_seed() {
        return this.random_seed(new PyLong(System.currentTimeMillis()));
    }

    public PyObject random_seed(PyObject seed) {
        if (seed instanceof PyLong) {
            this.javaRandom.setSeed(((PyLong)seed).asLong(0));
        } else if (seed instanceof PyInteger) {
            this.javaRandom.setSeed(((PyInteger)seed).getValue());
        } else {
            this.javaRandom.setSeed(seed.hashCode());
        }
        return Py.None;
    }

    public void random_init(PyObject[] args, String[] keywords) {
    }

    public PyObject random_jumpahead(PyObject arg0) {
        long inc;
        if (arg0 instanceof PyLong) {
            inc = ((PyLong)arg0).asLong(0);
        } else if (arg0 instanceof PyInteger) {
            inc = ((PyInteger)arg0).getValue();
        } else {
            throw Py.TypeError("jumpahead requires an integer");
        }
        int i = 0;
        while ((long)i < inc) {
            this.javaRandom.nextInt();
            ++i;
        }
        return Py.None;
    }

    public PyObject random_setstate(PyObject arg0) {
        if (!(arg0 instanceof PyTuple)) {
            throw Py.TypeError("state vector must be a tuple");
        }
        try {
            Object[] arr = ((PyTuple)arg0).toArray();
            byte[] b = new byte[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] instanceof Integer)) {
                    throw Py.TypeError("state vector of unexpected type: " + arr[i].getClass());
                }
                b[i] = ((Integer)arr[i]).byteValue();
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(b);
            ObjectInputStream oin = new ObjectInputStream(bin);
            this.javaRandom = (Random)oin.readObject();
        }
        catch (IOException e) {
            throw Py.SystemError("state vector invalid: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw Py.SystemError("state vector invalid: " + e.getMessage());
        }
        return Py.None;
    }

    public PyObject random_getstate() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(this.javaRandom);
            byte[] b = bout.toByteArray();
            PyObject[] retarr = new PyInteger[b.length];
            for (int i = 0; i < b.length; ++i) {
                retarr[i] = new PyInteger(b[i]);
            }
            PyTuple ret = new PyTuple(retarr);
            return ret;
        }
        catch (IOException e) {
            throw Py.SystemError("creation of state vector failed: " + e.getMessage());
        }
    }

    public PyObject random_random() {
        long a = this.javaRandom.nextInt() >>> 5;
        long b = this.javaRandom.nextInt() >>> 6;
        double ret = ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
        return new PyFloat(ret);
    }
}

