/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.zipimport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.ArgParser;
import org.python.core.BytecodeLoader;
import org.python.core.FileUtil;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyCode;
import org.python.core.PyDataDescr;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyOverridableNew;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.imp;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.expose.generate.TypeExposer;
import org.python.modules.zipimport.zipimport;
import org.python.modules.zipimport.zipimporterDerived;

public class zipimporter
extends PyObject {
    public static final PyString __doc__;
    static final int IS_SOURCE = 0;
    static final int IS_BYTECODE = 1;
    static final int IS_PACKAGE = 2;
    static final SearchOrderEntry[] zip_searchorder;
    public String archive;
    public String prefix;
    public PyObject files;
    private PySystemState sys;

    public zipimporter() {
    }

    public zipimporter(PyType pyType) {
        super(pyType);
    }

    public zipimporter(String string) {
        this.zipimporter___init__(string);
    }

    @ExposedNew
    final void zipimporter___init__(PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser("__init__", pyObjectArray, stringArray, new String[]{"path"});
        String string = argParser.getString(0);
        this.zipimporter___init__(string);
    }

    private void zipimporter___init__(String string) {
        if (string == null || string.length() == 0) {
            throw zipimport.ZipImportError("archive path is empty");
        }
        File file = new File(string);
        this.sys = Py.getSystemState();
        this.prefix = "";
        while (true) {
            File file2;
            if ((file2 = new File(this.sys.getPath(file.getPath()))).isFile()) {
                this.archive = file.getPath();
                break;
            }
            File file3 = file.getParentFile();
            if (file3 == null) break;
            String string2 = file.getPath();
            this.prefix = string2.substring(string2.lastIndexOf(File.separator) + 1) + File.separator + this.prefix;
            file = file3;
        }
        if (this.archive != null) {
            this.files = zipimport._zip_directory_cache.__finditem__(this.archive);
            if (this.files == null) {
                this.files = this.readDirectory(this.archive);
                zipimport._zip_directory_cache.__setitem__(this.archive, this.files);
            }
        } else {
            throw zipimport.ZipImportError("not a Zip file");
        }
        if (this.prefix != "" && !this.prefix.endsWith(File.separator)) {
            this.prefix = this.prefix + File.separator;
        }
    }

    public PyObject find_module(String string) {
        return this.zipimporter_find_module(string, null);
    }

    public PyObject find_module(String string, String string2) {
        return this.zipimporter_find_module(string, string2);
    }

    final PyObject zipimporter_find_module(String string, String string2) {
        ModuleInfo moduleInfo = this.getModuleInfo(string);
        if (moduleInfo == ModuleInfo.ERROR || moduleInfo == ModuleInfo.NOT_FOUND) {
            return Py.None;
        }
        return this;
    }

    public PyObject load_module(String string) {
        return this.zipimporter_load_module(string);
    }

    final PyObject zipimporter_load_module(String string) {
        ModuleCodeData moduleCodeData = this.getModuleCode(string);
        if (moduleCodeData == null) {
            return Py.None;
        }
        PyModule pyModule = imp.addModule(string);
        pyModule.__dict__.__setitem__("__loader__", (PyObject)this);
        if (moduleCodeData.ispackage) {
            String string2 = this.archive + File.separator + this.prefix + this.getSubname(string);
            PyList pyList = new PyList();
            pyList.add(string2);
            pyModule.__dict__.__setitem__("__path__", (PyObject)pyList);
        }
        imp.createFromCode(string, moduleCodeData.code, moduleCodeData.path);
        Py.writeDebug("import", "import " + string + " # loaded from Zip " + moduleCodeData.path);
        return pyModule;
    }

    public String get_data(String string) {
        return this.zipimporter_get_data(string);
    }

    final String zipimporter_get_data(String string) {
        byte[] byArray;
        PyObject pyObject;
        int n = this.archive.length();
        if (n < string.length() && string.startsWith(this.archive + File.separator)) {
            string = string.substring(n + 1);
        }
        if ((pyObject = this.files.__finditem__(string)) == null) {
            throw Py.IOError(string);
        }
        InputStream inputStream = this.getDataStream(string);
        try {
            byArray = FileUtil.readBytes(inputStream);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return StringUtil.fromBytes(byArray);
    }

    public boolean is_package(String string) {
        return this.zipimporter_is_package(string);
    }

    final boolean zipimporter_is_package(String string) {
        ModuleInfo moduleInfo = this.getModuleInfo(string);
        if (moduleInfo == ModuleInfo.NOT_FOUND) {
            throw zipimport.ZipImportError("can't find module '" + string + "'");
        }
        return moduleInfo == ModuleInfo.PACKAGE;
    }

    public PyObject get_code(String string) {
        return this.zipimporter_get_code(string);
    }

    final PyObject zipimporter_get_code(String string) {
        ModuleCodeData moduleCodeData = this.getModuleCode(string);
        if (moduleCodeData != null) {
            return moduleCodeData.code;
        }
        return Py.None;
    }

    public String get_source(String string) {
        return this.zipimporter_get_source(string);
    }

    final String zipimporter_get_source(String string) {
        ModuleInfo moduleInfo = this.getModuleInfo(string);
        if (moduleInfo == ModuleInfo.ERROR) {
            return null;
        }
        if (moduleInfo == ModuleInfo.NOT_FOUND) {
            throw zipimport.ZipImportError("can't find module '" + string + "'");
        }
        String string2 = this.makeFilename(this.prefix, this.getSubname(string));
        string2 = moduleInfo == ModuleInfo.PACKAGE ? string2 + File.separator + "__init__.py" : string2 + ".py";
        PyObject pyObject = this.files.__finditem__(string2);
        if (pyObject != null) {
            return this.get_data(string2);
        }
        return null;
    }

    public InputStream getDataStream(String string) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(new File(this.sys.getPath(this.archive)));
        }
        catch (IOException iOException) {
            throw zipimport.ZipImportError("zipimport: can not open file: " + this.archive);
        }
        ZipEntry zipEntry = zipFile.getEntry(string);
        try {
            return zipFile.getInputStream(zipEntry);
        }
        catch (IOException iOException) {
            Py.writeDebug("import", "zipimporter.getDataStream exception: " + iOException.toString());
            throw zipimport.ZipImportError("zipimport: can not open file: " + this.archive);
        }
    }

    private ModuleInfo getModuleInfo(String string) {
        String string2 = this.makeFilename(this.prefix, this.getSubname(string));
        for (int i = 0; i < zip_searchorder.length; ++i) {
            SearchOrderEntry searchOrderEntry = zip_searchorder[i];
            PyObject pyObject = this.files.__finditem__(string2 + searchOrderEntry.suffix);
            if (pyObject == null) continue;
            if ((searchOrderEntry.type & 2) == 2) {
                return ModuleInfo.PACKAGE;
            }
            return ModuleInfo.MODULE;
        }
        return ModuleInfo.NOT_FOUND;
    }

    private ModuleCodeData getModuleCode(String string) {
        String string2 = this.makeFilename(this.prefix, this.getSubname(string));
        if (string2.length() < 0) {
            return null;
        }
        for (int i = 0; i < zip_searchorder.length; ++i) {
            boolean bl;
            SearchOrderEntry searchOrderEntry = zip_searchorder[i];
            String string3 = searchOrderEntry.suffix;
            String string4 = string2 + string3;
            Py.writeDebug("import", "# trying " + this.archive + File.separator + string2);
            PyObject pyObject = this.files.__finditem__(string4);
            if (pyObject == null) continue;
            boolean bl2 = (searchOrderEntry.type & 2) == 2;
            boolean bl3 = bl = (searchOrderEntry.type & 1) == 1;
            if (bl && this.isOutdatedBytecode(string4, pyObject)) continue;
            String string5 = this.archive + File.separator + string4;
            InputStream inputStream = this.getDataStream(string4);
            byte[] byArray = bl ? imp.unmarshalCode(string, inputStream, true) : imp.compileSource(string, inputStream, string5);
            imp.cacheCompiledSource(string5, null, byArray);
            PyCode pyCode = BytecodeLoader.makeCode(string + "$py", byArray, string5);
            if (pyCode == null) continue;
            return new ModuleCodeData(pyCode, bl2, string5);
        }
        return null;
    }

    private boolean isOutdatedBytecode(String string, PyObject pyObject) {
        String string2 = string.substring(0, string.length() - 9) + ".py";
        PyObject pyObject2 = this.files.__finditem__(string2);
        if (pyObject2 == null) {
            return false;
        }
        try {
            long l = this.dosTimeToEpoch(pyObject.__finditem__(5).asInt(0), pyObject.__finditem__(6).asInt(0));
            long l2 = this.dosTimeToEpoch(pyObject2.__finditem__(5).asInt(0), pyObject2.__finditem__(6).asInt(0));
            return l < l2;
        }
        catch (PyObject.ConversionException conversionException) {
            return false;
        }
    }

    private PyObject readDirectory(String string) {
        ZipFile zipFile;
        File file = new File(this.sys.getPath(string));
        if (!file.canRead()) {
            throw zipimport.ZipImportError("can't open Zip file: '" + string + "'");
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException iOException) {
            throw zipimport.ZipImportError("can't read Zip file: '" + string + "'");
        }
        PyDictionary pyDictionary = new PyDictionary();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            PyString pyString = new PyString(string + File.separator + zipEntry.getName());
            PyInteger pyInteger = new PyInteger(zipEntry.getMethod());
            PyLong pyLong = new PyLong(zipEntry.getCompressedSize());
            PyLong pyLong2 = new PyLong(zipEntry.getSize());
            PyInteger pyInteger2 = new PyInteger(-1);
            PyInteger pyInteger3 = new PyInteger(this.epochToDosTime(zipEntry.getTime()));
            PyInteger pyInteger4 = new PyInteger(this.epochToDosDate(zipEntry.getTime()));
            PyLong pyLong3 = new PyLong(zipEntry.getCrc());
            PyTuple pyTuple = new PyTuple(pyString, pyInteger, pyLong, pyLong2, pyInteger2, pyInteger3, pyInteger4, pyLong3);
            ((PyObject)pyDictionary).__setitem__(new PyString(zipEntry.getName()), (PyObject)pyTuple);
        }
        return pyDictionary;
    }

    private String getSubname(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    private String makeFilename(String string, String string2) {
        return string + string2.replace('.', File.separatorChar);
    }

    private int epochToDosDate(long l) {
        Date date = new Date(l);
        int n = date.getYear() + 1900;
        if (n < 1980) {
            return 0x210000;
        }
        return n - 1980 << 9 | date.getMonth() + 1 << 5 | date.getDate() << 0;
    }

    private int epochToDosTime(long l) {
        Date date = new Date(l);
        return date.getHours() << 11 | date.getMinutes() << 5 | date.getSeconds() >> 1;
    }

    private long dosTimeToEpoch(int n, int n2) {
        Date date = new Date((n2 >> 9 & 0x7F) + 80, (n2 >> 5 & 0xF) - 1, n2 & 0x1F, n >> 11 & 0x1F, n >> 5 & 0x3F, (n & 0x1F) * 2);
        return date.getTime();
    }

    public String toString() {
        return this.zipimporter_toString();
    }

    final String zipimporter_toString() {
        return "<zipimporter object \"" + this.archive + "\">";
    }

    static {
        PyType.addBuilder(zipimporter.class, new zipimporter$PyExposer());
        __doc__ = new PyString("zipimporter(archivepath) -> zipimporter object\n\nCreate a new zipimporter instance. 'archivepath' must be a path to\na zipfile. ZipImportError is raised if 'archivepath' doesn't point to\na valid Zip archive.");
        zip_searchorder = new SearchOrderEntry[]{new SearchOrderEntry("/__init__$py.class", 3), new SearchOrderEntry("/__init__.py", 2), new SearchOrderEntry("$py.class", 1), new SearchOrderEntry(".py", 0), new SearchOrderEntry("", 0)};
    }

    protected static class SearchOrderEntry {
        public String suffix;
        public int type;

        public SearchOrderEntry(String suffix, int type) {
            this.suffix = suffix;
            this.type = type;
        }
    }

    private class ModuleCodeData {
        PyCode code;
        boolean ispackage;
        String path;

        public ModuleCodeData(PyCode code, boolean ispackage, String path) {
            this.code = code;
            this.ispackage = ispackage;
            this.path = path;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ModuleInfo {
        ERROR,
        NOT_FOUND,
        MODULE,
        PACKAGE;

    }

    public class zipimporter$zipimporter___init___exposer
    extends PyBuiltinMethod {
        public zipimporter$zipimporter___init___exposer(String string) {
            super(string);
        }

        public zipimporter$zipimporter___init___exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new zipimporter$zipimporter___init___exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject[] pyObjectArray, String[] stringArray) {
            ((zipimporter)this.self).zipimporter___init__(pyObjectArray, stringArray);
            return Py.None;
        }
    }

    public class zipimporter$zipimporter_find_module_exposer
    extends PyBuiltinMethodNarrow {
        public zipimporter$zipimporter_find_module_exposer(String string) {
            super(string, 2, 3);
        }

        public zipimporter$zipimporter_find_module_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new zipimporter$zipimporter_find_module_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
            return ((zipimporter)this.self).zipimporter_find_module(pyObject.asString(), pyObject2.asStringOrNull());
        }

        public PyObject __call__(PyObject pyObject) {
            return ((zipimporter)this.self).zipimporter_find_module(pyObject.asString(), null);
        }
    }

    public class zipimporter$zipimporter_load_module_exposer
    extends PyBuiltinMethodNarrow {
        public zipimporter$zipimporter_load_module_exposer(String string) {
            super(string, 2, 2);
        }

        public zipimporter$zipimporter_load_module_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new zipimporter$zipimporter_load_module_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((zipimporter)this.self).zipimporter_load_module(pyObject.asString());
        }
    }

    public class zipimporter$zipimporter_get_data_exposer
    extends PyBuiltinMethodNarrow {
        public zipimporter$zipimporter_get_data_exposer(String string) {
            super(string, 2, 2);
        }

        public zipimporter$zipimporter_get_data_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new zipimporter$zipimporter_get_data_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((zipimporter)this.self).zipimporter_get_data(pyObject.asString()));
        }
    }

    public class zipimporter$zipimporter_is_package_exposer
    extends PyBuiltinMethodNarrow {
        public zipimporter$zipimporter_is_package_exposer(String string) {
            super(string, 2, 2);
        }

        public zipimporter$zipimporter_is_package_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new zipimporter$zipimporter_is_package_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newBoolean(((zipimporter)this.self).zipimporter_is_package(pyObject.asString()));
        }
    }

    public class zipimporter$zipimporter_get_code_exposer
    extends PyBuiltinMethodNarrow {
        public zipimporter$zipimporter_get_code_exposer(String string) {
            super(string, 2, 2);
        }

        public zipimporter$zipimporter_get_code_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new zipimporter$zipimporter_get_code_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return ((zipimporter)this.self).zipimporter_get_code(pyObject.asString());
        }
    }

    public class zipimporter$zipimporter_get_source_exposer
    extends PyBuiltinMethodNarrow {
        public zipimporter$zipimporter_get_source_exposer(String string) {
            super(string, 2, 2);
        }

        public zipimporter$zipimporter_get_source_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new zipimporter$zipimporter_get_source_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__(PyObject pyObject) {
            return Py.newString(((zipimporter)this.self).zipimporter_get_source(pyObject.asString()));
        }
    }

    public class zipimporter$zipimporter_toString_exposer
    extends PyBuiltinMethodNarrow {
        public zipimporter$zipimporter_toString_exposer(String string) {
            super(string, 1, 1);
        }

        public zipimporter$zipimporter_toString_exposer(PyType pyType, PyObject pyObject, PyBuiltinFunction.Info info) {
            super(pyType, pyObject, info);
        }

        public PyBuiltinFunction bind(PyObject pyObject) {
            return new zipimporter$zipimporter_toString_exposer(this.getType(), pyObject, this.info);
        }

        public PyObject __call__() {
            return Py.newString(((zipimporter)this.self).zipimporter_toString());
        }
    }

    public class zipimporter$_files_descriptor
    extends PyDataDescr {
        public zipimporter$_files_descriptor() {
            super(zipimporter.class, "_files", PyObject.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((zipimporter)pyObject).files;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class zipimporter$archive_descriptor
    extends PyDataDescr {
        public zipimporter$archive_descriptor() {
            super(zipimporter.class, "archive", String.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((zipimporter)pyObject).archive;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class zipimporter$__doc___descriptor
    extends PyDataDescr {
        public zipimporter$__doc___descriptor() {
            super(zipimporter.class, "__doc__", PyString.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((zipimporter)pyObject).__doc__;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class zipimporter$prefix_descriptor
    extends PyDataDescr {
        public zipimporter$prefix_descriptor() {
            super(zipimporter.class, "prefix", String.class);
        }

        public Object invokeGet(PyObject pyObject) {
            return ((zipimporter)pyObject).prefix;
        }

        public boolean implementsDescrSet() {
            return false;
        }

        public boolean implementsDescrDelete() {
            return false;
        }
    }

    public class zipimporter$exposed___new__
    extends PyOverridableNew {
        public PyObject createOfType(boolean bl, PyObject[] pyObjectArray, String[] stringArray) {
            zipimporter zipimporter2 = new zipimporter(this.for_type);
            if (bl) {
                zipimporter2.zipimporter___init__(pyObjectArray, stringArray);
            }
            return zipimporter2;
        }

        public PyObject createOfSubtype(PyType pyType) {
            return new zipimporterDerived(pyType);
        }
    }

    public class zipimporter$PyExposer
    extends TypeExposer.BaseTypeBuilder {
        public zipimporter$PyExposer() {
            PyBuiltinFunction[] pyBuiltinFunctionArray = new PyBuiltinFunction[]{new zipimporter$zipimporter___init___exposer("__init__"), new zipimporter$zipimporter_find_module_exposer("find_module"), new zipimporter$zipimporter_load_module_exposer("load_module"), new zipimporter$zipimporter_get_data_exposer("get_data"), new zipimporter$zipimporter_is_package_exposer("is_package"), new zipimporter$zipimporter_get_code_exposer("get_code"), new zipimporter$zipimporter_get_source_exposer("get_source"), new zipimporter$zipimporter_toString_exposer("__repr__")};
            PyDataDescr[] pyDataDescrArray = new PyDataDescr[]{new zipimporter$_files_descriptor(), new zipimporter$archive_descriptor(), new zipimporter$__doc___descriptor(), new zipimporter$prefix_descriptor()};
            super("zipimport.zipimporter", zipimporter.class, Object.class, pyBuiltinFunctionArray, pyDataDescrArray, new zipimporter$exposed___new__());
        }
    }
}

