/*
 * Decompiled with CFR 0.152.
 */
package org.python.newcompiler.asm;

import org.objectweb.asm.AnnotationVisitor;
import org.python.newcompiler.DisassemblyDocument;
import org.python.newcompiler.asm.ClassDis;

class AnnotationDis
implements AnnotationVisitor {
    private AnnotationVisitor next;
    private DisassemblyDocument debugger;

    AnnotationDis(AnnotationVisitor next, DisassemblyDocument debugger) {
        this.next = next;
        this.debugger = debugger;
    }

    public void visit(String name, Object value) {
        this.next.visit(name, value);
        this.debugger.put(name + " = " + value);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationVisitor visitor = this.next.visitAnnotation(name, desc);
        DisassemblyDocument subAnnotation = this.debugger.newSubSection();
        subAnnotation.putTitle(name + " " + ClassDis.formatAnnotation(desc, true));
        return new AnnotationDis(visitor, subAnnotation);
    }

    public AnnotationVisitor visitArray(String name) {
        AnnotationVisitor visitor = this.next.visitArray(name);
        this.debugger.put(name + " is an array");
        if (visitor != null) {
            return new AnnotationDis(visitor, this.debugger);
        }
        return null;
    }

    public void visitEnd() {
        this.next.visitEnd();
    }

    public void visitEnum(String name, String desc, String value) {
        this.next.visitEnum(name, desc, value);
        this.debugger.put(desc + " " + name + " = " + value);
    }
}

