/*
 * Decompiled with CFR 0.152.
 */
package org.python.newcompiler.asm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.python.newcompiler.DisassemblyDocument;
import org.python.newcompiler.asm.AnnotationDis;
import org.python.newcompiler.asm.FieldDis;
import org.python.newcompiler.asm.MethodDis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDis
extends ClassAdapter {
    private static Map<Integer, String> accessModes = new HashMap<Integer, String>();
    private DisassemblyDocument debugger;

    public static String join(String sep, String[] strings) {
        String result = "";
        String addSep = "";
        for (String string : strings) {
            result = result + addSep + string;
            addSep = sep;
        }
        return result;
    }

    public static String join(String sep, Iterable<String> strings) {
        String result = "";
        String addSep = "";
        for (String string : strings) {
            result = result + addSep + string;
            addSep = sep;
        }
        return result;
    }

    public static String formatAnnotation(String desc, boolean visible) {
        return "@" + desc + (visible ? "" : " /* only visible at compile time */");
    }

    public static String formatAttribute(Attribute attr) {
        return "/* ATTRIBUTE: type=" + attr.type + " */";
    }

    public static String accessToString(int access) {
        LinkedList<String> modes = new LinkedList<String>();
        for (int mode : accessModes.keySet()) {
            String modeString = accessModes.get(access & mode);
            if (modeString == null) continue;
            modes.add(modeString);
        }
        return ClassDis.join(" ", modes);
    }

    public ClassDis(ClassVisitor next, DisassemblyDocument debugger) {
        super(next);
        this.debugger = debugger;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        if (signature == null) {
            signature = "";
        }
        this.debugger.putTitle(ClassDis.accessToString(access) + " class " + name + signature + " extends " + superName + " implements " + ClassDis.join(", ", interfaces));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor next = super.visitAnnotation(desc, visible);
        DisassemblyDocument preTitle = this.debugger.newPreTitle();
        preTitle.putTitle(ClassDis.formatAnnotation(desc, visible));
        if (next != null) {
            return new AnnotationDis(next, preTitle);
        }
        return null;
    }

    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        this.debugger.putTitle(ClassDis.formatAttribute(attr));
    }

    public void visitEnd() {
        super.visitEnd();
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor next = super.visitField(access, name, desc, signature, value);
        DisassemblyDocument fieldSection = this.debugger.newSubSection();
        String valueString = value != null ? " = " + value.toString() : "";
        fieldSection.putTitle(ClassDis.accessToString(access) + " " + desc + " " + name + valueString);
        if (next != null) {
            return new FieldDis(next, fieldSection);
        }
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        super.visitInnerClass(name, outerName, innerName, access);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions2) {
        MethodVisitor next = super.visitMethod(access, name, desc, signature, exceptions2);
        DisassemblyDocument methodSection = this.debugger.newSubSection();
        return new MethodDis(next, methodSection);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        super.visitOuterClass(owner, name, desc);
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
        this.debugger.putTitle("Source: " + source);
    }

    static {
        accessModes.put(0, null);
        accessModes.put(1024, "abstract");
        accessModes.put(8192, "annotation");
        accessModes.put(64, "bridge");
        accessModes.put(131072, "deprecated");
        accessModes.put(16, "final");
        accessModes.put(256, "native");
        accessModes.put(2, "private");
        accessModes.put(4, "protected");
        accessModes.put(1, "public");
        accessModes.put(8, "static");
        accessModes.put(2048, "strict");
        accessModes.put(32, "super");
        accessModes.put(32, "synchronized");
        accessModes.put(4096, "synthetic");
        accessModes.put(128, "transient");
        accessModes.put(128, "varargs");
        accessModes.put(64, "volatile");
    }
}

