/*
 * Decompiled with CFR 0.152.
 */
package org.python.newcompiler.asm;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.python.newcompiler.DisassemblyDocument;
import org.python.newcompiler.asm.AnnotationDis;
import org.python.newcompiler.asm.ClassDis;

class MethodDis
extends MethodAdapter {
    private DisassemblyDocument debugger;
    private int insnCounter;
    private static Map<Integer, String> instructionNames = new HashMap<Integer, String>();

    MethodDis(MethodVisitor next, DisassemblyDocument debugger) {
        super(next);
        this.debugger = debugger;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor next = super.visitAnnotation(desc, visible);
        DisassemblyDocument preTitle = this.debugger.newPreTitle();
        preTitle.putTitle(ClassDis.formatAnnotation(desc, visible));
        if (next != null) {
            return new AnnotationDis(next, preTitle);
        }
        return null;
    }

    public AnnotationVisitor visitAnnotationDefault() {
        AnnotationVisitor next = super.visitAnnotationDefault();
        if (next != null) {
            return new AnnotationDis(next, this.debugger.newPreTitle());
        }
        return null;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        AnnotationVisitor next = super.visitParameterAnnotation(parameter, desc, visible);
        DisassemblyDocument subSection = this.debugger.newSubSection();
        subSection.putTitle("Local variable " + parameter + " " + ClassDis.formatAnnotation(desc, visible));
        if (next != null) {
            return new AnnotationDis(next, subSection);
        }
        return null;
    }

    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        this.debugger.putTitle(ClassDis.formatAttribute(attr));
    }

    public void visitCode() {
        super.visitCode();
    }

    public void visitEnd() {
        super.visitEnd();
    }

    private void write(String string) {
        this.debugger.put(this.insnCounter++, string);
    }

    private void write(int opcode, String params) {
        this.write(instructionNames.get(opcode) + " " + params);
    }

    private void formatVariables(Object[] variables, DisassemblyDocument section) {
        for (Object variable : variables) {
            if (Opcodes.TOP.equals(variable)) continue;
            if (Opcodes.INTEGER.equals(variable)) {
                section.put("int");
                continue;
            }
            if (Opcodes.FLOAT.equals(variable)) {
                section.put("float");
                continue;
            }
            if (Opcodes.DOUBLE.equals(variable)) {
                section.put("double");
                continue;
            }
            if (Opcodes.LONG.equals(variable)) {
                section.put("long");
                continue;
            }
            if (Opcodes.NULL.equals(variable)) {
                section.put("null");
                continue;
            }
            if (Opcodes.UNINITIALIZED_THIS.equals(variable)) {
                section.put("this");
                continue;
            }
            if (variable instanceof String) {
                String type = (String)variable;
                section.put(type);
                continue;
            }
            if (variable instanceof Label) {
                Label initialization = (Label)variable;
                section.put("Object created at " + initialization);
                continue;
            }
            section.put("UNKNOWN TYPE");
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        this.write(opcode, owner + "." + name + " : " + desc);
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        super.visitFrame(type, nLocal, local, nStack, stack);
        switch (type) {
            case -1: {
                this.write("NEW Frame: " + nLocal + " locals, " + nStack + " stack elements.");
                break;
            }
            case 3: {
                this.write("SAME Frame: " + nLocal + " locals, " + nStack + " stack elements.");
                break;
            }
            case 4: {
                this.write("SAME Frame + 1 stack element: " + nLocal + " locals, " + nStack + " stack elements.");
                break;
            }
            case 1: {
                this.write("APPENDED Frame: " + nLocal + " locals added, " + nStack + " stack elements.");
                break;
            }
            case 2: {
                this.write("CHOPPED Frame: " + nLocal + " locals removed, stack emptied, " + nStack + " stack elements.");
                break;
            }
            case 0: {
                this.write("FULL Frame: " + nLocal + " locals, " + nStack + " stack elements.");
                break;
            }
        }
        DisassemblyDocument localSection = this.debugger.newSubSection();
        localSection.putTitle("Frame Locals:");
        this.formatVariables(local, localSection);
        DisassemblyDocument stackSection = this.debugger.newSubSection();
        stackSection.putTitle("Frame Stack elements:");
        this.formatVariables(stack, stackSection);
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.write("Iinc " + var + " " + increment);
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        this.write(opcode, "");
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.write(opcode, "" + operand);
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        this.write(opcode, label.toString());
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.debugger.putLabel(label.toString());
    }

    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        this.write("Load Constant " + cst);
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.write("Line number: " + line + " at " + start);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, signature, start, end, index);
        this.debugger.put(desc + (signature != null ? "<" + signature + ">" : "") + " " + name + " : " + index + " from " + start + " to " + end);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.write("Lookup Switch");
        DisassemblyDocument lookup = this.debugger.newSubSection();
        for (int i = 0; i < keys.length; ++i) {
            lookup.put("case " + keys[i] + ": " + labels[i]);
        }
        lookup.put("default: " + dflt);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        super.visitMaxs(maxStack, maxLocals);
        this.debugger.put("Max Stack: " + maxStack);
        this.debugger.put("Max Locals: " + maxLocals);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        super.visitMethodInsn(opcode, owner, name, desc);
        this.write(opcode, desc + " " + owner + "." + name);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(desc, dims);
        this.write("MultiANewArray " + desc + " " + dims + " dimensions");
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.write("Table Switch");
        DisassemblyDocument lookup = this.debugger.newSubSection();
        int i = 0;
        while (min + i <= max) {
            lookup.put("case " + (min + i) + ": " + labels[i]);
            ++i;
        }
        lookup.put("default: " + dflt);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        this.debugger.put("TryCatchBlock of " + type + " from " + start + " to " + end + " handled by: " + handler);
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        this.write(opcode, type);
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.write(opcode, "" + var);
    }

    static {
        instructionNames.put(0, "NOP");
        instructionNames.put(1, "ACONST_NULL");
        instructionNames.put(2, "ICONST_M1");
        instructionNames.put(3, "ICONST_0");
        instructionNames.put(4, "ICONST_1");
        instructionNames.put(5, "ICONST_2");
        instructionNames.put(6, "ICONST_3");
        instructionNames.put(7, "ICONST_4");
        instructionNames.put(8, "ICONST_5");
        instructionNames.put(9, "LCONST_0");
        instructionNames.put(10, "LCONST_1");
        instructionNames.put(11, "FCONST_0");
        instructionNames.put(12, "FCONST_1");
        instructionNames.put(13, "FCONST_2");
        instructionNames.put(14, "DCONST_0");
        instructionNames.put(15, "DCONST_1");
        instructionNames.put(46, "IALOAD");
        instructionNames.put(47, "LALOAD");
        instructionNames.put(48, "FALOAD");
        instructionNames.put(49, "DALOAD");
        instructionNames.put(50, "AALOAD");
        instructionNames.put(51, "BALOAD");
        instructionNames.put(52, "CALOAD");
        instructionNames.put(53, "SALOAD");
        instructionNames.put(79, "IASTORE");
        instructionNames.put(80, "LASTORE");
        instructionNames.put(81, "FASTORE");
        instructionNames.put(82, "DASTORE");
        instructionNames.put(83, "AASTORE");
        instructionNames.put(84, "BASTORE");
        instructionNames.put(85, "CASTORE");
        instructionNames.put(86, "SASTORE");
        instructionNames.put(87, "POP");
        instructionNames.put(88, "POP2");
        instructionNames.put(89, "DUP");
        instructionNames.put(90, "DUP_X1");
        instructionNames.put(91, "DUP_X2");
        instructionNames.put(92, "DUP2");
        instructionNames.put(93, "DUP2_X1");
        instructionNames.put(94, "DUP2_X2");
        instructionNames.put(95, "SWAP");
        instructionNames.put(96, "IADD");
        instructionNames.put(97, "LADD");
        instructionNames.put(98, "FADD");
        instructionNames.put(99, "DADD");
        instructionNames.put(100, "ISUB");
        instructionNames.put(101, "LSUB");
        instructionNames.put(102, "FSUB");
        instructionNames.put(103, "DSUB");
        instructionNames.put(104, "IMUL");
        instructionNames.put(105, "LMUL");
        instructionNames.put(106, "FMUL");
        instructionNames.put(107, "DMUL");
        instructionNames.put(108, "IDIV");
        instructionNames.put(109, "LDIV");
        instructionNames.put(110, "FDIV");
        instructionNames.put(111, "DDIV");
        instructionNames.put(112, "IREM");
        instructionNames.put(113, "LREM");
        instructionNames.put(114, "FREM");
        instructionNames.put(115, "DREM");
        instructionNames.put(116, "INEG");
        instructionNames.put(117, "LNEG");
        instructionNames.put(118, "FNEG");
        instructionNames.put(119, "DNEG");
        instructionNames.put(120, "ISHL");
        instructionNames.put(121, "LSHL");
        instructionNames.put(122, "ISHR");
        instructionNames.put(123, "LSHR");
        instructionNames.put(124, "IUSHR");
        instructionNames.put(125, "LUSHR");
        instructionNames.put(126, "IAND");
        instructionNames.put(127, "LAND");
        instructionNames.put(128, "IOR");
        instructionNames.put(129, "LOR");
        instructionNames.put(130, "IXOR");
        instructionNames.put(131, "LXOR");
        instructionNames.put(133, "I2L");
        instructionNames.put(134, "I2F");
        instructionNames.put(135, "I2D");
        instructionNames.put(136, "L2I");
        instructionNames.put(137, "L2F");
        instructionNames.put(138, "L2D");
        instructionNames.put(139, "F2I");
        instructionNames.put(140, "F2L");
        instructionNames.put(141, "F2D");
        instructionNames.put(142, "D2I");
        instructionNames.put(143, "D2L");
        instructionNames.put(144, "D2F");
        instructionNames.put(145, "I2B");
        instructionNames.put(146, "I2C");
        instructionNames.put(147, "I2S");
        instructionNames.put(148, "LCMP");
        instructionNames.put(149, "FCMPL");
        instructionNames.put(150, "FCMPG");
        instructionNames.put(151, "DCMPL");
        instructionNames.put(152, "DCMPG");
        instructionNames.put(172, "IRETURN");
        instructionNames.put(173, "LRETURN");
        instructionNames.put(174, "FRETURN");
        instructionNames.put(175, "DRETURN");
        instructionNames.put(176, "ARETURN");
        instructionNames.put(177, "RETURN");
        instructionNames.put(190, "ARRAYLENGTH");
        instructionNames.put(191, "ATHROW");
        instructionNames.put(194, "MONITORENTER");
        instructionNames.put(195, "MONITOREXIT");
        instructionNames.put(16, "BIPUSH");
        instructionNames.put(17, "SIPUSH");
        instructionNames.put(188, "NEWARRAY");
        instructionNames.put(21, "ILOAD");
        instructionNames.put(22, "LLOAD");
        instructionNames.put(23, "FLOAD");
        instructionNames.put(24, "DLOAD");
        instructionNames.put(25, "ALOAD");
        instructionNames.put(54, "ISTORE");
        instructionNames.put(55, "LSTORE");
        instructionNames.put(56, "FSTORE");
        instructionNames.put(57, "DSTORE");
        instructionNames.put(58, "ASTORE");
        instructionNames.put(169, "RET");
        instructionNames.put(187, "NEW");
        instructionNames.put(189, "ANEWARRAY");
        instructionNames.put(192, "CHECKCAST");
        instructionNames.put(193, "INSTANCEOF");
        instructionNames.put(178, "GETSTATIC");
        instructionNames.put(179, "PUTSTATIC");
        instructionNames.put(180, "GETFIELD");
        instructionNames.put(181, "PUTFIELD");
        instructionNames.put(182, "INVOKEVIRTUAL");
        instructionNames.put(183, "INVOKESPECIAL");
        instructionNames.put(184, "INVOKESTATIC");
        instructionNames.put(185, "INVOKEINTERFACE");
        instructionNames.put(153, "IFEQ");
        instructionNames.put(154, "IFNE");
        instructionNames.put(155, "IFLT");
        instructionNames.put(156, "IFGE");
        instructionNames.put(157, "IFGT");
        instructionNames.put(158, "IFLE");
        instructionNames.put(159, "IF_ICMPEQ");
        instructionNames.put(160, "IF_ICMPNE");
        instructionNames.put(161, "IF_ICMPLT");
        instructionNames.put(162, "IF_ICMPGE");
        instructionNames.put(163, "IF_ICMPGT");
        instructionNames.put(164, "IF_ICMPLE");
        instructionNames.put(165, "IF_ACMPEQ");
        instructionNames.put(166, "IF_ACMPNE");
        instructionNames.put(167, "GOTO");
        instructionNames.put(168, "JSR");
        instructionNames.put(198, "IFNULL");
        instructionNames.put(199, "IFNONNULL");
    }
}

