/*
 * Decompiled with CFR 0.152.
 */
package org.python.newcompiler.asm;

import java.io.PrintWriter;
import java.util.Formatter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.util.TraceClassVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;

public class OffsetTracer
extends TraceClassVisitor {
    public OffsetTracer(ClassVisitor cv, PrintWriter pw) {
        super(cv, pw);
    }

    public OffsetTracer(PrintWriter pw) {
        super(pw);
    }

    protected TraceMethodVisitor createTraceMethodVisitor() {
        return OffsetTracer.createTMV(2);
    }

    public static TraceMethodVisitor createTMV(final int width) {
        return new TraceMethodVisitor(){
            private int insnCounter = 0;

            private void printInsnCount(int count) {
                this.buf.setLength(0);
                Formatter formatter = new Formatter(this.buf);
                formatter.format("insn %" + width + "d:", new Integer(count));
                this.text.add(this.buf.toString());
            }

            private void printInsnCount() {
                this.printInsnCount(this.insnCounter++);
            }

            public void visitLabel(Label arg0) {
                this.printInsnCount();
                super.visitLabel(arg0);
            }

            public void visitFrame(int arg0, int arg1, Object[] arg2, int arg3, Object[] arg4) {
                this.printInsnCount();
                super.visitFrame(arg0, arg1, arg2, arg3, arg4);
            }

            public void visitLineNumber(int arg0, Label arg1) {
                this.printInsnCount();
                super.visitLineNumber(arg0, arg1);
            }

            public void visitFieldInsn(int arg0, String arg1, String arg2, String arg3) {
                this.printInsnCount();
                super.visitFieldInsn(arg0, arg1, arg2, arg3);
            }

            public void visitIincInsn(int arg0, int arg1) {
                this.printInsnCount();
                super.visitIincInsn(arg0, arg1);
            }

            public void visitInsn(int arg0) {
                this.printInsnCount();
                super.visitInsn(arg0);
            }

            public void visitIntInsn(int arg0, int arg1) {
                this.printInsnCount();
                super.visitIntInsn(arg0, arg1);
            }

            public void visitJumpInsn(int arg0, Label arg1) {
                this.printInsnCount();
                super.visitJumpInsn(arg0, arg1);
            }

            public void visitLdcInsn(Object arg0) {
                this.printInsnCount();
                super.visitLdcInsn(arg0);
            }

            public void visitLookupSwitchInsn(Label arg0, int[] arg1, Label[] arg2) {
                this.printInsnCount();
                super.visitLookupSwitchInsn(arg0, arg1, arg2);
            }

            public void visitMethodInsn(int arg0, String arg1, String arg2, String arg3) {
                this.printInsnCount();
                super.visitMethodInsn(arg0, arg1, arg2, arg3);
            }

            public void visitMultiANewArrayInsn(String arg0, int arg1) {
                this.printInsnCount();
                super.visitMultiANewArrayInsn(arg0, arg1);
            }

            public void visitTableSwitchInsn(int arg0, int arg1, Label arg2, Label[] arg3) {
                this.printInsnCount();
                super.visitTableSwitchInsn(arg0, arg1, arg2, arg3);
            }

            public void visitTypeInsn(int arg0, String arg1) {
                this.printInsnCount();
                super.visitTypeInsn(arg0, arg1);
            }

            public void visitVarInsn(int arg0, int arg1) {
                this.printInsnCount();
                super.visitVarInsn(arg0, arg1);
            }
        };
    }
}

