/*
 * Decompiled with CFR 0.152.
 */
package org.python.newcompiler.pyasm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.python.newcompiler.pyasm.BytecodeError;
import org.python.newcompiler.pyasm.BytecodeVisitor;
import org.python.newcompiler.pyasm.Label;
import org.python.newcompiler.pyasm.PythonOpCodes;

public class CodeReader
implements PythonOpCodes {
    private char[] bytes;
    private int pos;
    private int codePosition;
    private Iterable instructions;
    private SortedMap lineNumberTable;

    public CodeReader(char[] bytes, int firstLineNumber, char[] lineNumberTable) throws BytecodeError {
        this.bytes = bytes;
        this.pos = 0;
        this.lineNumberTable = CodeReader.buildLineNumberTable(firstLineNumber, lineNumberTable);
        this.instructions = this.interpret();
    }

    public static SortedMap buildLineNumberTable(int lineNumber, char[] lineNumberTable) {
        TreeMap<Integer, Integer> table = new TreeMap<Integer, Integer>();
        int bytecodeOffset = 0;
        int i = 0;
        while (i < lineNumberTable.length) {
            bytecodeOffset += lineNumberTable[i++];
            char lineInc = lineNumberTable[i++];
            lineNumber += lineInc;
            if (lineInc == '\u0000') continue;
            table.put(new Integer(bytecodeOffset), new Integer(lineNumber));
        }
        return table;
    }

    public final void accept(BytecodeVisitor visitor) {
        Iterator iter = this.instructions.iterator();
        while (iter.hasNext()) {
            ((VisitableInstruction)iter.next()).accept(visitor);
        }
        visitor.visitEnd();
    }

    protected char read() {
        return this.bytes[this.pos++];
    }

    protected boolean hasData() {
        return this.pos < this.bytes.length;
    }

    private int readArg() {
        char a = this.read();
        char b = this.read();
        return a + (b << 8);
    }

    private int getAbsoluteAddress(int relative) {
        return this.pos + relative;
    }

    private Iterable interpret() throws BytecodeError {
        RawVisitor visitor = new RawVisitor();
        block89: while (this.hasData()) {
            this.codePosition = this.pos;
            char op = this.read();
            int arg = 0;
            if (op >= 'Z') {
                arg = this.readArg();
                if (op == '\u008f') {
                    op = this.read();
                    arg = (arg << 16) + this.readArg();
                }
            }
            switch (op) {
                case '\u0000': {
                    visitor.visitStopCode();
                    continue block89;
                }
                case '\u0001': {
                    visitor.visitPop();
                    continue block89;
                }
                case '\u0002': {
                    visitor.visitRotTwo();
                    continue block89;
                }
                case '\u0003': {
                    visitor.visitRotThree();
                    continue block89;
                }
                case '\u0004': {
                    visitor.visitDup();
                    continue block89;
                }
                case '\u0005': {
                    visitor.visitRotFour();
                    continue block89;
                }
                case '\t': {
                    visitor.visitNOP();
                    continue block89;
                }
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case '\u000f': {
                    visitor.visitUnaryOperation(op);
                    continue block89;
                }
                case '\u0012': {
                    visitor.visitListAppend();
                    continue block89;
                }
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': {
                    visitor.visitBinaryOperator(op);
                    continue block89;
                }
                case '\u001c': 
                case '\u001d': {
                    visitor.visitInplaceOperator(op);
                    continue block89;
                }
                case '\u001e': {
                    visitor.visitSlice(0);
                    continue block89;
                }
                case '\u001f': {
                    visitor.visitSlice(1);
                    continue block89;
                }
                case ' ': {
                    visitor.visitSlice(2);
                    continue block89;
                }
                case '!': {
                    visitor.visitSlice(3);
                    continue block89;
                }
                case '(': {
                    visitor.visitStoreSlice(0);
                    continue block89;
                }
                case ')': {
                    visitor.visitStoreSlice(1);
                    continue block89;
                }
                case '*': {
                    visitor.visitStoreSlice(2);
                    continue block89;
                }
                case '+': {
                    visitor.visitStoreSlice(3);
                    continue block89;
                }
                case '2': {
                    visitor.visitDeleteSlice(0);
                    continue block89;
                }
                case '3': {
                    visitor.visitDeleteSlice(1);
                    continue block89;
                }
                case '4': {
                    visitor.visitDeleteSlice(2);
                    continue block89;
                }
                case '5': {
                    visitor.visitDeleteSlice(3);
                    continue block89;
                }
                case '7': 
                case '8': 
                case '9': 
                case ':': 
                case ';': {
                    visitor.visitInplaceOperator(op);
                    continue block89;
                }
                case '<': {
                    visitor.visitStoreSubscript();
                    continue block89;
                }
                case '=': {
                    visitor.visitDeleteSubscript();
                    continue block89;
                }
                case '>': 
                case '?': 
                case '@': 
                case 'A': 
                case 'B': {
                    visitor.visitBinaryOperator(op);
                    continue block89;
                }
                case 'C': {
                    visitor.visitInplaceOperator(op);
                    continue block89;
                }
                case 'D': {
                    visitor.visitGetIterator();
                    continue block89;
                }
                case 'F': {
                    visitor.visitPrintExpression();
                    continue block89;
                }
                case 'G': {
                    visitor.visitPrintItem();
                    continue block89;
                }
                case 'H': {
                    visitor.visitPrintNewline();
                    continue block89;
                }
                case 'I': {
                    visitor.visitPrintItemTo();
                    continue block89;
                }
                case 'J': {
                    visitor.visitPrintNewlineTo();
                    continue block89;
                }
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': {
                    visitor.visitInplaceOperator(op);
                    continue block89;
                }
                case 'P': {
                    visitor.visitBreakLoop();
                    continue block89;
                }
                case 'Q': {
                    visitor.visitWithCleanup();
                    continue block89;
                }
                case 'R': {
                    visitor.visitLoadLocals();
                    continue block89;
                }
                case 'S': {
                    visitor.visitReturnValue();
                    continue block89;
                }
                case 'T': {
                    visitor.visitImportStar();
                    continue block89;
                }
                case 'U': {
                    visitor.visitExecStatement();
                    continue block89;
                }
                case 'V': {
                    visitor.visitYieldValue();
                    continue block89;
                }
                case 'W': {
                    visitor.visitPopBlock();
                    continue block89;
                }
                case 'X': {
                    visitor.visitEndFinally();
                    continue block89;
                }
                case 'Y': {
                    visitor.visitBuildClass();
                    continue block89;
                }
                case 'Z': {
                    visitor.visitStoreName(arg);
                    continue block89;
                }
                case '[': {
                    visitor.visitDeleteName(arg);
                    continue block89;
                }
                case '\\': {
                    visitor.visitUnpackSequence(arg);
                    continue block89;
                }
                case ']': {
                    visitor.visitForIteration(arg);
                    continue block89;
                }
                case '_': {
                    visitor.visitStoreAttribute(arg);
                    continue block89;
                }
                case '`': {
                    visitor.visitDeleteAttribute(arg);
                    continue block89;
                }
                case 'a': {
                    visitor.visitStoreGlobal(arg);
                    continue block89;
                }
                case 'b': {
                    visitor.visitDeleteGlobal(arg);
                    continue block89;
                }
                case 'c': {
                    visitor.visitDupTopX(arg);
                    continue block89;
                }
                case 'd': {
                    visitor.visitLoadConstant(arg);
                    continue block89;
                }
                case 'e': {
                    visitor.visitLoadName(arg);
                    continue block89;
                }
                case 'f': {
                    visitor.visitBuildTuple(arg);
                    continue block89;
                }
                case 'g': {
                    visitor.visitBuildList(arg);
                    continue block89;
                }
                case 'h': {
                    visitor.visitBuildMap(arg);
                    continue block89;
                }
                case 'i': {
                    visitor.visitLoadAttribute(arg);
                    continue block89;
                }
                case 'j': {
                    visitor.visitCompareOperator(arg);
                    continue block89;
                }
                case 'k': {
                    visitor.visitImportName(arg);
                    continue block89;
                }
                case 'l': {
                    visitor.visitImportFrom(arg);
                    continue block89;
                }
                case 'n': {
                    visitor.visitJumpForward(arg);
                    continue block89;
                }
                case 'o': {
                    visitor.visitJumpIfFalse(arg);
                    continue block89;
                }
                case 'p': {
                    visitor.visitJumpIfTrue(arg);
                    continue block89;
                }
                case 'q': {
                    visitor.visitJumpAbsolute(arg);
                    continue block89;
                }
                case 't': {
                    visitor.visitLoadGlobal(arg);
                    continue block89;
                }
                case 'w': {
                    visitor.visitContinueLoop(arg);
                    continue block89;
                }
                case 'x': {
                    visitor.visitSetupLoop(arg);
                    continue block89;
                }
                case 'y': {
                    visitor.visitSetupExcept(arg);
                    continue block89;
                }
                case 'z': {
                    visitor.visitSetupFinally(arg);
                    continue block89;
                }
                case '|': {
                    visitor.visitLoadFast(arg);
                    continue block89;
                }
                case '}': {
                    visitor.visitStoreFast(arg);
                    continue block89;
                }
                case '~': {
                    visitor.visitDeleteFast(arg);
                    continue block89;
                }
                case '\u0082': {
                    visitor.visitRaiseVarargs(arg);
                    continue block89;
                }
                case '\u0083': {
                    visitor.visitCallFunction(arg);
                    continue block89;
                }
                case '\u0084': {
                    visitor.visitMakeFunction(arg);
                    continue block89;
                }
                case '\u0085': {
                    visitor.visitBuildSlice(arg);
                    continue block89;
                }
                case '\u0086': {
                    visitor.visitMakeClosure(arg);
                    continue block89;
                }
                case '\u0087': {
                    visitor.visitLoadClosure(arg);
                    continue block89;
                }
                case '\u0088': {
                    visitor.visitLoadDeref(arg);
                    continue block89;
                }
                case '\u0089': {
                    visitor.visitStoreDeref(arg);
                    continue block89;
                }
                case '\u008c': {
                    visitor.visitCallFunctionVararg(arg);
                    continue block89;
                }
                case '\u008d': {
                    visitor.visitCallFuntionKeyword(arg);
                    continue block89;
                }
                case '\u008e': {
                    visitor.visitCallFunctionVarargKeyword(arg);
                    continue block89;
                }
                case '\u008f': {
                    throw new BytecodeError("Arugment extension two times in a row!");
                }
            }
            throw new BytecodeError("Illegal opcode '" + op + "'.");
        }
        return visitor.compile();
    }

    private class RawVisitor {
        private SortedMap instructions = new TreeMap();
        private Map labels = new HashMap();
        private List generatorLabels = new ArrayList();

        private RawVisitor() {
        }

        private Label newLabel(int address) {
            Integer addr = new Integer(address);
            if (this.labels.containsKey(addr)) {
                return ((LabelInstruction)this.labels.get(addr)).label;
            }
            Label label = new Label();
            this.labels.put(addr, new LabelInstruction(label));
            return label;
        }

        private void addInstruction(VisitableInstruction instruction) {
            this.instructions.put(new Integer(CodeReader.this.codePosition), instruction);
        }

        Iterable compile() {
            ArrayList<VisitableInstruction> result = new ArrayList<VisitableInstruction>();
            if (!this.generatorLabels.isEmpty()) {
                final Label start = new Label();
                final Label[] resume = new Label[this.generatorLabels.size()];
                int i = 0;
                Iterator labels = this.generatorLabels.iterator();
                while (labels.hasNext()) {
                    resume[i] = (Label)labels.next();
                    ++i;
                }
                result.add(new VisitableInstruction(){

                    public void accept(BytecodeVisitor codeVisitor) {
                        codeVisitor.visitResumeTable(start, resume);
                        codeVisitor.visitLabel(start);
                    }
                });
            }
            for (Map.Entry entry : this.instructions.entrySet()) {
                if (CodeReader.this.lineNumberTable.containsKey(entry.getKey())) {
                    result.add(new LineNumberInstruction((Integer)CodeReader.this.lineNumberTable.get(entry.getKey())));
                }
                if (this.labels.containsKey(entry.getKey())) {
                    result.add((VisitableInstruction)this.labels.remove(entry.getKey()));
                }
                result.add((VisitableInstruction)entry.getValue());
            }
            if (!this.labels.isEmpty()) {
                System.err.println("UNALIGNING LABELS:");
                for (Map.Entry entry : this.labels.entrySet()) {
                    System.err.println("" + entry.getKey() + ": " + entry.getValue());
                }
                throw new RuntimeException("Labels and code does not align!");
            }
            return result;
        }

        void visitStopCode() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitStopCode();
                }
            });
        }

        void visitNOP() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitNOP();
                }
            });
        }

        void visitPop() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitPop();
                }
            });
        }

        void visitDup() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitDup(1);
                }
            });
        }

        void visitRotTwo() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitRot(2);
                }
            });
        }

        void visitRotThree() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitRot(3);
                }
            });
        }

        void visitRotFour() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitRot(4);
                }
            });
        }

        void visitDupTopX(final int x) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitDup(x);
                }
            });
        }

        void visitUnaryOperation(int op) {
            int operator2;
            switch (op) {
                case 15: {
                    operator2 = 0;
                    break;
                }
                case 10: {
                    operator2 = 1;
                    break;
                }
                case 11: {
                    operator2 = 2;
                    break;
                }
                case 12: {
                    operator2 = 3;
                    break;
                }
                case 13: {
                    operator2 = 4;
                    break;
                }
                default: {
                    throw new RuntimeException("Unimplemented Unary Operation op code: '" + op + "'.");
                }
            }
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitUnaryOperator(operator2);
                }
            });
        }

        void visitBinaryOperator(int op) {
            int operator2;
            switch (op) {
                case 23: {
                    operator2 = 0;
                    break;
                }
                case 24: {
                    operator2 = 1;
                    break;
                }
                case 20: {
                    operator2 = 2;
                    break;
                }
                case 21: {
                    operator2 = 3;
                    break;
                }
                case 26: {
                    operator2 = 4;
                    break;
                }
                case 27: {
                    operator2 = 5;
                    break;
                }
                case 22: {
                    operator2 = 6;
                    break;
                }
                case 19: {
                    operator2 = 7;
                    break;
                }
                case 62: {
                    operator2 = 8;
                    break;
                }
                case 63: {
                    operator2 = 9;
                    break;
                }
                case 64: {
                    operator2 = 10;
                    break;
                }
                case 66: {
                    operator2 = 11;
                    break;
                }
                case 65: {
                    operator2 = 12;
                    break;
                }
                case 25: {
                    operator2 = 13;
                    break;
                }
                default: {
                    throw new RuntimeException("Unimplemented Binary Operation op code: '" + op + "'.");
                }
            }
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitBinaryOperator(operator2);
                }
            });
        }

        void visitInplaceOperator(int op) {
            int operator2;
            switch (op) {
                case 55: {
                    operator2 = 0;
                    break;
                }
                case 56: {
                    operator2 = 1;
                    break;
                }
                case 57: {
                    operator2 = 2;
                    break;
                }
                case 58: {
                    operator2 = 3;
                    break;
                }
                case 28: {
                    operator2 = 4;
                    break;
                }
                case 29: {
                    operator2 = 5;
                    break;
                }
                case 59: {
                    operator2 = 6;
                    break;
                }
                case 67: {
                    operator2 = 7;
                    break;
                }
                case 75: {
                    operator2 = 8;
                    break;
                }
                case 76: {
                    operator2 = 9;
                    break;
                }
                case 77: {
                    operator2 = 10;
                    break;
                }
                case 79: {
                    operator2 = 11;
                    break;
                }
                case 78: {
                    operator2 = 12;
                    break;
                }
                default: {
                    throw new RuntimeException("Unimplemented Inplace Operation op code: '" + op + "'.");
                }
            }
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitInplaceOperator(operator2);
                }
            });
        }

        void visitCompareOperator(final int opid) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitCompareOperator(opid);
                }
            });
        }

        void visitListAppend() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitListAppend();
                }
            });
        }

        void visitStoreSubscript() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitStoreSubscript();
                }
            });
        }

        void visitDeleteSubscript() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitDeleteSubscript();
                }
            });
        }

        void visitSlice(final int plus) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitLoadSlice(plus);
                }
            });
        }

        void visitStoreSlice(final int plus) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitStoreSlice(plus);
                }
            });
        }

        void visitDeleteSlice(final int plus) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitDeleteSlice(plus);
                }
            });
        }

        void visitBuildSlice(final int numargs) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitBuildSlice(numargs);
                }
            });
        }

        void visitPrintExpression() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitPrintExpression();
                }
            });
        }

        void visitPrintItem() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitPrintItem();
                }
            });
        }

        void visitPrintNewline() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitPrintNewline();
                }
            });
        }

        void visitPrintItemTo() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitPrintItemTo();
                }
            });
        }

        void visitPrintNewlineTo() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitPrintNewlineTo();
                }
            });
        }

        void visitReturnValue() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitReturnValue();
                }
            });
        }

        void visitYieldValue() {
            final Label resume = new Label();
            this.generatorLabels.add(resume);
            final int index = this.generatorLabels.size();
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitYieldValue(index, resume);
                }
            });
        }

        void visitRaiseVarargs(final int count) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitRaiseVarargs(count);
                }
            });
        }

        void visitWithCleanup() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitWithCleanup();
                }
            });
        }

        void visitExecStatement() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitExecStatement();
                }
            });
        }

        void visitUnpackSequence(final int count) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitUnpackSequence(count);
                }
            });
        }

        void visitImportName(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitImportName(codeVisitor.getName(index));
                }
            });
        }

        void visitImportFrom(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitImportFrom(codeVisitor.getName(index));
                }
            });
        }

        void visitImportStar() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitImportStar();
                }
            });
        }

        void visitLoadLocals() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitLoadLocals();
                }
            });
        }

        void visitLoadConstant(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitLoadConstant(codeVisitor.getConstant(index));
                }
            });
        }

        void visitLoadName(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitLoadName(codeVisitor.getName(index));
                }
            });
        }

        void visitStoreName(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitStoreName(codeVisitor.getName(index));
                }
            });
        }

        void visitDeleteName(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitDeleteName(codeVisitor.getName(index));
                }
            });
        }

        void visitLoadFast(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitLoadFast(codeVisitor.getVariableName(index));
                }
            });
        }

        void visitStoreFast(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitStoreFast(codeVisitor.getVariableName(index));
                }
            });
        }

        void visitDeleteFast(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitDeleteFast(codeVisitor.getVariableName(index));
                }
            });
        }

        void visitLoadGlobal(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitLoadGlobal(codeVisitor.getName(index));
                }
            });
        }

        void visitStoreGlobal(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitStoreGlobal(codeVisitor.getName(index));
                }
            });
        }

        void visitDeleteGlobal(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitDeleteGlobal(codeVisitor.getName(index));
                }
            });
        }

        void visitLoadAttribute(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitLoadAttribute(codeVisitor.getName(index));
                }
            });
        }

        void visitStoreAttribute(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitStoreAttribute(codeVisitor.getName(index));
                }
            });
        }

        void visitDeleteAttribute(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitDeleteAttribute(codeVisitor.getName(index));
                }
            });
        }

        void visitBuildTuple(final int size) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitBuildTuple(size);
                }
            });
        }

        void visitBuildList(final int size) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitBuildList(size);
                }
            });
        }

        void visitBuildMap(final int size) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitBuildMap(size);
                }
            });
        }

        void visitBuildClass() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitBuildClass();
                }
            });
        }

        void visitMakeFunction(final int num_default) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitMakeFunction(num_default);
                }
            });
        }

        void visitMakeClosure(final int num_default) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitMakeClosure(num_default);
                }
            });
        }

        void visitLoadClosure(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitLoadClosure(codeVisitor.getOuterName(index));
                }
            });
        }

        void visitLoadDeref(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitLoadDeref(codeVisitor.getOuterName(index));
                }
            });
        }

        void visitStoreDeref(final int index) {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitStoreDeref(codeVisitor.getOuterName(index));
                }
            });
        }

        void visitCallFunction(int arg) {
            final int num_positional = arg & 0xFF;
            final int num_keyword = arg >> 8 & 0xFF;
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitCallFunction(num_positional, num_keyword);
                }
            });
        }

        void visitCallFunctionVararg(int arg) {
            final int num_positional = arg & 0xFF;
            final int num_keyword = arg >> 8 & 0xFF;
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitCallFunctionVararg(num_positional, num_keyword);
                }
            });
        }

        void visitCallFuntionKeyword(int arg) {
            final int num_positional = arg & 0xFF;
            final int num_keyword = arg >> 8 & 0xFF;
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitCallFunctionKeyword(num_positional, num_keyword);
                }
            });
        }

        void visitCallFunctionVarargKeyword(int arg) {
            final int num_positional = arg & 0xFF;
            final int num_keyword = arg >> 8 & 0xFF;
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitCallFunctionVarargKeyword(num_positional, num_keyword);
                }
            });
        }

        void visitGetIterator() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitGetIterator();
                }
            });
        }

        void visitBreakLoop() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitBreakLoop();
                }
            });
        }

        void visitPopBlock() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitPopBlock();
                }
            });
        }

        void visitEndFinally() {
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitEndFinally();
                }
            });
        }

        void visitForIteration(int arg) {
            final Label label = this.newLabel(CodeReader.this.getAbsoluteAddress(arg));
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitForIteration(label);
                }
            });
        }

        void visitContinueLoop(int arg) {
            final Label label = this.newLabel(arg);
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitContinueLoop(label);
                }
            });
        }

        void visitSetupLoop(int arg) {
            final Label label = this.newLabel(CodeReader.this.getAbsoluteAddress(arg));
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitSetupLoop(label);
                }
            });
        }

        void visitSetupExcept(int arg) {
            final Label label = this.newLabel(CodeReader.this.getAbsoluteAddress(arg));
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitSetupExcept(label);
                }
            });
        }

        void visitSetupFinally(int arg) {
            final Label label = this.newLabel(CodeReader.this.getAbsoluteAddress(arg));
            this.addInstruction(new VisitableInstruction(){

                public void accept(BytecodeVisitor codeVisitor) {
                    codeVisitor.visitSetupFinally(label);
                }
            });
        }

        void visitJumpForward(int arg) {
            this.addInstruction(new JumpInstruction(this.newLabel(CodeReader.this.getAbsoluteAddress(arg))));
        }

        void visitJumpIfTrue(int arg) {
            this.addInstruction(new JumpInstruction(this.newLabel(CodeReader.this.getAbsoluteAddress(arg)), true));
        }

        void visitJumpIfFalse(int arg) {
            this.addInstruction(new JumpInstruction(this.newLabel(CodeReader.this.getAbsoluteAddress(arg)), false));
        }

        void visitJumpAbsolute(int arg) {
            this.addInstruction(new JumpInstruction(this.newLabel(arg)));
        }
    }

    private class JumpInstruction
    implements VisitableInstruction {
        private static final int REGULAR_JUMP = 0;
        private static final int JUMP_IF_TRUE = 1;
        private static final int JUMP_IF_FALSE = 2;
        private Label label;
        private int kind;

        private JumpInstruction(int kind, Label label) {
            this.kind = kind;
            this.label = label;
        }

        private JumpInstruction(Label label) {
            this(0, label);
        }

        private JumpInstruction(Label label, boolean inCase) {
            this(inCase ? 1 : 2, label);
        }

        public void accept(BytecodeVisitor codeVisitor) {
            switch (this.kind) {
                case 0: {
                    codeVisitor.visitJump(this.label);
                    break;
                }
                case 1: {
                    codeVisitor.visitJumpIfTrue(this.label);
                    break;
                }
                case 2: {
                    codeVisitor.visitJumpIfFalse(this.label);
                    break;
                }
            }
        }
    }

    private class LineNumberInstruction
    implements VisitableInstruction {
        private int lineNumber;

        private LineNumberInstruction(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public void accept(BytecodeVisitor codeVisitor) {
            codeVisitor.visitLineNumber(this.lineNumber);
        }
    }

    private class LabelInstruction
    implements VisitableInstruction {
        private Label label;

        private LabelInstruction(Label label) {
            this.label = label;
        }

        public void accept(BytecodeVisitor codeVisitor) {
            codeVisitor.visitLabel(this.label);
        }

        public String toString() {
            return "LabelInstruction:" + this.label;
        }
    }

    private static interface VisitableInstruction {
        public void accept(BytecodeVisitor var1);
    }
}

