/*
 * Decompiled with CFR 0.152.
 */
package org.python.newcompiler.pyasm.util;

import org.python.core.PyObject;
import org.python.newcompiler.pyasm.BytecodeVisitor;
import org.python.newcompiler.pyasm.CodeVisitor;
import org.python.newcompiler.pyasm.ConstantStore;
import org.python.newcompiler.pyasm.Label;
import org.python.newcompiler.pyasm.util.SimpleConstantStore;

public class CodeAdapter
implements BytecodeVisitor {
    private CodeVisitor next;
    private ConstantStore store;

    private static ConstantStore getStore(CodeVisitor visitor) {
        if (visitor != null & visitor instanceof ConstantStore) {
            return (ConstantStore)((Object)visitor);
        }
        return null;
    }

    public CodeAdapter() {
        this(CodeAdapter.getStore(null));
    }

    public CodeAdapter(ConstantStore store) {
        this(store, null);
    }

    public CodeAdapter(CodeVisitor next) {
        this(CodeAdapter.getStore(next), next);
    }

    public CodeAdapter(ConstantStore store, CodeVisitor next) {
        this.next = next;
        this.store = store;
    }

    public void visitCode(long argcount, long nlocals, long stacksize, long flags, PyObject[] constants, String[] names, String[] varnames, String[] freevars, String[] cellvars, String filename, String name, long firstlnno) {
        if (this.store == null) {
            this.store = new SimpleConstantStore(constants, names, varnames, freevars, cellvars);
        }
        if (this.next != null) {
            this.next.visitCode(argcount, nlocals, stacksize, flags, constants, names, varnames, freevars, cellvars, filename, name, firstlnno);
        }
    }

    public String getName(int index) {
        return this.store.getName(index);
    }

    public String getOuterName(int index) {
        return this.store.getOuterName(index);
    }

    public String getVariableName(int index) {
        return this.store.getVariableName(index);
    }

    public PyObject getConstant(int index) {
        return this.store.getConstant(index);
    }

    public void visitBinaryOperator(int operator2) {
        if (this.next != null) {
            this.next.visitBinaryOperator(operator2);
        }
    }

    public void visitBreakLoop() {
        if (this.next != null) {
            this.next.visitBreakLoop();
        }
    }

    public void visitBuildClass() {
        if (this.next != null) {
            this.next.visitBuildClass();
        }
    }

    public void visitBuildList(int size) {
        if (this.next != null) {
            this.next.visitBuildList(size);
        }
    }

    public void visitBuildMap(int zero) {
        if (this.next != null) {
            this.next.visitBuildMap(zero);
        }
    }

    public void visitBuildSlice(int numargs) {
        if (this.next != null) {
            this.next.visitBuildSlice(numargs);
        }
    }

    public void visitBuildTuple(int size) {
        if (this.next != null) {
            this.next.visitBuildTuple(size);
        }
    }

    public void visitCallFunction(int num_positional, int num_keyword) {
        if (this.next != null) {
            this.next.visitCallFunction(num_positional, num_keyword);
        }
    }

    public void visitCallFunctionKeyword(int num_positional, int num_keyword) {
        if (this.next != null) {
            this.next.visitCallFunctionKeyword(num_positional, num_keyword);
        }
    }

    public void visitCallFunctionVararg(int num_positional, int num_keyword) {
        if (this.next != null) {
            this.next.visitCallFunctionVararg(num_positional, num_keyword);
        }
    }

    public void visitCallFunctionVarargKeyword(int num_positional, int num_keyword) {
        if (this.next != null) {
            this.next.visitCallFunctionVarargKeyword(num_positional, num_keyword);
        }
    }

    public void visitCompareOperator(int operator2) {
        if (this.next != null) {
            this.next.visitCompareOperator(operator2);
        }
    }

    public void visitContinueLoop(Label loopStart) {
        if (this.next != null) {
            this.next.visitContinueLoop(loopStart);
        }
    }

    public void visitDeleteAttribute(String attributeName) {
        if (this.next != null) {
            this.next.visitDeleteAttribute(attributeName);
        }
    }

    public void visitDeleteFast(String variableName) {
        if (this.next != null) {
            this.next.visitDeleteFast(variableName);
        }
    }

    public void visitDeleteGlobal(String variableName) {
        if (this.next != null) {
            this.next.visitDeleteGlobal(variableName);
        }
    }

    public void visitDeleteName(String variableName) {
        if (this.next != null) {
            this.next.visitDeleteName(variableName);
        }
    }

    public void visitDeleteSlice(int plus) {
        if (this.next != null) {
            this.next.visitDeleteSlice(plus);
        }
    }

    public void visitDeleteSubscript() {
        if (this.next != null) {
            this.next.visitDeleteSubscript();
        }
    }

    public void visitDup(int num_elements) {
        if (this.next != null) {
            this.next.visitDup(num_elements);
        }
    }

    public void visitEnd() {
        if (this.next != null) {
            this.next.visitEnd();
        }
    }

    public void visitEndFinally() {
        if (this.next != null) {
            this.next.visitEndFinally();
        }
    }

    public void visitExecStatement() {
        if (this.next != null) {
            this.next.visitExecStatement();
        }
    }

    public void visitForIteration(Label end) {
        if (this.next != null) {
            this.next.visitForIteration(end);
        }
    }

    public void visitGetIterator() {
        if (this.next != null) {
            this.next.visitGetIterator();
        }
    }

    public void visitImportFrom(String name) {
        if (this.next != null) {
            this.next.visitImportFrom(name);
        }
    }

    public void visitImportName(String name) {
        if (this.next != null) {
            this.next.visitImportName(name);
        }
    }

    public void visitImportStar() {
        if (this.next != null) {
            this.next.visitImportStar();
        }
    }

    public void visitInplaceOperator(int operator2) {
        if (this.next != null) {
            this.next.visitInplaceOperator(operator2);
        }
    }

    public void visitJump(Label destination) {
        if (this.next != null) {
            this.next.visitJump(destination);
        }
    }

    public void visitJumpIfFalse(Label destination) {
        if (this.next != null) {
            this.next.visitJumpIfFalse(destination);
        }
    }

    public void visitJumpIfTrue(Label destination) {
        if (this.next != null) {
            this.next.visitJumpIfTrue(destination);
        }
    }

    public void visitLabel(Label label) {
        if (this.next != null) {
            this.next.visitLabel(label);
        }
    }

    public void visitLineNumber(int lineNumber) {
        if (this.next != null) {
            this.next.visitLineNumber(lineNumber);
        }
    }

    public void visitListAppend() {
        if (this.next != null) {
            this.next.visitListAppend();
        }
    }

    public void visitLoadAttribute(String attributeName) {
        if (this.next != null) {
            this.next.visitLoadAttribute(attributeName);
        }
    }

    public void visitLoadClosure(String variableName) {
        if (this.next != null) {
            this.next.visitLoadClosure(variableName);
        }
    }

    public void visitLoadConstant(PyObject constant) {
        if (this.next != null) {
            this.next.visitLoadConstant(constant);
        }
    }

    public void visitLoadDeref(String variableName) {
        if (this.next != null) {
            this.next.visitLoadDeref(variableName);
        }
    }

    public void visitLoadFast(String variableName) {
        if (this.next != null) {
            this.next.visitLoadFast(variableName);
        }
    }

    public void visitLoadGlobal(String variableName) {
        if (this.next != null) {
            this.next.visitLoadGlobal(variableName);
        }
    }

    public void visitLoadLocals() {
        if (this.next != null) {
            this.next.visitLoadLocals();
        }
    }

    public void visitLoadName(String variableName) {
        if (this.next != null) {
            this.next.visitLoadName(variableName);
        }
    }

    public void visitLoadSlice(int plus) {
        if (this.next != null) {
            this.next.visitLoadSlice(plus);
        }
    }

    public void visitMakeClosure(int num_default) {
        if (this.next != null) {
            this.next.visitMakeClosure(num_default);
        }
    }

    public void visitMakeFunction(int num_default) {
        if (this.next != null) {
            this.next.visitMakeFunction(num_default);
        }
    }

    public void visitNOP() {
        if (this.next != null) {
            this.next.visitNOP();
        }
    }

    public void visitPop() {
        if (this.next != null) {
            this.next.visitPop();
        }
    }

    public void visitPopBlock() {
        if (this.next != null) {
            this.next.visitPopBlock();
        }
    }

    public void visitPrintExpression() {
        if (this.next != null) {
            this.next.visitPrintExpression();
        }
    }

    public void visitPrintItem() {
        if (this.next != null) {
            this.next.visitPrintItem();
        }
    }

    public void visitPrintItemTo() {
        if (this.next != null) {
            this.next.visitPrintItemTo();
        }
    }

    public void visitPrintNewline() {
        if (this.next != null) {
            this.next.visitPrintNewline();
        }
    }

    public void visitPrintNewlineTo() {
        if (this.next != null) {
            this.next.visitPrintNewlineTo();
        }
    }

    public void visitRaiseVarargs(int count) {
        if (this.next != null) {
            this.next.visitRaiseVarargs(count);
        }
    }

    public void visitResumeTable(Label start, Label[] labels) {
        if (this.next != null) {
            this.next.visitResumeTable(start, labels);
        }
    }

    public void visitReturnValue() {
        if (this.next != null) {
            this.next.visitReturnValue();
        }
    }

    public void visitRot(int depth) {
        if (this.next != null) {
            this.next.visitRot(depth);
        }
    }

    public void visitSetupExcept(Label startExcept) {
        if (this.next != null) {
            this.next.visitSetupExcept(startExcept);
        }
    }

    public void visitSetupFinally(Label startFinally) {
        if (this.next != null) {
            this.next.visitSetupFinally(startFinally);
        }
    }

    public void visitSetupLoop(Label end) {
        if (this.next != null) {
            this.next.visitSetupLoop(end);
        }
    }

    public void visitStopCode() {
        if (this.next != null) {
            this.next.visitStopCode();
        }
    }

    public void visitStoreAttribute(String attributeName) {
        if (this.next != null) {
            this.next.visitStoreAttribute(attributeName);
        }
    }

    public void visitStoreDeref(String variableName) {
        if (this.next != null) {
            this.next.visitStoreDeref(variableName);
        }
    }

    public void visitStoreFast(String variableName) {
        if (this.next != null) {
            this.next.visitStoreFast(variableName);
        }
    }

    public void visitStoreGlobal(String variableName) {
        if (this.next != null) {
            this.next.visitStoreGlobal(variableName);
        }
    }

    public void visitStoreName(String variableName) {
        if (this.next != null) {
            this.next.visitStoreName(variableName);
        }
    }

    public void visitStoreSlice(int plus) {
        if (this.next != null) {
            this.next.visitStoreSlice(plus);
        }
    }

    public void visitStoreSubscript() {
        if (this.next != null) {
            this.next.visitStoreSubscript();
        }
    }

    public void visitUnaryOperator(int operator2) {
        if (this.next != null) {
            this.next.visitUnaryOperator(operator2);
        }
    }

    public void visitUnpackSequence(int count) {
        if (this.next != null) {
            this.next.visitUnpackSequence(count);
        }
    }

    public void visitWithCleanup() {
        if (this.next != null) {
            this.next.visitWithCleanup();
        }
    }

    public void visitYieldValue(int index, Label resume) {
        if (this.next != null) {
            this.next.visitYieldValue(index, resume);
        }
    }
}

