/*
 * Decompiled with CFR 0.152.
 */
package org.python.newcompiler.pyasm.util;

import java.io.PrintWriter;
import org.python.core.PyObject;
import org.python.newcompiler.DisassemblyDocument;
import org.python.newcompiler.pyasm.CodeVisitor;
import org.python.newcompiler.pyasm.Label;
import org.python.newcompiler.pyasm.util.CodeAdapter;

public class PythonDis
extends CodeAdapter {
    private DisassemblyDocument debugger;
    private int offset = 0;

    public PythonDis(DisassemblyDocument debug) {
        this(null, debug);
    }

    public PythonDis(CodeVisitor next) {
        this(next, new WriterDebugger(new PrintWriter(System.out), true));
    }

    public PythonDis(CodeVisitor next, DisassemblyDocument debug) {
        super(next);
        this.debugger = debug;
    }

    public PythonDis(PrintWriter out) {
        this(out, true);
    }

    public PythonDis(PrintWriter out, boolean autoflush) {
        this(null, out, autoflush);
    }

    public PythonDis(CodeVisitor next, PrintWriter out) {
        this(next, out, true);
    }

    public PythonDis(CodeVisitor next, PrintWriter out, boolean autoflush) {
        this(next, new WriterDebugger(out, autoflush));
    }

    private void instruction(String mnem, int len, Object param) {
        this.debugger.put(this.offset, mnem + " " + param);
        this.offset += len;
    }

    private void instruction(String mnem, int len) {
        this.instruction(mnem, len, "");
    }

    private void instruction(String mnem) {
        this.instruction(mnem, 1);
    }

    public void visitCode(long argcount, long nlocals, long stacksize, long flags, PyObject[] constants, String[] names, String[] varnames, String[] freevars, String[] cellvars, String filename, String name, long firstlnno) {
        super.visitCode(argcount, nlocals, stacksize, flags, constants, names, varnames, freevars, cellvars, filename, name, firstlnno);
        String args = "";
        this.debugger.putTitle(firstlnno, "def " + name + "(" + args + "): # in " + filename);
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.debugger instanceof WriterDebugger) {
            WriterDebugger writer = (WriterDebugger)this.debugger;
            writer.flush();
        }
    }

    public void visitBinaryOperator(int operator2) {
        super.visitBinaryOperator(operator2);
        switch (operator2) {
            case 0: {
                this.instruction("BINARY ADD");
                break;
            }
            case 1: {
                this.instruction("BINARY SUBTRACT");
                break;
            }
            case 2: {
                this.instruction("BINARY MULTIPLY");
                break;
            }
            case 3: {
                this.instruction("BINARY DIVIDE");
                break;
            }
            case 4: {
                this.instruction("BINARY FLOOR DIVIDE");
                break;
            }
            case 5: {
                this.instruction("BINARY TRUE DIVIDE");
                break;
            }
            case 6: {
                this.instruction("BINARY MODULO");
                break;
            }
            case 7: {
                this.instruction("BINARY POWER");
                break;
            }
            case 8: {
                this.instruction("BINARY LSHIFT");
                break;
            }
            case 9: {
                this.instruction("BINARY RSHIFT");
                break;
            }
            case 10: {
                this.instruction("BINARY AND");
                break;
            }
            case 11: {
                this.instruction("BINARY OR");
                break;
            }
            case 12: {
                this.instruction("BINARY XOR");
                break;
            }
            case 13: {
                this.instruction("BINARY SUBSCRIPT");
                break;
            }
            default: {
                throw new RuntimeException("unknown binary operator " + operator2);
            }
        }
    }

    public void visitBreakLoop() {
        super.visitBreakLoop();
        this.instruction("BREAK LOOP");
    }

    public void visitBuildClass() {
        super.visitBuildClass();
        this.instruction("BUILD CLASS");
    }

    public void visitBuildList(int size) {
        super.visitBuildList(size);
        this.instruction("BUILD LIST", 3, new Integer(size));
    }

    public void visitBuildMap(int zero) {
        super.visitBuildMap(zero);
        if (zero != 0) {
            throw new RuntimeException("BUILD MAP received non-zero argument " + zero);
        }
        this.instruction("BUILD MAP", 3, new Integer(zero));
    }

    public void visitBuildSlice(int numargs) {
        super.visitBuildSlice(numargs);
        this.instruction("BUILD SLICE", 3, new Integer(numargs));
    }

    public void visitBuildTuple(int size) {
        super.visitBuildTuple(size);
        this.instruction("BUILD TUPLE", 3, new Integer(size));
    }

    public void visitCallFunction(int num_positional, int num_keyword) {
        super.visitCallFunction(num_positional, num_keyword);
        this.instruction("CALL FUNCTION", 3, "" + num_positional + " positional and " + num_keyword + " keywords.");
    }

    public void visitCallFunctionKeyword(int num_positional, int num_keyword) {
        super.visitCallFunctionKeyword(num_positional, num_keyword);
        this.instruction("CALL FUNCTION KEYWORD", 3, "" + num_positional + " positional and " + num_keyword + " keywords.");
    }

    public void visitCallFunctionVararg(int num_positional, int num_keyword) {
        super.visitCallFunctionVararg(num_positional, num_keyword);
        this.instruction("CALL FUNCTION VARARG", 3, "" + num_positional + " positional and " + num_keyword + " keywords.");
    }

    public void visitCallFunctionVarargKeyword(int num_positional, int num_keyword) {
        super.visitCallFunctionVarargKeyword(num_positional, num_keyword);
        this.instruction("CALL FUNCTION VARARG KEYWORD", 3, "" + num_positional + " positional and " + num_keyword + " keywords.");
    }

    public void visitCompareOperator(int operator2) {
        String op;
        super.visitCompareOperator(operator2);
        switch (operator2) {
            case 0: {
                op = "<";
                break;
            }
            case 1: {
                op = "<=";
                break;
            }
            case 2: {
                op = "==";
                break;
            }
            case 3: {
                op = "!=";
                break;
            }
            case 4: {
                op = ">";
                break;
            }
            case 5: {
                op = ">=";
                break;
            }
            case 6: {
                op = "in";
                break;
            }
            case 7: {
                op = "not in";
                break;
            }
            case 8: {
                op = "is";
                break;
            }
            case 9: {
                op = "is not";
                break;
            }
            case 10: {
                op = "exception match";
                break;
            }
            default: {
                throw new RuntimeException("Unknown compare operator " + operator2);
            }
        }
        this.instruction("COMPARE OPERATOR", 3, op);
    }

    public void visitContinueLoop(Label loopStart) {
        super.visitContinueLoop(loopStart);
        this.instruction("CONTINUE LOOP", 3, loopStart);
    }

    public void visitDeleteAttribute(String attributeName) {
        super.visitDeleteAttribute(attributeName);
        this.instruction("DELETE ATTRIBUTE", 3, attributeName);
    }

    public void visitDeleteFast(String variableName) {
        super.visitDeleteFast(variableName);
        this.instruction("DELETE FAST", 3, variableName);
    }

    public void visitDeleteGlobal(String variableName) {
        super.visitDeleteGlobal(variableName);
        this.instruction("DELETE GLOBAL", 3, variableName);
    }

    public void visitDeleteName(String variableName) {
        super.visitDeleteName(variableName);
        this.instruction("DELETE NAME", 3, variableName);
    }

    public void visitDeleteSlice(int plus) {
        super.visitDeleteSlice(plus);
        this.instruction("DELETE SLICE +" + plus);
    }

    public void visitDeleteSubscript() {
        super.visitDeleteSubscript();
        this.instruction("DELETE SUBSCRIPT");
    }

    public void visitDup(int num_elements) {
        super.visitDup(num_elements);
        if (num_elements == 1) {
            this.instruction("DUP TOP");
        } else {
            this.instruction("DUP TOPX", 3, new Integer(num_elements));
        }
    }

    public void visitEndFinally() {
        super.visitEndFinally();
        this.instruction("END FINALLY");
    }

    public void visitExecStatement() {
        super.visitExecStatement();
        this.instruction("EXEC STMT");
    }

    public void visitForIteration(Label end) {
        super.visitForIteration(end);
        this.instruction("FOR ITER", 3, end);
    }

    public void visitGetIterator() {
        super.visitGetIterator();
        this.instruction("GET ITER");
    }

    public void visitImportFrom(String name) {
        super.visitImportFrom(name);
        this.instruction("IMPORT FROM", 3, name);
    }

    public void visitImportName(String name) {
        super.visitImportName(name);
        this.instruction("IMPORT NAME", 3, name);
    }

    public void visitImportStar() {
        super.visitImportStar();
        this.instruction("IMPORT STAR");
    }

    public void visitInplaceOperator(int operator2) {
        super.visitInplaceOperator(operator2);
        switch (operator2) {
            case 0: {
                this.instruction("INPLACE ADD");
                break;
            }
            case 1: {
                this.instruction("INPLACE SUBTRACT");
                break;
            }
            case 2: {
                this.instruction("INPLACE MULTIPLY");
                break;
            }
            case 3: {
                this.instruction("INPLACE DIVIDE");
                break;
            }
            case 4: {
                this.instruction("INPLACE FLOOR DIVIDE");
                break;
            }
            case 5: {
                this.instruction("INPLACE TRUE DIVIDE");
                break;
            }
            case 6: {
                this.instruction("INPLACE MODULO");
                break;
            }
            case 7: {
                this.instruction("INPLACE POWER");
                break;
            }
            case 8: {
                this.instruction("INPLACE LSHIFT");
                break;
            }
            case 9: {
                this.instruction("INPLACE RSHIFT");
                break;
            }
            case 10: {
                this.instruction("INPLACE AND");
                break;
            }
            case 11: {
                this.instruction("INPLACE OR");
                break;
            }
            case 12: {
                this.instruction("INPLACE XOR");
                break;
            }
            default: {
                throw new RuntimeException("unknown inplace operator " + operator2);
            }
        }
    }

    public void visitJump(Label destination) {
        super.visitJump(destination);
        this.instruction("JUMP", 3, destination);
    }

    public void visitJumpIfFalse(Label destination) {
        super.visitJumpIfFalse(destination);
        this.instruction("JUMP IF FALSE", 3, destination);
    }

    public void visitJumpIfTrue(Label destination) {
        super.visitJumpIfTrue(destination);
        this.instruction("JUMP IF TRUE", 3, destination);
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        this.debugger.putLabel(label.toString());
    }

    public void visitLineNumber(int lineNumber) {
        super.visitLineNumber(lineNumber);
    }

    public void visitListAppend() {
        super.visitListAppend();
        this.instruction("LIST APPEND");
    }

    public void visitLoadAttribute(String attributeName) {
        super.visitLoadAttribute(attributeName);
        this.instruction("LOAD ATTRIBUTE", 3, attributeName);
    }

    public void visitLoadClosure(String variableName) {
        super.visitLoadClosure(variableName);
        this.instruction("LOAD CLOSURE", 3, variableName);
    }

    public void visitLoadConstant(PyObject constant) {
        super.visitLoadConstant(constant);
        this.instruction("LOAD CONSTANT", 3, constant.__repr__());
    }

    public void visitLoadDeref(String variableName) {
        super.visitLoadDeref(variableName);
        this.instruction("LOAD DEREF", 3, variableName);
    }

    public void visitLoadFast(String variableName) {
        super.visitLoadFast(variableName);
        this.instruction("LOAD FAST", 3, variableName);
    }

    public void visitLoadGlobal(String variableName) {
        super.visitLoadGlobal(variableName);
        this.instruction("LOAD GLOBAL", 3, variableName);
    }

    public void visitLoadLocals() {
        super.visitLoadLocals();
        this.instruction("LOAD LOCALS");
    }

    public void visitLoadName(String variableName) {
        super.visitLoadName(variableName);
        this.instruction("LOAD NAME", 3, variableName);
    }

    public void visitLoadSlice(int plus) {
        super.visitLoadSlice(plus);
        this.instruction("LOAD SLICE +" + plus);
    }

    public void visitMakeClosure(int num_default) {
        super.visitMakeClosure(num_default);
        this.instruction("MAKE CLOSURE", 3, "" + num_default + " default arguments");
    }

    public void visitMakeFunction(int num_default) {
        super.visitMakeFunction(num_default);
        this.instruction("MAKE FUNCTION", 3, "" + num_default + " default arguments");
    }

    public void visitNOP() {
        super.visitNOP();
        this.instruction("NOP");
    }

    public void visitPop() {
        super.visitPop();
        this.instruction("POP TOP");
    }

    public void visitPopBlock() {
        super.visitPopBlock();
        this.instruction("POP BLOCK");
    }

    public void visitPrintExpression() {
        super.visitPrintExpression();
        this.instruction("PRINT EXPR");
    }

    public void visitPrintItem() {
        super.visitPrintItem();
        this.instruction("PRINT ITEM");
    }

    public void visitPrintItemTo() {
        super.visitPrintItemTo();
        this.instruction("PRINT ITEM TO");
    }

    public void visitPrintNewline() {
        super.visitPrintNewline();
        this.instruction("PRINT NEWLINE");
    }

    public void visitPrintNewlineTo() {
        super.visitPrintNewlineTo();
        this.instruction("PRINT NEWLINE TO");
    }

    public void visitRaiseVarargs(int count) {
        super.visitRaiseVarargs(count);
        this.instruction("RAISE VARARGS", 3, new Integer(count));
    }

    public void visitReturnValue() {
        super.visitReturnValue();
        this.instruction("RETURN VALUE");
    }

    public void visitRot(int depth) {
        super.visitRot(depth);
        switch (depth) {
            case 2: {
                this.instruction("ROT TWO");
                break;
            }
            case 3: {
                this.instruction("ROT THREE");
                break;
            }
            case 4: {
                this.instruction("ROT FOUR");
                break;
            }
            default: {
                throw new RuntimeException("Cannot rot " + depth + " positions.");
            }
        }
    }

    public void visitSetupExcept(Label startExcept) {
        super.visitSetupExcept(startExcept);
        this.instruction("SETUP EXCEPT", 3, startExcept);
    }

    public void visitSetupFinally(Label startFinally) {
        super.visitSetupFinally(startFinally);
        this.instruction("SETUP FINALLY", 3, startFinally);
    }

    public void visitSetupLoop(Label end) {
        super.visitSetupLoop(end);
        this.instruction("SETUP LOOP", 3, end);
    }

    public void visitStopCode() {
        super.visitStopCode();
        this.instruction("STOP CODE");
    }

    public void visitStoreAttribute(String attributeName) {
        super.visitStoreAttribute(attributeName);
        this.instruction("STORE ATTR", 3, attributeName);
    }

    public void visitStoreDeref(String variableName) {
        super.visitStoreDeref(variableName);
        this.instruction("STORE DEREF", 3, variableName);
    }

    public void visitStoreFast(String variableName) {
        super.visitStoreFast(variableName);
        this.instruction("STORE FAST", 3, variableName);
    }

    public void visitStoreGlobal(String variableName) {
        super.visitStoreGlobal(variableName);
        this.instruction("STORE GLOBAL", 3, variableName);
    }

    public void visitStoreName(String variableName) {
        super.visitStoreName(variableName);
        this.instruction("STORE NAME", 3, variableName);
    }

    public void visitStoreSlice(int plus) {
        super.visitStoreSlice(plus);
        this.instruction("STORE SLICE +" + plus);
    }

    public void visitStoreSubscript() {
        super.visitStoreSubscript();
        this.instruction("STORE SUBSCRIPT");
    }

    public void visitUnaryOperator(int operator2) {
        super.visitUnaryOperator(operator2);
        switch (operator2) {
            case 0: {
                this.instruction("UNARY INVERT");
                break;
            }
            case 1: {
                this.instruction("UNARY POSITIVE");
                break;
            }
            case 2: {
                this.instruction("UNARY NEGATIVE");
                break;
            }
            case 3: {
                this.instruction("UNARY NOT");
                break;
            }
            case 4: {
                this.instruction("UNARY CONVERT");
                break;
            }
            default: {
                throw new RuntimeException("unknown unary operator " + operator2);
            }
        }
    }

    public void visitUnpackSequence(int count) {
        super.visitUnpackSequence(count);
        this.instruction("UNPACK SEQUENCE", 3, new Integer(count));
    }

    public void visitWithCleanup() {
        super.visitWithCleanup();
        this.instruction("WITH CLEANUP");
    }

    public void visitYieldValue(int index, Label resume) {
        super.visitYieldValue(index, resume);
        this.instruction("YIELD VALUE");
    }

    private static class WriterDebugger
    implements DisassemblyDocument {
        private PrintWriter out;
        private boolean autoflush;
        private int indentation;

        private WriterDebugger(PrintWriter out, boolean autoflush, int indentation) {
            this.out = out;
            this.autoflush = autoflush;
            this.indentation = indentation;
        }

        private WriterDebugger(PrintWriter out, boolean autoflush) {
            this(out, autoflush, 0);
        }

        private void flush() {
            if (this.autoflush) {
                this.out.flush();
            }
        }

        private static String fill(String text, int width) {
            while (text.length() < width) {
                text = text + " ";
            }
            return text;
        }

        public DisassemblyDocument newPreTitle() {
            return this.newSubSection();
        }

        public DisassemblyDocument newSubSection() {
            return new WriterDebugger(this.out, this.autoflush, this.indentation + 1);
        }

        public void put(String string) {
            this.out.println(WriterDebugger.fill("", 6) + WriterDebugger.fill("", (this.indentation + 1) * 4) + string);
        }

        public void put(long offset, String string) {
            this.out.println(WriterDebugger.fill("" + offset, 6) + WriterDebugger.fill("", (this.indentation + 1) * 4) + string);
        }

        public void putLabel(String string) {
            this.out.println(WriterDebugger.fill("", 6) + WriterDebugger.fill("", this.indentation * 4 + 2) + string);
        }

        public void putTitle(long offset, String string) {
            this.out.println(WriterDebugger.fill("" + offset, 6) + WriterDebugger.fill("", this.indentation * 4) + string);
        }

        public void putTitle(String string) {
            this.out.println(WriterDebugger.fill("", 6) + WriterDebugger.fill("", this.indentation * 4) + string);
        }
    }
}

