/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client;

import brn.distsim.client.DBConnector;
import brn.distsim.client.data.Group;
import brn.distsim.client.data.Study;
import brn.distsim.client.tableModels.AddRemoveTableModel;
import brn.distsim.client.tableModels.EditableTableModel;
import brn.distsim.client.tableModels.FileInTableModel;
import brn.distsim.client.tableModels.FileOutTableModel;
import brn.distsim.client.tableModels.ParametersTableModel;
import brn.distsim.client.ui.AddRemoveToolBar;
import brn.distsim.client.ui.ClientFrame;
import brn.distsim.client.ui.SimulationPanel;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionsData
extends EditableTableModel<Study, Group> {
    private static final long serialVersionUID = 996374744833965943L;
    private FileInTableModel inFiles;
    private FileOutTableModel outFiles;
    private ParametersTableModel parameters;

    public DefinitionsData(ClientFrame parent, Study data) {
        super(parent, data, null);
        if (data == null) {
            return;
        }
        try {
            SimulationPanel panel = this.frame.getSimulationPanel();
            this.parameters = new ParametersTableModel(this.frame, data, panel.getParametersTable());
            this.inFiles = new FileInTableModel(this.frame, data, panel.getFilesInTable());
            this.outFiles = new FileOutTableModel(this.frame, data, panel.getFilesOutTable());
            this.connectTable(panel.getParametersTable(), panel.getParametersToolBar(), this.parameters);
            this.connectTable(panel.getFilesInTable(), panel.getInFilesToolBar(), this.inFiles);
            this.connectTable(panel.getFilesOutTable(), panel.getOutFilesToolBar(), this.outFiles);
            data.loadFromDb();
            for (JButton b : panel.getGroupButtons()) {
                DefinitionsData.reconnectButton(b, this);
            }
            this.readData();
        }
        catch (SQLException e) {
            DefinitionsData.error(e);
        }
    }

    @Override
    protected boolean examineAction(ActionEvent arg0) throws SQLException {
        if (super.examineAction(arg0)) {
            return true;
        }
        String command = arg0.getActionCommand();
        if (command.equals("selectSingle")) {
            Group g = (Group)((Study)this.data).get(this.getSelected());
            g.performDbUpdate();
            g.createSimulations();
            g.commit();
            return true;
        }
        return false;
    }

    private void connectTable(JTable table, AddRemoveToolBar toolBar, AddRemoveTableModel model) {
        table.setModel(model);
        DefinitionsData.reconnectButton(toolBar.getAddButton(), model);
        DefinitionsData.reconnectButton(toolBar.getRemoveButton(), model);
    }

    @Override
    public void fireTableStructureChanged() {
        this.parameters.fireTableStructureChanged();
        this.inFiles.fireTableStructureChanged();
        this.outFiles.fireTableStructureChanged();
    }

    @Override
    protected Group createData() {
        String groupName = JOptionPane.showInputDialog("input group name");
        if (groupName != null) {
            Group group = new Group(DBConnector.getDefinitions(), groupName, ((Study)this.data).getId());
            return group;
        }
        return null;
    }

    @Override
    protected int getSelected() {
        return this.frame.getSimulationPanel().getParametersTable().getSelectedColumn() - 1;
    }

    @Override
    protected void setSelected(int pos) {
        SimulationPanel p = this.frame.getSimulationPanel();
        p.getParametersTable().setColumnSelectionInterval(pos + 1, pos + 1);
        p.getFilesInTable().setColumnSelectionInterval(pos + 1, pos + 1);
        p.getFilesOutTable().setColumnSelectionInterval(pos + 1, pos + 1);
    }

    @Override
    protected Group cloneData(Group orig) {
        String groupName = JOptionPane.showInputDialog("input group name");
        if (groupName != null) {
            return new Group(orig, groupName);
        }
        return null;
    }

    @Override
    protected void connect(Group newData) {
        try {
            for (Group g : (Study)this.data) {
                g.performDbUpdate();
                g.createSimulations();
                g.commit();
            }
        }
        catch (SQLException e) {
            DefinitionsData.error(e);
        }
        catch (IllegalArgumentException e) {
            DefinitionsData.error(e);
        }
    }

    @Override
    public int getColumnCount() {
        return ((Study)this.data).size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return null;
    }

    @Override
    protected void readData() {
        this.names.clear();
        int i = 0;
        while (i < ((Study)this.data).size()) {
            this.names.add(((Group)((Study)this.data).get(i)).getName());
            ++i;
        }
        this.parameters.readData();
        this.inFiles.readData();
        this.outFiles.readData();
        this.fireTableStructureChanged();
    }

    @Override
    protected boolean remove(int pos) {
        if (pos < 0) {
            return false;
        }
        ((Study)this.data).remove(pos);
        this.names.remove(pos);
        this.fireTableStructureChanged();
        return true;
    }
}

