/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.Saveable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbBackedData<D extends Saveable>
implements Iterable<D> {
    protected Connection definitions;
    protected Statement statement;
    protected Set<D> updated;
    protected Set<D> inserted;
    protected Set<D> deleted;
    protected ArrayList<D> dependentData;
    protected int id;

    protected DbBackedData(Connection definitions) {
        this.definitions = definitions;
        try {
            this.statement = definitions.createStatement();
            this.dependentData = new ArrayList();
            this.updated = new HashSet<D>();
            this.deleted = new HashSet<D>();
            this.inserted = new HashSet<D>();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public boolean isChanged() {
        return !this.inserted.isEmpty() || !this.updated.isEmpty() || !this.deleted.isEmpty();
    }

    public void commit() throws SQLException {
        boolean commit = this.definitions.getAutoCommit();
        try {
            if (commit) {
                this.definitions.setAutoCommit(false);
            }
            for (Saveable i : this.updated) {
                i.performDbUpdate();
            }
            this.updated.clear();
            for (Saveable i : this.deleted) {
                i.performDbDelete();
            }
            this.deleted.clear();
            for (Saveable i : this.inserted) {
                i.performDbInsert(this.id);
            }
            this.inserted.clear();
            if (commit) {
                this.definitions.commit();
                this.definitions.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            if (commit) {
                this.definitions.rollback();
                this.definitions.setAutoCommit(true);
            }
            throw e;
        }
    }

    public D remove(int pos) {
        Saveable data = (Saveable)this.dependentData.remove(pos);
        this.removeInChangeTrackers(data);
        return (D)data;
    }

    protected void removeInChangeTrackers(D data) {
        if (this.inserted.contains(data)) {
            this.inserted.remove(data);
        } else {
            this.updated.remove(data);
            this.deleted.add(data);
        }
    }

    public void add(D item) {
        this.inserted.add(item);
    }

    public void add(int pos, D item) {
        this.dependentData.add(pos, item);
        this.inserted.add(item);
    }

    public D set(int pos, D item) {
        Saveable old = (Saveable)this.dependentData.get(pos);
        this.dependentData.set(pos, item);
        if (this.inserted.contains(old)) {
            this.inserted.remove(old);
            this.inserted.add(item);
        } else {
            this.updated.remove(old);
            this.updated.add(item);
        }
        return (D)old;
    }

    public D get(int pos) {
        return (D)((Saveable)this.dependentData.get(pos));
    }

    public void deleteAll() {
        this.deleted.addAll(this.dependentData);
        this.deleted.removeAll(this.inserted);
        this.dependentData.clear();
        this.inserted.clear();
        this.updated.clear();
    }

    public int size() {
        return this.dependentData.size();
    }

    protected void loadFromDb(ResultSet data) throws SQLException {
        this.dependentData.clear();
        this.updated.clear();
        this.deleted.clear();
        this.inserted.clear();
        while (data.next()) {
            ResultSet entry = this.getDependent((D)data);
            this.dependentData.add(entry);
        }
    }

    public boolean isInserted(int pos) {
        return this.inserted.contains(this.dependentData.get(pos));
    }

    public abstract void loadFromDb() throws SQLException;

    protected abstract D getEmptyDependent();

    protected abstract D getDependent(ResultSet var1) throws SQLException;

    protected abstract D getDependent(D var1);

    @Override
    public Iterator<D> iterator() {
        return this.dependentData.iterator();
    }

    public int getId() {
        return this.id;
    }

    protected void commit(int newId) throws SQLException {
        this.id = newId;
        this.commit();
    }
}

