/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.DbBackedData;
import brn.distsim.client.data.Saveable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DbBackedEntries<E extends Entry>
extends DbBackedData<E> {
    protected Map<String, E> entries;

    public DbBackedEntries(Connection definitions, int id) {
        super(definitions);
        this.id = id;
        this.entries = new HashMap<String, E>();
    }

    public DbBackedEntries(DbBackedEntries<E> other) {
        this(other.definitions, 0);
        for (Entry e : other.dependentData) {
            Entry newEntry = this.getDependent(e);
            this.dependentData.add(newEntry);
            this.inserted.add(newEntry);
            this.entries.put(e.name, newEntry);
        }
    }

    public DbBackedEntries(Connection definitions, int id, ResultSet data) throws SQLException {
        this(definitions, id);
        this.loadFromDb(data);
    }

    @Override
    protected void loadFromDb(ResultSet data) throws SQLException {
        this.entries.clear();
        super.loadFromDb(data);
        for (Entry entry : this.dependentData) {
            this.entries.put(entry.getName(), entry);
        }
    }

    public E remove(String name) {
        Entry entry = (Entry)this.entries.remove(name);
        if (entry != null) {
            this.dependentData.remove(entry);
            super.removeInChangeTrackers(entry);
        }
        return (E)entry;
    }

    @Override
    public E remove(int pos) {
        Entry data = (Entry)super.remove(pos);
        this.entries.remove(data.name);
        return (E)data;
    }

    @Override
    public void add(E item) {
        super.add(item);
        this.entries.put(((Entry)item).name, item);
    }

    @Override
    public E set(int pos, E item) {
        Entry old = (Entry)super.set(pos, item);
        this.entries.remove(old.name);
        this.entries.put(((Entry)item).name, item);
        return (E)old;
    }

    public void put(E item) {
        String index = ((Entry)item).name;
        Entry old = (Entry)this.entries.get(index);
        this.entries.put(index, item);
        if (old != null) {
            this.dependentData.remove(old);
            if (this.inserted.contains(old)) {
                this.inserted.remove(old);
                this.inserted.add(item);
            } else {
                this.updated.remove(old);
                this.updated.add(item);
            }
        } else {
            this.inserted.add(item);
        }
        this.dependentData.add(item);
    }

    @Override
    public void deleteAll() {
        super.deleteAll();
        this.entries.clear();
    }

    public E get(String index) {
        return (E)((Entry)this.entries.get(index));
    }

    protected static List<String> namesToList(ResultSet names) throws SQLException {
        ArrayList<String> res = new ArrayList<String>();
        while (names.next()) {
            res.add(names.getString(1));
        }
        return res;
    }

    public Set<String> keySet() {
        return this.entries.keySet();
    }

    public abstract class Entry
    implements Saveable {
        protected String name;

        public Entry(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

