/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.DbBackedData;
import brn.distsim.client.data.GroupConfigurationFiles;
import brn.distsim.client.data.GroupNumericParameters;
import brn.distsim.client.data.GroupResultsFiles;
import brn.distsim.client.data.GroupStringParameters;
import brn.distsim.client.data.Saveable;
import brn.distsim.client.data.Simulation;
import brn.distsim.client.data.SimulationCreator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends DbBackedData<Simulation>
implements Saveable {
    private int studyId;
    private String name;
    private GroupStringParameters stringParameters;
    private GroupNumericParameters numericParameters;
    private GroupConfigurationFiles configurationFiles;
    private GroupResultsFiles resultsFiles;

    public Group(Connection db, String name, int studyId) {
        super(db);
        this.id = 0;
        this.name = name;
        this.studyId = studyId;
        this.configurationFiles = new GroupConfigurationFiles(db, this.id);
        this.resultsFiles = new GroupResultsFiles(db, this.id);
        this.stringParameters = new GroupStringParameters(db, this.id);
        this.numericParameters = new GroupNumericParameters(db, this.id);
    }

    public Group(Group other) {
        super(other.definitions);
        this.name = other.name;
        this.studyId = other.studyId;
        this.configurationFiles = new GroupConfigurationFiles(other.configurationFiles);
        this.resultsFiles = new GroupResultsFiles(other.resultsFiles);
        this.numericParameters = new GroupNumericParameters(other.numericParameters);
        this.stringParameters = new GroupStringParameters(other.stringParameters);
    }

    public Group(Connection db, ResultSet groups) throws SQLException {
        super(db);
        this.name = groups.getString("name");
        this.studyId = groups.getInt("studyId");
        this.id = groups.getInt("id");
        String idColumn = "groupId";
        this.configurationFiles = new GroupConfigurationFiles(db, this.id, this.loadSubObject("group_in_files", idColumn));
        this.resultsFiles = new GroupResultsFiles(db, this.id, this.loadSubObject("group_out_files", idColumn));
        this.numericParameters = new GroupNumericParameters(db, this.id, this.loadSubObject(GroupNumericParameters.TABLE_NAME, idColumn));
        this.stringParameters = new GroupStringParameters(db, this.id, this.loadSubObject("group_string_params", idColumn));
        ResultSet simulations = this.statement.executeQuery("SELECT * FROM simulations WHERE groupId = " + this.id + ";");
        while (simulations.next()) {
            this.dependentData.add(new Simulation(db, simulations));
        }
    }

    public Group(Group group, String groupName) {
        this(group);
        this.name = groupName;
    }

    public Group(Group other, int studyId) {
        this(other);
        this.studyId = studyId;
    }

    private ResultSet loadSubObject(String tableName, String idColumn) throws SQLException {
        return this.statement.executeQuery("SELECT * FROM " + tableName + " WHERE " + idColumn + "='" + this.id + "';");
    }

    @Override
    public void performDbUpdate() throws SQLException {
        this.statement.executeUpdate("UPDATE groups SET studyId=" + this.studyId + ", name='" + this.name + "' WHERE id=" + this.id + ";");
        this.commitAll();
    }

    @Override
    public void performDbDelete() throws SQLException {
        this.deleteSubObject(this.configurationFiles);
        this.deleteSubObject(this.resultsFiles);
        this.deleteSubObject(this.stringParameters);
        this.deleteSubObject(this.numericParameters);
        this.deleteSubObject(this);
        this.statement.executeUpdate("DELETE FROM groups WHERE id=" + this.id + ";");
    }

    private void deleteSubObject(DbBackedData b) throws SQLException {
        b.deleteAll();
        b.commit();
    }

    @Override
    public void performDbInsert(int studyId) throws SQLException {
        this.studyId = studyId;
        this.statement.executeUpdate("INSERT INTO groups SET studyId=" + studyId + ", name='" + this.name + "';", 1);
        ResultSet key = this.statement.getGeneratedKeys();
        key.next();
        this.configurationFiles.id = this.id = key.getInt(1);
        this.resultsFiles.id = this.id;
        this.stringParameters.id = this.id;
        this.numericParameters.id = this.id;
        this.commitAll();
    }

    public void createSimulations() throws SQLException {
        SimulationCreator c = new SimulationCreator(this.definitions, this);
        Simulation sim = c.next();
        while (sim != null) {
            this.add(sim);
            sim = c.next();
        }
    }

    private void commitAll() throws SQLException {
        this.commit();
        this.configurationFiles.commit();
        this.resultsFiles.commit();
        this.stringParameters.commit();
        this.numericParameters.commit();
    }

    @Override
    public void loadFromDb() throws SQLException {
        ResultSet group = this.statement.executeQuery("SELECT * FROM groups WHERE id=" + this.id + ";");
        if (group.next()) {
            this.name = group.getString("name");
            this.studyId = group.getInt("studyId");
            ResultSet sims = this.statement.executeQuery("SELECT * FROM simulations WHERE groupId=" + this.id + ";");
            super.loadFromDb(sims);
        }
        this.numericParameters.loadFromDb();
        this.stringParameters.loadFromDb();
        this.configurationFiles.loadFromDb();
        this.resultsFiles.loadFromDb();
    }

    @Override
    public Simulation getEmptyDependent() {
        return new Simulation(this.definitions, this.id);
    }

    @Override
    public Simulation getDependent(ResultSet data) throws SQLException {
        return new Simulation(this.definitions, data);
    }

    @Override
    public Simulation getDependent(Simulation other) {
        return new Simulation(other);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GroupNumericParameters getNumericParameters() {
        return this.numericParameters;
    }

    public GroupStringParameters getStringParameters() {
        return this.stringParameters;
    }

    public GroupConfigurationFiles getConfigurationFiles() {
        return this.configurationFiles;
    }

    public GroupResultsFiles getResultsFiles() {
        return this.resultsFiles;
    }
}

