/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.DbBackedProperties;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupConfigurationFiles
extends DbBackedProperties<File> {
    protected PreparedStatement writeFile;
    public static final String TABLE_NAME = "group_in_files";

    public GroupConfigurationFiles(Connection definitions, int groupId) {
        super(definitions, groupId);
        try {
            this.writeFile = definitions.prepareStatement("INSERT IGNORE INTO in_files set content = ?;");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public GroupConfigurationFiles(GroupConfigurationFiles other) {
        super(other);
        try {
            this.writeFile = this.definitions.prepareStatement("INSERT IGNORE INTO in_files set content = ?;");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public GroupConfigurationFiles(Connection db, int id, ResultSet set) throws SQLException {
        super(db, id, set);
        this.writeFile = this.definitions.prepareStatement("INSERT IGNORE INTO in_files set content = ?;");
    }

    private void writeFileToDB(String file) throws SQLException {
        try {
            FileInputStream stream = new FileInputStream(file);
            this.writeFileToDB(stream);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    private void writeFileToDB(InputStream stream) throws SQLException {
        try {
            this.writeFile.setBinaryStream(1, stream, stream.available());
            this.writeFile.executeUpdate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getFileId(String remotePath) {
        return ((File)this.entries.get(remotePath)).getFileId();
    }

    @Override
    public File getEmptyDependent() {
        return new File(null, null);
    }

    @Override
    public File getDependent(ResultSet data) throws SQLException {
        return new File(data);
    }

    @Override
    public File getDependent(File other) {
        return new File(other.name, other.value, other.fileId);
    }

    @Override
    public void loadFromDb() throws SQLException {
        ResultSet files = this.statement.executeQuery("SELECT * FROM group_in_files WHERE groupId=" + this.id + ";");
        this.loadFromDb(files);
    }

    public static List<String> getNames(Connection db, int studyId) throws SQLException {
        ResultSet names = db.createStatement().executeQuery("SELECT DISTINCT remotePath FROM group_in_files WHERE groupId in (SELECT id FROM groups WHERE studyId=" + studyId + ");");
        return GroupConfigurationFiles.namesToList(names);
    }

    public class File
    extends DbBackedProperties.Property {
        protected int fileId;
        private boolean isContent;

        public File(String remotePath, String localPath) {
            super(remotePath, localPath);
            this.isContent = false;
            this.fileId = 0;
        }

        public File(String remotePath, String content, boolean isContent) {
            super(remotePath, content);
            this.isContent = false;
            this.fileId = 0;
            this.isContent = true;
        }

        public File(ResultSet data) throws SQLException {
            super(data.getString("remotePath"), null);
            this.isContent = false;
            this.fileId = data.getInt("fileId");
        }

        protected File(String remotePath, String localPath, int fileId) {
            super(remotePath, localPath);
            this.isContent = false;
            this.fileId = fileId;
        }

        public int getFileId() {
            return this.fileId;
        }

        public void performDbInsert(int groupId) throws SQLException {
            String idString;
            GroupConfigurationFiles.this.id = groupId;
            if (this.value != null) {
                idString = "LAST_INSERT_ID()";
                if (!this.isContent) {
                    GroupConfigurationFiles.this.writeFileToDB(this.value);
                } else {
                    GroupConfigurationFiles.this.writeFileToDB(new ByteArrayInputStream(this.value.getBytes()));
                }
            } else {
                idString = "'" + this.fileId + "'";
            }
            String sql = "INSERT INTO group_in_files VALUES ('";
            sql = String.valueOf(sql) + GroupConfigurationFiles.this.id;
            sql = String.valueOf(sql) + "', '" + this.name;
            sql = String.valueOf(sql) + "', " + idString + ");";
            GroupConfigurationFiles.this.statement.execute(sql);
        }

        public void performDbDelete() throws SQLException {
            GroupConfigurationFiles.this.statement.execute("DELETE FROM group_in_files WHERE groupId='" + GroupConfigurationFiles.this.id + "' AND remotePath='" + this.name + "';");
        }

        public void performDbUpdate() throws SQLException {
            GroupConfigurationFiles.this.writeFileToDB(this.value);
            String sql = "UPDATE group_in_files SET fileId=LAST_INSERT_ID()  WHERE groupName='" + GroupConfigurationFiles.this.id + "' AND  remotePath='" + this.name + "';";
            GroupConfigurationFiles.this.statement.execute(sql);
        }
    }
}

