/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.DbBackedEntries;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupNumericParameters
extends DbBackedEntries<Parameter> {
    public static String TABLE_NAME = "group_numeric_params";

    public GroupNumericParameters(Connection definitions, int id) {
        super(definitions, id);
    }

    public GroupNumericParameters(GroupNumericParameters other) {
        super(other);
    }

    public GroupNumericParameters(Connection db, int id, ResultSet set) throws SQLException {
        super(db, id, set);
    }

    @Override
    public Parameter getEmptyDependent() {
        return new Parameter(null, null, null, null);
    }

    @Override
    public Parameter getDependent(ResultSet data) throws SQLException {
        return new Parameter(data.getString("name"), data.getString("min"), data.getString("max"), data.getString("step"));
    }

    @Override
    public Parameter getDependent(Parameter other) {
        return new Parameter(other.name, other.min, other.max, other.step);
    }

    @Override
    public void loadFromDb() throws SQLException {
        ResultSet params = this.statement.executeQuery("SELECT * FROM " + TABLE_NAME + " WHERE groupId=" + this.id + ";");
        super.loadFromDb(params);
    }

    public static List<String> getNames(Connection db, int studyId) throws SQLException {
        ResultSet names = db.createStatement().executeQuery("SELECT DISTINCT name FROM " + TABLE_NAME + " WHERE groupId in (SELECT id FROM groups WHERE studyId=" + studyId + ") ORDER BY name;");
        return GroupNumericParameters.namesToList(names);
    }

    public class Parameter
    extends DbBackedEntries.Entry {
        protected String min;
        protected String max;
        protected String step;

        public Parameter(String name, String min, String max, String step) {
            super(name);
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public String getMin() {
            return this.min;
        }

        public String getMax() {
            return this.max;
        }

        public String getStep() {
            return this.step;
        }

        public void performDbInsert(int groupId) throws SQLException {
            GroupNumericParameters.this.id = groupId;
            GroupNumericParameters.this.statement.execute("INSERT INTO " + TABLE_NAME + " VALUES ('" + GroupNumericParameters.this.id + "', '" + this.name + "', '" + this.min + "', '" + this.max + "', '" + this.step + "');");
        }

        public void performDbDelete() throws SQLException {
            GroupNumericParameters.this.statement.execute("DELETE FROM " + TABLE_NAME + " WHERE groupId='" + GroupNumericParameters.this.id + "' AND name='" + this.name + "';");
        }

        public void performDbUpdate() throws SQLException {
            GroupNumericParameters.this.statement.execute("REPLACE INTO " + TABLE_NAME + " VALUES ('" + GroupNumericParameters.this.id + "', '" + this.name + "', '" + this.min + "', '" + this.max + "', '" + this.step + "');");
        }
    }
}

