/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.DbBackedEntries;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupResultsFiles
extends DbBackedEntries<File> {
    public static final String TABLE_NAME = "group_out_files";

    public GroupResultsFiles(Connection definitions, int groupId) {
        super(definitions, groupId);
    }

    public GroupResultsFiles(GroupResultsFiles other) {
        super(other);
    }

    public GroupResultsFiles(Connection db, int id, ResultSet set) throws SQLException {
        super(db, id, set);
    }

    @Override
    public File getEmptyDependent() {
        return new File(null);
    }

    @Override
    public File getDependent(ResultSet data) throws SQLException {
        return new File(data.getString("remotePath"));
    }

    @Override
    public File getDependent(File other) {
        return new File(other.name);
    }

    @Override
    public void loadFromDb() throws SQLException {
        ResultSet params = this.statement.executeQuery("SELECT * FROM group_out_files WHERE groupId=" + this.id + ";");
        super.loadFromDb(params);
    }

    @Override
    public void add(String name) {
        if (this.entries.containsKey(name)) {
            return;
        }
        File file = new File(name);
        this.put(file);
    }

    public static List<String> getNames(Connection db, int studyId) throws SQLException {
        ResultSet names = db.createStatement().executeQuery("SELECT DISTINCT remotePath FROM group_out_files WHERE groupId in (SELECT id FROM groups WHERE studyId=" + studyId + ");");
        return GroupResultsFiles.namesToList(names);
    }

    public class File
    extends DbBackedEntries.Entry {
        public File(String remotePath) {
            super(remotePath);
        }

        public void performDbInsert(int groupId) throws SQLException {
            GroupResultsFiles.this.id = groupId;
            GroupResultsFiles.this.statement.execute("INSERT INTO group_out_files SET remotePath='" + this.name + "', groupId='" + GroupResultsFiles.this.id + "';");
        }

        public void performDbDelete() throws SQLException {
            GroupResultsFiles.this.statement.execute("DELETE FROM group_out_files WHERE groupId='" + GroupResultsFiles.this.id + "' AND remotePath='" + this.name + "';");
        }

        public void performDbUpdate() throws SQLException {
            this.performDbInsert(GroupResultsFiles.this.id);
        }
    }
}

