/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.DbBackedProperties;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupStringParameters
extends DbBackedProperties<Parameter> {
    public static final String TABLE_NAME = "group_string_params";

    public GroupStringParameters(Connection definitions, int groupId) {
        super(definitions, groupId);
    }

    public GroupStringParameters(GroupStringParameters other) {
        super(other);
    }

    public GroupStringParameters(Connection db, int id, ResultSet set) throws SQLException {
        super(db, id, set);
    }

    @Override
    protected Parameter getEmptyDependent() {
        return new Parameter(null, null, null);
    }

    @Override
    protected Parameter getDependent(ResultSet data) throws SQLException {
        String name = data.getString("name");
        Parameter next = (Parameter)this.entries.get(name);
        Parameter ret = new Parameter(name, data.getString("value"), next);
        this.entries.put(name, ret);
        return ret;
    }

    @Override
    protected Parameter getDependent(Parameter other) {
        return new Parameter(other.name, other.value, (Parameter)this.entries.get(other.name));
    }

    @Override
    public void loadFromDb() throws SQLException {
        ResultSet params = this.statement.executeQuery("SELECT * FROM group_string_params WHERE groupId=" + this.id + ";");
        super.loadFromDb(params);
    }

    public static List<String> getNames(Connection db, int studyId) throws SQLException {
        ResultSet names = db.createStatement().executeQuery("SELECT DISTINCT name FROM group_string_params WHERE groupId in (SELECT id FROM groups WHERE studyId=" + studyId + ") ORDER BY name;");
        return GroupStringParameters.namesToList(names);
    }

    public void add(String name, String string) {
        Parameter par = (Parameter)this.entries.get(name);
        while (par != null) {
            if (par.value == string) {
                return;
            }
            par = par.next;
        }
        super.add(new Parameter(name, string, (Parameter)this.entries.get(name)));
    }

    public Parameter remove(Parameter par) {
        this.dependentData.remove(par);
        this.removeInChangeTrackers(par);
        boolean updateEntries = false;
        if (this.entries.get(par.name) == par) {
            updateEntries = true;
            this.entries.remove(par.name);
        }
        if (par.prev != null) {
            par.prev.next = par.next;
            if (updateEntries) {
                this.entries.put(par.name, par.prev);
                updateEntries = false;
            }
        }
        if (par.next != null) {
            par.next.prev = par.prev;
            if (updateEntries) {
                this.entries.put(par.name, par.next);
            }
        }
        return par;
    }

    @Override
    public Parameter remove(String name) {
        Parameter first = (Parameter)super.remove(name);
        if (first != null) {
            Parameter gone = first.next;
            while (gone != null) {
                this.remove(gone);
                gone = gone.next;
            }
        }
        return first;
    }

    @Override
    protected void loadFromDb(ResultSet data) throws SQLException {
        this.dependentData.clear();
        this.updated.clear();
        this.deleted.clear();
        this.inserted.clear();
        while (data.next()) {
            Parameter entry = this.getDependent(data);
            this.dependentData.add(entry);
            this.entries.put(entry.getName(), entry);
        }
    }

    @Override
    public Parameter remove(int pos) {
        return this.remove((Parameter)this.dependentData.get(pos));
    }

    public class Parameter
    extends DbBackedProperties.Property {
        protected Parameter next;
        protected Parameter prev;

        private Parameter(String name, String value, Parameter next) {
            super(name, value);
            this.next = next;
            if (next != null) {
                next.prev = this;
            }
        }

        public Parameter getNext() {
            return this.next;
        }

        public void performDbInsert(int groupId) throws SQLException {
            GroupStringParameters.this.id = groupId;
            GroupStringParameters.this.statement.execute("INSERT INTO group_string_params VALUES ('" + GroupStringParameters.this.id + "', '" + this.name + "', '" + this.value + "');");
        }

        public void performDbDelete() throws SQLException {
            GroupStringParameters.this.statement.execute("DELETE FROM group_string_params WHERE groupId='" + GroupStringParameters.this.id + "' AND name='" + this.name + "' AND value='" + this.value + "';");
        }

        public void performDbUpdate() throws SQLException {
            GroupStringParameters.this.statement.execute("REPLACE INTO group_string_params VALUES ('" + GroupStringParameters.this.id + "', '" + this.name + "', '" + this.value + "');");
        }
    }
}

