/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.DbBackedEntries;
import brn.distsim.client.data.Saveable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Package
implements Saveable {
    private Connection definitions;
    private String name;
    private String version;
    private String architecture;
    private String url;

    public Package(Connection definitions, String name, String version, String architecture, String url) {
        this.definitions = definitions;
        this.name = name;
        this.version = version;
        this.architecture = architecture;
        this.url = url;
    }

    @Override
    public void performDbInsert(int x) throws SQLException {
        this.performDbInsert();
    }

    public void performDbInsert() throws SQLException {
        this.definitions.createStatement().executeUpdate("INSERT INTO packages VALUES ('" + this.name + "', '" + this.version + "', '" + this.architecture + "', '" + this.url + "');");
    }

    public void upload(String localFile) throws IOException {
        FileInputStream in = new FileInputStream(localFile);
        URLConnection outUrl = new URL(this.url).openConnection();
        outUrl.setDoOutput(true);
        outUrl.connect();
        OutputStream out = outUrl.getOutputStream();
        int read = 0;
        byte[] data = new byte[1024];
        while ((read = ((InputStream)in).read(data)) > 0) {
            out.write(data, 0, read);
        }
        out.flush();
        out.close();
    }

    public static Map<String, List<String>> getAllVersions(Connection db) throws SQLException {
        ResultSet versions = db.createStatement().executeQuery("SELECT name, version FROM packages ORDER BY name, version;");
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        String prevName = null;
        LinkedList<String> currentVersions = null;
        while (versions.next()) {
            String name = versions.getString(1);
            if (!name.equals(prevName)) {
                prevName = name;
                currentVersions = new LinkedList<String>();
                ret.put(name, currentVersions);
            }
            currentVersions.add(versions.getString(2));
        }
        return ret;
    }

    public static List<String> getNames(Connection db) throws SQLException {
        ResultSet names = db.createStatement().executeQuery("SELECT DISTINCT name FROM packages ORDER BY name;");
        return DbBackedEntries.namesToList(names);
    }

    public static List<String> getVersions(Connection db, String name) throws SQLException {
        ResultSet versions = db.createStatement().executeQuery("SELECT DISTINCT version FROM packages WHERE name ='" + name + "' ORDER BY version;");
        return DbBackedEntries.namesToList(versions);
    }

    public static List<String> getArchitectures(Connection db, String name, String version) throws SQLException {
        ResultSet architectures = db.createStatement().executeQuery("SELECT architecture FROM packages WHERE name ='" + name + "' AND version='" + version + "' ORDER BY architecture;");
        return DbBackedEntries.namesToList(architectures);
    }

    @Override
    public void performDbUpdate() throws SQLException {
        this.definitions.createStatement().executeUpdate("REPLACE INTO packages VALUES ('" + this.name + "', '" + this.version + "', '" + this.architecture + "', '" + this.url + "');");
    }

    @Override
    public void performDbDelete() throws SQLException {
        this.definitions.createStatement().executeUpdate("DELETE FROM packages WHERE name='" + this.name + "' AND version='" + this.version + "' AND architecture='" + this.architecture + "');");
    }

    @Override
    public String getName() {
        return this.name;
    }
}

