/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Results {
    private Statement statement;
    private int simulationId;

    public Results(Connection results, int id) throws SQLException {
        this.statement = results.createStatement();
        this.simulationId = id;
    }

    public void deleteAll() throws SQLException {
        this.statement.executeUpdate("DELETE FROM java_lang_Object WHERE simulationId=" + this.simulationId + ";");
        this.statement.executeUpdate("DELETE FROM out_files WHERE simulationId=" + this.simulationId + ";");
        this.statement.executeUpdate("DELETE FROM progress WHERE simulationId=" + this.simulationId + ";");
        this.statement.executeUpdate("DELETE FROM class_hierarchy WHERE simualtionId=" + this.simulationId + ";");
        this.statement.executeUpdate("DELETE FROM class_members WHERE simualtionId=" + this.simulationId + ";");
    }

    public List<String> getTableNames() throws SQLException {
        ResultSet names = this.statement.executeQuery("SELECT subclass FROM class_hierarchy WHERE simulationId=" + this.simulationId + ";");
        LinkedList<String> nameList = new LinkedList<String>();
        while (names.next()) {
            nameList.add(names.getString(1));
        }
        return nameList;
    }

    public Vector<String> getColumnNames(String name) throws SQLException {
        Vector<String> result = new Vector<String>();
        ResultSet fields = this.statement.executeQuery("SHOW COLUMNS FROM " + name + ";");
        while (fields.next()) {
            result.add(fields.getString(1));
        }
        return result;
    }

    public Vector<Vector<String>> getData(String name) throws SQLException {
        ResultSet data = this.statement.executeQuery("SELECT SQL_CALC_FOUND_ROWS * FROM " + name + " WHERE primary_key IN (SELECT primary_key FROM java_lang_Object WHERE simulationId=" + this.simulationId + ") ORDER BY primary_key;");
        data.last();
        Vector<Vector<String>> result = new Vector<Vector<String>>(data.getRow());
        int numCols = data.getMetaData().getColumnCount();
        data.beforeFirst();
        while (data.next()) {
            Vector<String> row = new Vector<String>(numCols);
            int i = 1;
            while (i <= numCols) {
                row.add(data.getString(i));
                ++i;
            }
            result.add(row);
        }
        return result;
    }

    public String getSuperclass(String name) throws SQLException {
        ResultSet superName = this.statement.executeQuery("SELECT superclass FROM class_hierarchy WHERE simulationId=" + this.simulationId + " AND subclass='" + name + "';");
        if (superName.next()) {
            String ret = superName.getString(1);
            return ret;
        }
        return null;
    }

    public Vector<String> getSubTableColumnNames(String subName) throws SQLException {
        Vector<String> result = new Vector<String>();
        ResultSet fields = this.statement.executeQuery("SHOW COLUMNS FROM " + subName + ";");
        fields.next();
        while (fields.next()) {
            result.add(fields.getString(1));
        }
        return result;
    }

    public Vector<Vector<String>> getSuperClassData(String subName, String name) throws SQLException {
        ResultSet data = this.statement.executeQuery("SELECT SQL_CALC_FOUND_ROWS * FROM " + subName + " WHERE primary_key IN (SELECT primary_key FROM " + name + " WHERE primary_key IN (SELECT primary_key FROM java_lang_Object WHERE simulationId=" + this.simulationId + ")) ORDER BY primary_key;");
        data.last();
        Vector<Vector<String>> result = new Vector<Vector<String>>(data.getRow());
        int numCols = data.getMetaData().getColumnCount();
        data.beforeFirst();
        while (data.next()) {
            Vector<String> row = new Vector<String>(numCols - 1);
            int i = 2;
            while (i <= numCols) {
                row.add(data.getString(i));
                ++i;
            }
            result.add(row);
        }
        return result;
    }

    public List<String> getChildTableNames(String parentTable) throws SQLException {
        ResultSet names = this.statement.executeQuery("SELECT member FROM class_members WHERE simulationId=" + this.simulationId + " AND class='" + parentTable + "';");
        LinkedList<String> nameList = new LinkedList<String>();
        while (names.next()) {
            nameList.add(names.getString(1));
        }
        return nameList;
    }

    public Vector<Vector<String>> getChildData(String table, int parentKey) throws SQLException {
        ResultSet data = this.statement.executeQuery("SELECT * FROM " + table + " WHERE uid=" + parentKey + ";");
        data.last();
        Vector<Vector<String>> result = new Vector<Vector<String>>(data.getRow());
        int numCols = data.getMetaData().getColumnCount();
        data.beforeFirst();
        while (data.next()) {
            Vector<String> row = new Vector<String>(numCols - 1);
            int i = 2;
            while (i <= numCols) {
                row.add(data.getString(i));
                ++i;
            }
            result.add(row);
        }
        return result;
    }
}

