/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.DbBackedProperties;
import brn.distsim.client.data.Progress;
import brn.distsim.client.data.Results;
import brn.distsim.client.data.Saveable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Simulation
extends DbBackedProperties<Parameter>
implements Saveable {
    public static final String TABLE_NAME = "params";
    protected int groupId;
    protected int hostId;
    private Timestamp defined;
    private Progress progress;

    public Simulation(Connection db, ResultSet simulations) throws SQLException {
        super(db, simulations.getInt("id"));
        this.groupId = simulations.getInt("groupId");
        this.hostId = simulations.getInt("assigned");
        this.defined = simulations.getTimestamp("defined");
        this.loadFromDb(this.statement.executeQuery("SELECT * FROM params WHERE simulationId=" + this.id + ";"));
    }

    public void loadProgress(Connection results) throws SQLException {
        this.progress = new Progress(results, this.id);
        this.progress.loadFromDb();
    }

    public Progress getProgress() {
        return this.progress;
    }

    public Simulation(Connection definitions, int groupId) {
        super(definitions, 0);
        this.groupId = groupId;
    }

    public Simulation(Simulation other) {
        super(other.definitions, 0);
        this.groupId = other.groupId;
    }

    public Simulation(Simulation other, int groupId) {
        super(other.definitions, 0);
        this.groupId = groupId;
    }

    @Override
    public void performDbDelete() throws SQLException {
        this.deleteAll();
        this.commit();
        this.statement.executeUpdate("DELETE FROM simulations WHERE id=" + this.id + " AND assigned<=>NULL;");
    }

    @Override
    public void performDbInsert(int groupId) throws SQLException {
        this.groupId = groupId;
        this.statement.executeUpdate("INSERT INTO simulations SET groupId=" + groupId + ", defined=NOW();", 1);
        ResultSet key = this.statement.getGeneratedKeys();
        key.next();
        this.id = key.getInt(1);
        this.commit();
    }

    @Override
    public void performDbUpdate() throws SQLException {
        this.statement.executeUpdate("REPLACE INTO simulations SET groupId=" + this.groupId + ", defined=NOW() WHERE id=" + this.id + ";");
        this.commit();
    }

    @Override
    public Parameter getEmptyDependent() {
        return new Parameter(null, null);
    }

    @Override
    public Parameter getDependent(ResultSet data) throws SQLException {
        return new Parameter(data.getString("name"), data.getString("value"));
    }

    @Override
    public Parameter getDependent(Parameter other) {
        return new Parameter(other.name, other.value);
    }

    @Override
    public void loadFromDb() throws SQLException {
        ResultSet sim = this.statement.executeQuery("SELECT * FROM simulations WHERE id=" + this.id + ";");
        if (sim.next()) {
            this.groupId = sim.getInt("groupId");
            this.hostId = sim.getInt("assigned");
            this.defined = sim.getTimestamp("defined");
            ResultSet params = this.statement.executeQuery("SELECT * FROM params WHERE simulationId=" + this.id + ";");
            super.loadFromDb(params);
        }
    }

    @Override
    public String getName() {
        return "simulation:" + this.groupId + ":" + this.id;
    }

    @Override
    public void put(Properties props) {
        for (Object name : props.keySet()) {
            this.put(new Parameter(name.toString(), props.get(name).toString()));
        }
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getHost() {
        return this.hostId;
    }

    public Timestamp getDefined() {
        return this.defined;
    }

    public Results getResults(Connection results) throws SQLException {
        return new Results(results, this.id);
    }

    public void unassign() throws SQLException {
        this.statement.executeUpdate("UPDATE simulations SET assigned=NULL WHERE id=" + this.id + ";");
    }

    public class Parameter
    extends DbBackedProperties.Property {
        public Parameter(String name, String value) {
            super(name, value);
        }

        public Parameter(Parameter p) {
            super(p.name, p.value);
        }

        public void performDbInsert(int simulationId) throws SQLException {
            Simulation.this.statement.executeUpdate("INSERT INTO params VALUES (" + simulationId + ", '" + this.name + "', '" + this.value + "');");
        }

        public void performDbDelete() throws SQLException {
            Simulation.this.statement.executeUpdate("DELETE FROM params WHERE simulationId=" + Simulation.this.id + " AND name='" + this.name + "';");
        }

        public void performDbUpdate() throws SQLException {
            Simulation.this.statement.executeUpdate("REPLACE INTO params VALUES (" + Simulation.this.id + ", '" + this.name + "', '" + this.value + "');");
        }
    }
}

