/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.Group;
import brn.distsim.client.data.GroupNumericParameters;
import brn.distsim.client.data.GroupStringParameters;
import brn.distsim.client.data.Simulation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.nfunk.jep.JEP;

public class SimulationCreator {
    private Connection definitions;
    private Map<String, Double> currentNumericParams;
    private Map<String, GroupStringParameters.Parameter> currentStringParams;
    private List<String> stringNames;
    private int currentNumericPos;
    private int currentStringPos;
    private int groupId;
    private JEP parser;
    private int numDelays;
    private int maxDelays;
    private GroupStringParameters stringParams;
    private GroupNumericParameters numericParams;

    public SimulationCreator(Connection definitions, Group group) throws SQLException {
        this.definitions = definitions;
        this.stringParams = group.getStringParameters();
        this.numericParams = group.getNumericParameters();
        this.groupId = group.getId();
        this.currentNumericParams = new HashMap<String, Double>();
        this.currentNumericPos = 0;
        this.currentStringParams = new HashMap<String, GroupStringParameters.Parameter>();
        this.stringNames = new LinkedList<String>();
        this.stringNames.addAll(this.stringParams.keySet());
        this.currentStringPos = 0;
        this.numDelays = 0;
        this.maxDelays = this.numericParams.size() * (this.numericParams.size() + 1) / 2;
        this.parser = new JEP();
        this.parser.addStandardFunctions();
        this.parser.addStandardConstants();
        this.numericParams.commit();
        this.nextString();
    }

    private boolean nextString() {
        if (this.currentStringPos >= this.stringNames.size()) {
            --this.currentStringPos;
            return true;
        }
        if (this.currentStringPos < 0) {
            return false;
        }
        String name = this.stringNames.get(this.currentStringPos);
        GroupStringParameters.Parameter par = this.currentStringParams.get(name);
        this.parser.removeVariable(name);
        if (par != null) {
            par = par.getNext();
            this.currentStringParams.put(name, par);
            if (par == null) {
                --this.currentStringPos;
                return this.nextString();
            }
            ++this.currentStringPos;
        } else {
            par = (GroupStringParameters.Parameter)this.stringParams.get(name);
            this.currentStringParams.put(name, par);
            ++this.currentStringPos;
        }
        try {
            double val = Double.parseDouble(par.getValue());
            if (!Double.isNaN(val)) {
                this.parser.addVariable(name, val);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this.nextString();
    }

    public Simulation next() throws SQLException {
        if (this.nextNumeric() || this.nextString() && this.nextNumeric()) {
            Simulation sim = new Simulation(this.definitions, this.groupId);
            for (String name : this.currentNumericParams.keySet()) {
                Simulation simulation = sim;
                simulation.getClass();
                sim.put(simulation.new Simulation.Parameter(name, this.currentNumericParams.get(name).toString()));
            }
            for (String name : this.stringParams.keySet()) {
                String value = this.currentStringParams.get(name).getValue();
                Simulation simulation = sim;
                simulation.getClass();
                sim.put(simulation.new Simulation.Parameter(name, value));
            }
            return sim;
        }
        this.numericParams.loadFromDb();
        return null;
    }

    private boolean nextNumeric() throws SQLException {
        if (this.currentNumericPos >= this.numericParams.size()) {
            --this.currentNumericPos;
            return true;
        }
        if (this.currentNumericPos < 0) {
            this.currentNumericPos = 0;
            this.numDelays = 0;
            this.currentNumericParams.clear();
            return false;
        }
        GroupNumericParameters.Parameter param = (GroupNumericParameters.Parameter)this.numericParams.get(this.currentNumericPos);
        String name = param.getName();
        double currentVal = 0.0;
        double lastVal = 0.0;
        String max = param.getMax();
        if (max.equals("")) {
            max = "0";
        }
        this.parser.parseExpression(max);
        double maxVal = this.parser.getValue();
        if (this.parser.hasError()) {
            this.delayParam(name);
        } else if (this.currentNumericParams.containsKey(name)) {
            lastVal = this.currentNumericParams.get(name);
            String step = param.getStep();
            if (step.equals("")) {
                step = "0";
            }
            this.parser.parseExpression(step);
            double stepVal = this.parser.getValue();
            currentVal = lastVal + stepVal;
            if (Math.abs(maxVal - lastVal) > Math.abs(maxVal - currentVal)) {
                this.examineParseResult(name, currentVal);
            } else {
                this.parser.removeVariable(name);
                this.currentNumericParams.remove(name);
                --this.currentNumericPos;
            }
        } else {
            this.parser.parseExpression(param.getMin());
            currentVal = this.parser.getValue();
            this.examineParseResult(name, currentVal);
        }
        return this.nextNumeric();
    }

    private boolean examineParseResult(String name, double currentVal) {
        if (this.parser.hasError()) {
            this.delayParam(name);
            return false;
        }
        this.currentNumericParams.put(name, currentVal);
        this.parser.removeVariable(name);
        this.parser.addVariable(name, currentVal);
        ++this.currentNumericPos;
        return true;
    }

    private void delayParam(String name) {
        if (++this.numDelays > this.maxDelays) {
            throw new IllegalArgumentException("circular dependency or malformed expression detected in group " + this.groupId + " with parameter " + name);
        }
        this.numericParams.add((GroupNumericParameters.Parameter)this.numericParams.remove(this.currentNumericPos));
        this.parser.removeVariable(name);
        this.currentNumericParams.remove(name);
    }
}

