/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.data;

import brn.distsim.client.data.DbBackedData;
import brn.distsim.client.data.Group;
import brn.distsim.client.data.Saveable;
import brn.distsim.client.data.Simulation;
import brn.distsim.client.data.StudyPackages;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Study
extends DbBackedData<Group>
implements Saveable {
    private String name;
    private String command;
    private String version;
    private StudyPackages packages;

    public Study(Connection db, int id) {
        super(db);
        this.id = id;
        this.packages = new StudyPackages(db, id);
    }

    public Study(Connection db, String name, String version, String command) {
        super(db);
        this.id = 0;
        this.name = name;
        this.version = version;
        this.command = command;
        this.packages = new StudyPackages(db, 0);
    }

    public Study(Study other, String newVersion, String newCommand) {
        super(other.definitions);
        this.name = other.name;
        this.version = newVersion;
        this.command = newCommand;
        this.packages = new StudyPackages(other.packages);
    }

    public Study(Connection db, ResultSet data) throws SQLException {
        super(db);
        this.id = data.getInt("id");
        this.name = data.getString("name");
        this.version = data.getString("version");
        this.command = data.getString("command");
        this.packages = new StudyPackages(db, this.id);
        this.packages.loadFromDb();
    }

    @Override
    public void performDbUpdate() throws SQLException {
        this.commit();
        this.statement.execute("UPDATE studies SET command='" + this.command + "' WHERE id='" + this.id + "';");
        this.packages.commit();
    }

    @Override
    public void performDbDelete() throws SQLException {
        this.deleteAll();
        this.commit();
        this.packages.deleteAll();
        this.packages.commit();
        this.statement.execute("DELETE FROM studies WHERE id='" + this.id + "';");
    }

    @Override
    public void performDbInsert(int nothing) throws SQLException {
        this.performDbInsert();
    }

    public void performDbInsert() throws SQLException {
        this.statement.executeUpdate("INSERT INTO studies SET name='" + this.name + "', version='" + this.version + "', command='" + this.command + "';", 1);
        ResultSet key = this.statement.getGeneratedKeys();
        key.next();
        this.packages.id = this.id = key.getInt(1);
        this.commit();
        this.packages.commit();
    }

    @Override
    public void loadFromDb() throws SQLException {
        ResultSet groups = this.statement.executeQuery("SELECT * FROM groups WHERE studyId = " + this.id + ";");
        super.loadFromDb(groups);
        this.packages.loadFromDb();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getCommand() {
        return this.command;
    }

    @Override
    public Group getEmptyDependent() {
        return new Group(this.definitions, null, 0);
    }

    @Override
    public Group getDependent(ResultSet data) throws SQLException {
        return new Group(this.definitions, data);
    }

    @Override
    public Group getDependent(Group other) {
        return new Group(other);
    }

    public StudyPackages getPackages() {
        return this.packages;
    }

    public Study deepCopy(String newVersion) {
        Study other = new Study(this, newVersion, this.command);
        for (Group g : this.dependentData) {
            Group newGroup = new Group(g, this.id);
            other.add(newGroup);
            for (Simulation sim : g) {
                Simulation newSim = new Simulation(sim, newGroup.getId());
                newGroup.add(newSim);
                for (Simulation.Parameter p : sim) {
                    Simulation simulation = newSim;
                    simulation.getClass();
                    newSim.add(simulation.new Simulation.Parameter(p));
                }
            }
        }
        return other;
    }
}

