/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.tableModels;

import brn.distsim.client.data.DbBackedData;
import brn.distsim.client.tableModels.BaseTableModel;
import brn.distsim.client.ui.ClientFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AddRemoveTableModel<E extends DbBackedData>
extends BaseTableModel
implements ActionListener {
    protected List<String> names;
    protected E data;
    private static final long serialVersionUID = -7070362041897241214L;

    public AddRemoveTableModel(ClientFrame frame, E newData, JTable subject, List<String> names) {
        super(frame, subject);
        this.names = names;
        this.data = newData;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            if (!this.examineAction(arg0)) {
                AddRemoveTableModel.error("unrecognized action: " + arg0.getActionCommand());
            }
        }
        catch (Exception e) {
            AddRemoveTableModel.error(e);
        }
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract int getRowCount();

    protected boolean examineAction(ActionEvent e) throws SQLException {
        String command = e.getActionCommand();
        int pos = this.getSelected();
        if (command.equals("remove")) {
            if (pos < 0) {
                return true;
            }
            this.remove(pos);
            this.fireTableStructureChanged();
            return true;
        }
        if (command.equals("rollback")) {
            ((DbBackedData)this.data).loadFromDb();
            this.readData();
            return true;
        }
        if (command.equals("commit")) {
            ((DbBackedData)this.data).commit();
            ((DbBackedData)this.data).loadFromDb();
            this.readData();
            return true;
        }
        if (command.equals("create")) {
            this.create();
            this.fireTableStructureChanged();
            return true;
        }
        return false;
    }

    protected abstract void readData();

    protected abstract String create();

    protected abstract boolean remove(int var1);

    protected abstract int getSelected();

    protected abstract void setSelected(int var1);
}

