/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.tableModels;

import brn.distsim.client.data.DbBackedData;
import brn.distsim.client.data.Saveable;
import brn.distsim.client.tableModels.AddRemoveTableModel;
import brn.distsim.client.ui.ClientFrame;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditableTableModel<E extends DbBackedData<D>, D extends Saveable>
extends AddRemoveTableModel<E> {
    private static final long serialVersionUID = 1080673481662602313L;

    public EditableTableModel(ClientFrame parent, E data, JTable subject) {
        super(parent, data, subject, new ArrayList<String>());
    }

    @Override
    protected boolean examineAction(ActionEvent arg0) throws SQLException {
        if (super.examineAction(arg0)) {
            return true;
        }
        String command = arg0.getActionCommand();
        int pos = this.getSelected();
        if (command.equals("select")) {
            this.data.commit();
            if (pos < 0) {
                this.connect(null);
            } else {
                this.connect(this.data.get(pos));
            }
            this.switchTabs();
        } else if (command.equals("clone")) {
            if (pos < 0) {
                return true;
            }
            Object newData = this.cloneData(this.data.get(pos));
            this.names.add(newData.getName());
            this.insertData(newData);
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected String create() {
        D newData = this.createData();
        if (newData != null) {
            this.insertData(newData);
            String name = newData.getName();
            this.names.add(name);
            return name;
        }
        return null;
    }

    @Override
    protected boolean remove(int pos) {
        if (pos < 0) {
            return false;
        }
        if (!this.data.isInserted(pos)) {
            return false;
        }
        this.data.remove(pos);
        this.names.remove(pos);
        this.fireTableStructureChanged();
        return true;
    }

    protected void insertData(D newData) {
        if (newData == null) {
            return;
        }
        this.data.add(newData);
        this.fireTableStructureChanged();
    }

    protected abstract void connect(D var1);

    protected abstract D createData();

    protected abstract D cloneData(D var1);

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public abstract Object getValueAt(int var1, int var2);

    @Override
    protected int getSelected() {
        return this.subject.getSelectedRow();
    }

    @Override
    protected void setSelected(int pos) {
        if (pos < 0) {
            return;
        }
        this.subject.setRowSelectionInterval(pos, pos);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0 && this.data.isInserted(columnIndex);
    }
}

