/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.tableModels;

import brn.distsim.client.DBConnector;
import brn.distsim.client.data.Group;
import brn.distsim.client.data.GroupConfigurationFiles;
import brn.distsim.client.data.Study;
import brn.distsim.client.tableModels.FileTableModel;
import brn.distsim.client.ui.ClientFrame;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class FileInTableModel
extends FileTableModel {
    private static final long serialVersionUID = -3172371043672699417L;

    public FileInTableModel(ClientFrame parent, Study data, JTable subject) {
        super(parent, data, subject);
    }

    public String getColumnName(int col) {
        if (col == 0) {
            return "Configuration Files";
        }
        return "local file";
    }

    protected String create() {
        String name = JOptionPane.showInputDialog("path to file on simulating host");
        if (name != null) {
            this.names.add(name);
        }
        return name;
    }

    protected boolean remove(int pos) {
        String name = (String)this.names.get(pos);
        boolean success = true;
        int i = 0;
        while (i < ((Study)this.data).size()) {
            if (((Study)this.data).isInserted(i)) {
                ((Group)((Study)this.data).get(i)).getConfigurationFiles().remove(name);
            } else if (((Group)((Study)this.data).get(i)).getConfigurationFiles().get(name) != null) {
                success = false;
            }
            ++i;
        }
        if (success) {
            this.names.remove(pos);
        }
        return success;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String name = (String)this.names.get(rowIndex);
        if (columnIndex == 0) {
            return name;
        }
        GroupConfigurationFiles.File file = (GroupConfigurationFiles.File)((Group)((Study)this.data).get(columnIndex - 1)).getConfigurationFiles().get(name);
        if (file == null) {
            return null;
        }
        String path = file.getValue();
        if (path != null) {
            return path;
        }
        return "in DB: " + file.getFileId();
    }

    public void setValueAt(Object value, int row, int col) {
        GroupConfigurationFiles files;
        String name = (String)this.names.get(row);
        GroupConfigurationFiles groupConfigurationFiles = files = ((Group)((Study)this.data).get(col - 1)).getConfigurationFiles();
        groupConfigurationFiles.getClass();
        files.put(groupConfigurationFiles.new GroupConfigurationFiles.File(name, (String)value));
    }

    public void readData() {
        try {
            this.names = GroupConfigurationFiles.getNames(DBConnector.getDefinitions(), ((Study)this.data).getId());
        }
        catch (SQLException e) {
            FileInTableModel.error(e);
        }
    }
}

