/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.tableModels;

import brn.distsim.client.DBConnector;
import brn.distsim.client.data.Group;
import brn.distsim.client.data.Host;
import brn.distsim.client.data.Simulation;
import brn.distsim.client.data.Study;
import brn.distsim.client.tableModels.AddRemoveTableModel;
import brn.distsim.client.tableModels.BaseTableModel;
import brn.distsim.client.tableModels.ResultsModel;
import brn.distsim.client.ui.ClientFrame;
import brn.distsim.client.ui.MonitorPanel;
import brn.distsim.wrapper.RemoteSimulation;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorTableModel
extends BaseTableModel {
    private static final long serialVersionUID = 1590952144614933447L;
    private Map<Integer, String> hosts;
    private Study study;
    private List<Simulation> simulations;

    public MonitorTableModel(ClientFrame parent, Study study) {
        super(parent, parent.getMonitorPanel().getContent());
        this.study = study;
        try {
            this.simulations = new ArrayList<Simulation>();
            MonitorPanel panel = this.frame.getMonitorPanel();
            this.subject.setModel(this);
            if (study != null) {
                panel.setStudy(study.getName(), study.getVersion());
                this.readData();
            }
            this.reconnectButton(panel.getCancelButton());
            this.reconnectButton(panel.getStopButton());
            this.reconnectButton(panel.getRestartButton());
            this.reconnectButton(panel.getRefreshButton());
            this.reconnectButton(panel.getDeleteButton());
            this.reconnectButton(panel.getSelectButton());
        }
        catch (SQLException e) {
            MonitorTableModel.error(e);
        }
    }

    private void readData() throws SQLException {
        this.simulations.clear();
        this.study.loadFromDb();
        Connection results = DBConnector.getResults();
        this.hosts = Host.getHosts(DBConnector.getDefinitions());
        for (Group g : this.study) {
            g.loadFromDb();
            for (Simulation s : g) {
                s.loadProgress(results);
                this.simulations.add(s);
            }
        }
        this.fireTableStructureChanged();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String command = e.getActionCommand();
            if (command.equals("cancel")) {
                this.cancelSimulation();
                this.readData();
            } else if (command.equals("stop")) {
                this.stopSimulator();
                this.readData();
            } else if (command.equals("restart")) {
                this.restartSimulation();
                this.readData();
            } else if (command.equals("rollback")) {
                this.readData();
            } else if (command.equals("delete")) {
                this.deleteResults();
                this.readData();
            } else if (command.equals("select")) {
                new ResultsModel(this.frame, this.simulations.get(this.subject.getSelectedRow()).getResults(DBConnector.getResults()));
                this.switchTabs();
            }
        }
        catch (SQLException ex) {
            MonitorTableModel.error(ex);
        }
    }

    private void restartSimulation() {
        try {
            this.deleteResults();
            Simulation sim = this.simulations.get(this.subject.getSelectedRow());
            sim.unassign();
        }
        catch (SQLException e) {
            MonitorTableModel.error(e);
        }
    }

    private void deleteResults() {
        try {
            Simulation sim = this.simulations.get(this.subject.getSelectedRow());
            if (sim.getProgress().getState().equals("RUNNING")) {
                this.stopSimulator();
            }
            sim.getResults(DBConnector.getResults()).deleteAll();
        }
        catch (SQLException e) {
            MonitorTableModel.error(e);
        }
    }

    private void stopSimulator() {
        try {
            RemoteSimulation sim = this.getRemote();
            if (sim != null) {
                sim.stop();
            }
        }
        catch (RemoteException e) {
            AddRemoveTableModel.error(e);
        }
    }

    private RemoteSimulation getRemote() throws RemoteException {
        try {
            int hostId = this.simulations.get(this.subject.getSelectedRow()).getHost();
            String hostName = this.hosts.get(hostId);
            return (RemoteSimulation)Naming.lookup("rmi://" + hostName + "/host" + hostId);
        }
        catch (MalformedURLException e) {
            AddRemoveTableModel.error(e);
        }
        catch (NotBoundException e) {
            AddRemoveTableModel.error(e);
        }
        return null;
    }

    private void cancelSimulation() {
        try {
            RemoteSimulation sim = this.getRemote();
            if (sim != null) {
                sim.cancel();
            }
        }
        catch (RemoteException e) {
            AddRemoveTableModel.error(e);
        }
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public int getRowCount() {
        return this.simulations.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "group id";
            }
            case 1: {
                return "simulation id";
            }
            case 2: {
                return "host name";
            }
            case 3: {
                return "defined at";
            }
            case 4: {
                return "started at";
            }
            case 5: {
                return "expected end";
            }
            case 6: {
                return "progress";
            }
            case 7: {
                return "state";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Timestamp.class;
            }
            case 4: {
                return Timestamp.class;
            }
            case 5: {
                return Timestamp.class;
            }
            case 6: {
                return Float.class;
            }
            case 7: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Simulation s = this.simulations.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return s.getGroupId();
            }
            case 1: {
                return s.getId();
            }
            case 2: {
                return this.hosts.get(s.getHost());
            }
            case 3: {
                return s.getDefined();
            }
            case 4: {
                return s.getProgress().getStarted();
            }
            case 5: {
                return s.getProgress().getExpectedEnd();
            }
            case 6: {
                return new Float((double)s.getProgress().getPercentageDone() / 100.0);
            }
            case 7: {
                return s.getProgress().getState();
            }
        }
        return null;
    }
}

