/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.tableModels;

import brn.distsim.client.DBConnector;
import brn.distsim.client.data.Package;
import brn.distsim.client.tableModels.AddRemoveTableModel;
import brn.distsim.client.ui.PackageDefinitionDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JComboBox;

public class PackageDefinition
implements ActionListener {
    private PackageDefinitionDialog d;

    public void actionPerformed(ActionEvent a) {
        try {
            Connection db = DBConnector.getDefinitions();
            Object source = a.getSource();
            if (this.d == null || !this.d.isVisible()) {
                this.d = new PackageDefinitionDialog(Package.getNames(db));
                this.d.getDefineButton().addActionListener(this);
                this.d.getVersions().addActionListener(this);
                this.d.getNames().addActionListener(this);
                this.d.pack();
                this.d.setVisible(true);
            } else {
                String name = (String)this.d.getNames().getSelectedItem();
                String version = (String)this.d.getVersions().getSelectedItem();
                String arch = (String)this.d.getArchitectures().getSelectedItem();
                if (source == this.d.getNames()) {
                    JComboBox versions = this.d.getVersions();
                    versions.removeAllItems();
                    List<String> nameVersions = Package.getVersions(db, name);
                    for (String currentVersion : nameVersions) {
                        versions.addItem(currentVersion);
                    }
                    versions.addItem("");
                } else if (source == this.d.getVersions()) {
                    JComboBox archs = this.d.getArchitectures();
                    archs.removeAllItems();
                    List<String> versionArchs = Package.getArchitectures(db, name, version);
                    for (String currentArch : versionArchs) {
                        archs.addItem(currentArch);
                    }
                    archs.addItem("");
                } else if (source == this.d.getDefineButton()) {
                    Package p = new Package(db, name, version, arch, this.d.getUrl());
                    p.performDbInsert();
                    String file = this.d.getLocalPath();
                    if (file != null) {
                        p.upload(file);
                    }
                }
            }
        }
        catch (SQLException e) {
            AddRemoveTableModel.error(e);
        }
        catch (IOException e) {
            AddRemoveTableModel.error(e);
        }
    }
}

