/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.tableModels;

import brn.distsim.client.DBConnector;
import brn.distsim.client.data.Package;
import brn.distsim.client.data.Study;
import brn.distsim.client.data.StudyPackages;
import brn.distsim.client.tableModels.EditableTableModel;
import brn.distsim.client.tableModels.PackageDefinition;
import brn.distsim.client.ui.AddRemoveToolBar;
import brn.distsim.client.ui.ClientFrame;
import brn.distsim.client.ui.PackageChooseDialog;
import java.sql.SQLException;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackagesTableModel
extends EditableTableModel<StudyPackages, StudyPackages.Package> {
    private StudyPackages dummy;
    private PackageDefinition definition = new PackageDefinition();
    private static final long serialVersionUID = -6797410586312257505L;

    public PackagesTableModel(ClientFrame frame, JTable subject) {
        super(frame, null, subject);
        this.dummy = new StudyPackages(DBConnector.getDefinitions(), 0);
        this.data = this.dummy;
        AddRemoveToolBar t = frame.getStudyPanel().getPackagesToolBar();
        this.reconnectButton(t.getAddButton());
        t.getAddButton().setEnabled(false);
        this.reconnectButton(t.getRemoveButton());
        t.getRemoveButton().setEnabled(false);
        PackagesTableModel.reconnectButton(frame.getStudyPanel().getDefinePackagesButton(), this.definition);
        subject.setModel(this);
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "name";
            }
            case 1: {
                return "version";
            }
            case 2: {
                return "path";
            }
        }
        return null;
    }

    public void configure(Study study, boolean editable) {
        this.data = study.getPackages();
        int i = 0;
        while (i < ((StudyPackages)this.data).size()) {
            this.names.add(((StudyPackages.Package)((StudyPackages)this.data).get(i)).getName());
            ++i;
        }
        AddRemoveToolBar t = this.frame.getStudyPanel().getPackagesToolBar();
        if (editable) {
            t.getAddButton().setEnabled(true);
            t.getRemoveButton().setEnabled(true);
        } else {
            t.getAddButton().setEnabled(false);
            t.getRemoveButton().setEnabled(false);
        }
        this.fireTableStructureChanged();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        StudyPackages.Package d = (StudyPackages.Package)((StudyPackages)this.data).get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return d.getName();
            }
            case 1: {
                return d.getVersion();
            }
            case 2: {
                return d.getValue();
            }
        }
        return null;
    }

    public void clear() {
        this.data = this.dummy;
        this.names.clear();
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    protected void readData() {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2 && ((StudyPackages)this.data).isInserted(rowIndex);
    }

    @Override
    protected void connect(StudyPackages.Package newData) {
    }

    @Override
    protected StudyPackages.Package createData() {
        if (this.data == this.dummy) {
            return null;
        }
        try {
            PackageChooseDialog d = new PackageChooseDialog(Package.getAllVersions(DBConnector.getDefinitions()));
            String name = d.getName();
            StudyPackages.Package p = null;
            if (name != null) {
                StudyPackages studyPackages = (StudyPackages)this.data;
                studyPackages.getClass();
                p = studyPackages.new StudyPackages.Package(name, d.getVersion(), "");
            }
            return p;
        }
        catch (SQLException e) {
            PackagesTableModel.error(e);
            return null;
        }
    }

    @Override
    protected StudyPackages.Package cloneData(StudyPackages.Package orig) {
        StudyPackages studyPackages = (StudyPackages)this.data;
        studyPackages.getClass();
        return studyPackages.new StudyPackages.Package(orig.getName(), orig.getVersion(), orig.getValue());
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String name = ((StudyPackages.Package)((StudyPackages)this.data).get(rowIndex)).getName();
        String version = ((StudyPackages.Package)((StudyPackages)this.data).get(rowIndex)).getVersion();
        String path = (String)aValue;
        StudyPackages studyPackages = (StudyPackages)this.data;
        StudyPackages studyPackages2 = (StudyPackages)this.data;
        studyPackages2.getClass();
        studyPackages.set(rowIndex, studyPackages2.new StudyPackages.Package(name, version, path));
    }
}

