/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.tableModels;

import brn.distsim.client.DBConnector;
import brn.distsim.client.data.Group;
import brn.distsim.client.data.GroupNumericParameters;
import brn.distsim.client.data.GroupStringParameters;
import brn.distsim.client.data.Study;
import brn.distsim.client.tableModels.AddRemoveTableModel;
import brn.distsim.client.ui.ClientFrame;
import brn.distsim.client.ui.ParameterDialog;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersTableModel
extends AddRemoveTableModel<Study> {
    private int stringStart;
    private List<String> stringVals;
    private String[] displayedText = new String[3];
    private static final long serialVersionUID = -7070362041897241214L;

    public ParametersTableModel(ClientFrame frame, Study newData, JTable parametersTable) {
        super(frame, newData, parametersTable, new ArrayList<String>());
        this.stringVals = new LinkedList<String>();
    }

    @Override
    public int getColumnCount() {
        return ((Study)this.data).size() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Parameters";
        }
        return ((Group)((Study)this.data).get(columnIndex - 1)).getName();
    }

    @Override
    public int getRowCount() {
        return this.names.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String name = (String)this.names.get(rowIndex);
        if (columnIndex == 0) {
            return name;
        }
        if (columnIndex > ((Study)this.data).size()) {
            return null;
        }
        if (rowIndex < this.stringStart) {
            GroupNumericParameters.Parameter param = (GroupNumericParameters.Parameter)((Group)((Study)this.data).get(columnIndex - 1)).getNumericParameters().get(name);
            if (param != null) {
                this.displayedText[0] = param.getMin();
                this.displayedText[1] = param.getMax();
                this.displayedText[2] = param.getStep();
                return this.displayedText;
            }
        } else {
            this.stringVals.clear();
            GroupStringParameters.Parameter prop = (GroupStringParameters.Parameter)((Group)((Study)this.data).get(columnIndex - 1)).getStringParameters().get(name);
            while (prop != null) {
                this.stringVals.add(prop.getValue());
                prop = prop.getNext();
            }
            return this.stringVals;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0 && ((Study)this.data).isInserted(columnIndex - 1);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String name = (String)this.names.get(rowIndex);
        if (rowIndex < this.stringStart) {
            GroupNumericParameters pars;
            String[] content = (String[])aValue;
            GroupNumericParameters groupNumericParameters = pars = ((Group)((Study)this.data).get(columnIndex - 1)).getNumericParameters();
            groupNumericParameters.getClass();
            pars.put(groupNumericParameters.new GroupNumericParameters.Parameter(name, content[0], content[1], content[2]));
        } else {
            GroupStringParameters pars = ((Group)((Study)this.data).get(columnIndex - 1)).getStringParameters();
            Set values = (Set)aValue;
            GroupStringParameters.Parameter par = (GroupStringParameters.Parameter)pars.get(name);
            while (par != null) {
                String val = par.getValue();
                if (!values.remove(val)) {
                    pars.remove(par);
                }
                par = par.getNext();
            }
            for (String val : values) {
                pars.add(name, val);
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public int getSelected() {
        return this.subject.getSelectedRow();
    }

    @Override
    public void setSelected(int pos) {
        this.subject.setRowSelectionInterval(pos, pos);
    }

    @Override
    protected String create() {
        return null;
    }

    @Override
    protected boolean remove(int pos) {
        String name = (String)this.names.get(pos);
        boolean string = false;
        boolean success = true;
        if (pos >= this.stringStart) {
            string = true;
        } else {
            --this.stringStart;
        }
        int i = 0;
        while (i < ((Study)this.data).size()) {
            Group g = (Group)((Study)this.data).get(i);
            if (!((Study)this.data).isInserted(i)) {
                if (string && g.getStringParameters().get(name) != null || !string && g.getNumericParameters().get(name) != null) {
                    success = false;
                }
            } else if (string) {
                g.getStringParameters().remove(name);
            } else {
                g.getNumericParameters().remove(name);
            }
            ++i;
        }
        if (success) {
            this.names.remove(pos);
        }
        return success;
    }

    public int getStringStart() {
        return this.stringStart;
    }

    @Override
    protected boolean examineAction(ActionEvent e) throws SQLException {
        if (e.getActionCommand().equals("create")) {
            ParameterDialog d = new ParameterDialog();
            String name = d.getName();
            if (name == null) {
                return true;
            }
            if (d.getType() == 1) {
                this.names.add(this.stringStart, name);
                ++this.stringStart;
            } else {
                this.names.add(name);
            }
            this.fireTableStructureChanged();
            return true;
        }
        return super.examineAction(e);
    }

    @Override
    public void readData() {
        try {
            this.names.clear();
            this.names.addAll(GroupNumericParameters.getNames(DBConnector.getDefinitions(), ((Study)this.data).getId()));
            this.stringStart = this.names.size();
            this.names.addAll(GroupStringParameters.getNames(DBConnector.getDefinitions(), ((Study)this.data).getId()));
            this.fireTableStructureChanged();
        }
        catch (SQLException e) {
            ParametersTableModel.error(e);
        }
    }
}

