/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.tableModels;

import brn.distsim.client.data.Results;
import brn.distsim.client.tableModels.BaseTableModel;
import brn.distsim.client.ui.ClientFrame;
import brn.distsim.client.ui.ResultsPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ResultsModel
extends BaseTableModel
implements ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 4553022244080010403L;
    private ResultsPanel subject;
    private Results data;
    private List<String> childTables;
    private Map<Integer, Integer> columnKeys;

    public ResultsModel(ClientFrame frame, Results data) {
        super(frame, null);
        this.data = data;
        this.subject = frame.getResultsPanel();
        this.childTables = new LinkedList<String>();
        this.columnKeys = new HashMap<Integer, Integer>();
        this.reconnectButton(this.subject.getReloadButton());
        JComboBox box = this.subject.getTableChooser();
        ActionListener[] listeners = box.getActionListeners();
        int i = 0;
        while (i < listeners.length) {
            box.removeActionListener(listeners[i]);
            ++i;
        }
        box.addActionListener(this);
        this.fillTableChooser();
    }

    private void fillTableChooser() {
        try {
            JComboBox chooser = this.subject.getTableChooser();
            chooser.removeAllItems();
            for (String name : this.data.getTableNames()) {
                chooser.addItem(name);
            }
        }
        catch (SQLException e) {
            ResultsModel.error(e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String command = e.getActionCommand();
            if (command.equals("reload")) {
                this.fillTableChooser();
                this.subject.clearTables();
            } else if (command.equals("select")) {
                String name = (String)this.subject.getTableChooser().getSelectedItem();
                this.childTables.clear();
                if (name != null) {
                    this.childTables.addAll(this.data.getChildTableNames(name));
                    this.subject.clearTables();
                    Vector<Vector<String>> subClassData = this.data.getData(name);
                    int row = 0;
                    while (row < subClassData.size()) {
                        this.columnKeys.put(row, Integer.valueOf(subClassData.get(row).get(0)));
                        ++row;
                    }
                    this.subject.addParentTable(name, this.data.getColumnNames(name), subClassData).getSelectionModel().addListSelectionListener(this);
                    String subName = this.data.getSuperclass(name);
                    while (subName != null) {
                        this.childTables.addAll(this.data.getChildTableNames(subName));
                        this.subject.addParentTable(subName, this.data.getSubTableColumnNames(subName), this.data.getSuperClassData(subName, name)).getSelectionModel().addListSelectionListener(this);
                        subName = this.data.getSuperclass(subName);
                    }
                }
            }
        }
        catch (SQLException ex) {
            ResultsModel.error(ex);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                this.subject.clearChildTables();
                for (String tName : this.childTables) {
                    this.subject.addChildTable(tName, this.data.getSubTableColumnNames(tName), this.data.getChildData(tName, this.columnKeys.get(selectedRow)));
                }
            }
        }
        catch (SQLException ex) {
            ResultsModel.error(ex);
        }
    }

    public int getRowCount() {
        return 0;
    }

    public int getColumnCount() {
        return 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return null;
    }
}

