/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.tableModels;

import brn.distsim.client.DBConnector;
import brn.distsim.client.DefinitionsData;
import brn.distsim.client.data.Study;
import brn.distsim.client.data.StudyTree;
import brn.distsim.client.tableModels.EditableTableModel;
import brn.distsim.client.tableModels.MonitorTableModel;
import brn.distsim.client.tableModels.PackagesTableModel;
import brn.distsim.client.ui.ClientFrame;
import brn.distsim.client.ui.StudyPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudyTableModel
extends EditableTableModel<StudyTree, Study>
implements ListSelectionListener {
    private static final long serialVersionUID = 805655165709581688L;
    private PackagesTableModel packages;
    private String[] columnNames = new String[]{"id", "name", "version", "command"};

    public StudyTableModel(ClientFrame frame, StudyTree data, JTable subject) {
        super(frame, data, subject);
        StudyPanel panel = frame.getStudyPanel();
        this.packages = new PackagesTableModel(frame, panel.getPackagesTable());
        panel.getStudyTable().setModel(this);
        StudyTableModel.reconnectButton(panel.getCommitButton(), this);
        StudyTableModel.reconnectButton(panel.getCreateButton(), this);
        StudyTableModel.reconnectButton(panel.getRemoveButton(), this);
        StudyTableModel.reconnectButton(panel.getRollbackButton(), this);
        StudyTableModel.reconnectButton(panel.getSelectStudyButton(), this);
        JComboBox box = frame.getStudyPanel().getStudyNameComboBox();
        ActionListener[] listeners = box.getActionListeners();
        int i = 0;
        while (i < listeners.length) {
            box.removeActionListener(listeners[i]);
            ++i;
        }
        box.addActionListener(this);
        this.readData();
        subject.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public int getRowCount() {
        return ((StudyTree)this.data).size();
    }

    @Override
    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        Study study = (Study)((StudyTree)this.data).get(row);
        switch (col) {
            case 0: {
                return study.getId();
            }
            case 1: {
                return study.getName();
            }
            case 2: {
                return study.getVersion();
            }
            case 3: {
                return study.getCommand();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 3 && ((StudyTree)this.data).isInserted(row);
    }

    @Override
    protected boolean examineAction(ActionEvent e) throws SQLException {
        String command;
        if (!super.examineAction(e) && (command = e.getActionCommand()).equals("display")) {
            if (((StudyTree)this.data).isChanged() && StudyTableModel.warn("save changes?")) {
                ((StudyTree)this.data).commit();
            }
            String selected = (String)this.frame.getStudyPanel().getStudyNameComboBox().getSelectedItem();
            ((StudyTree)this.data).loadFromDB(selected);
            if (selected != null && !this.names.contains(selected) && !selected.equals("")) {
                super.insertData(this.createData());
                this.names.add(selected);
            }
            this.fireTableStructureChanged();
        }
        return true;
    }

    @Override
    protected void connect(Study newData) {
        new DefinitionsData(this.frame, newData);
        new MonitorTableModel(this.frame, newData);
    }

    @Override
    protected Study createData() {
        JComboBox box = this.frame.getStudyPanel().getStudyNameComboBox();
        String name = (String)box.getSelectedItem();
        String version = JOptionPane.showInputDialog("initial Version");
        if (name == null || version == null) {
            return null;
        }
        box.addItem(name);
        return new Study(DBConnector.getDefinitions(), name, version, "");
    }

    @Override
    protected Study cloneData(Study orig) {
        String version = JOptionPane.showInputDialog("new Version");
        if (version == null) {
            return null;
        }
        return orig.deepCopy(version);
    }

    @Override
    protected void readData() {
        try {
            this.names = StudyTree.getNames(DBConnector.getDefinitions());
            JComboBox box = this.frame.getStudyPanel().getStudyNameComboBox();
            Object selected = box.getSelectedItem();
            box.removeAllItems();
            box.addItem("");
            for (String item : this.names) {
                box.addItem(item);
            }
            box.setSelectedItem(selected);
            this.fireTableStructureChanged();
        }
        catch (SQLException e) {
            StudyTableModel.error(e);
        }
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Study old = (Study)((StudyTree)this.data).get(row);
        Study newStudy = new Study(old, old.getVersion(), (String)value);
        ((StudyTree)this.data).set(row, newStudy);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.packages.clear();
        } else {
            int selectedRow = lsm.getMinSelectionIndex();
            this.packages.configure((Study)((StudyTree)this.data).get(selectedRow), ((StudyTree)this.data).isInserted(selectedRow));
        }
    }

    @Override
    protected boolean remove(int pos) {
        block3: {
            try {
                if (pos >= 0) break block3;
                return false;
            }
            catch (SQLException e) {
                StudyTableModel.error(e);
                return false;
            }
        }
        ((Study)((StudyTree)this.data).get(pos)).loadFromDb();
        ((StudyTree)this.data).remove(pos);
        this.fireTableStructureChanged();
        return true;
    }
}

