/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.sql.Timestamp;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class MonitorPanel
extends JPanel {
    private static final long serialVersionUID = 4980790301779766146L;
    private JLabel studyLabel;
    private JButton refreshButton;
    private JButton selectButton;
    private JButton stopButton;
    private JButton cancelButton;
    private JButton restartButton;
    private JTable content;
    private JToolBar buttons;
    private JButton deleteButton;
    private JProgressBar bar;
    private Format timeFormat = new SimpleDateFormat();

    public MonitorPanel() {
        this.bar = new JProgressBar(0, 100);
        this.bar.setStringPainted(true);
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        this.refreshButton = this.createButton("toolbarButtonGraphics/general/Undo24.gif", "rollback", "reload");
        this.selectButton = this.createButton("toolbarButtonGraphics/general/Export24.gif", "select", "show results for selected simulation");
        this.cancelButton = this.createButton("toolbarButtonGraphics/general/Delete24.gif", "cancel", "cancel selected simulation");
        this.stopButton = this.createButton("toolbarButtonGraphics/general/Delete24.gif", "stop", "stop the wrapper executing the selected simulation");
        this.restartButton = this.createButton("toolbarButtonGraphics/general/Undo24.gif", "restart", "restart selected simulation");
        this.deleteButton = this.createButton("toolbarButtonGraphics/general/Delete24.gif", "remove", "delete selected simulation");
        this.buttons = new JToolBar();
        this.studyLabel = new JLabel();
        this.buttons.add(this.studyLabel);
        this.buttons.add(this.refreshButton);
        this.buttons.add(this.selectButton);
        this.buttons.add(this.stopButton);
        this.buttons.add(this.restartButton);
        this.buttons.add(this.deleteButton);
        this.add((Component)this.buttons, c);
        c.weightx = 2.0;
        c.weighty = 2.0;
        this.content = new JTable();
        this.add((Component)new JScrollPane(this.content), c);
        this.content.setDefaultRenderer(Float.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                int val = (int)((double)((Float)value).floatValue() * 100.0);
                MonitorPanel.this.bar.setValue(val);
                MonitorPanel.this.bar.setString(String.valueOf(val) + "%");
                return MonitorPanel.this.bar;
            }
        });
        this.content.setDefaultRenderer(Timestamp.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 3969798253778193097L;

            public void setValue(Object value) {
                if (value == null) {
                    this.setText("");
                } else {
                    this.setText(MonitorPanel.this.timeFormat.format(((Timestamp)value).getTime()));
                }
            }
        });
    }

    private JButton createButton(String icon, String command, String text) {
        JButton ret = new JButton(new ImageIcon(ClassLoader.getSystemResource(icon)));
        ret.setActionCommand(command);
        ret.setToolTipText(text);
        return ret;
    }

    public JTable getContent() {
        return this.content;
    }

    public void setStudy(String name, String version) {
        this.studyLabel.setText(String.valueOf(name) + " " + version);
    }

    public JButton getStopButton() {
        return this.stopButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getRefreshButton() {
        return this.refreshButton;
    }

    public JButton getRestartButton() {
        return this.restartButton;
    }

    public JButton getSelectButton() {
        return this.selectButton;
    }

    public JButton getDeleteButton() {
        return this.deleteButton;
    }
}

