/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageChooseDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6696615208799106880L;
    private boolean valid;
    private JComboBox name = new JComboBox();
    private JComboBox version = new JComboBox();
    private JButton okButton = new JButton("ok");
    private JButton cancelButton = new JButton("cancel");
    private Map<String, List<String>> versions;

    public PackageChooseDialog(Map<String, List<String>> versions) {
        super((Frame)null, "add package", true);
        this.versions = versions;
        this.name.addActionListener(this);
        JPanel content = new JPanel();
        this.setContentPane(content);
        for (String n : versions.keySet()) {
            this.name.addItem(n);
        }
        content.setLayout(new BorderLayout());
        content.add((Component)new JLabel("choose package name and version"), "North");
        JPanel input = new JPanel();
        input.add(this.name);
        input.add(this.version);
        content.add((Component)input, "Center");
        JPanel buttons = new JPanel();
        buttons.add(this.cancelButton);
        buttons.add(this.okButton);
        content.add((Component)buttons, "South");
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.setLocationRelativeTo(null);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.valid = false;
            this.setVisible(false);
        } else if (e.getSource() == this.okButton) {
            this.valid = true;
            this.setVisible(false);
        } else if (e.getSource() == this.name) {
            this.version.removeAllItems();
            List<String> currentVersions = this.versions.get(this.name.getSelectedItem());
            if (currentVersions == null) {
                return;
            }
            for (String v : currentVersions) {
                this.version.addItem(v);
            }
        }
    }

    @Override
    public String getName() {
        if (this.valid) {
            return (String)this.name.getSelectedItem();
        }
        return null;
    }

    public String getVersion() {
        if (this.valid) {
            return (String)this.version.getSelectedItem();
        }
        return null;
    }
}

