/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.ui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageDefinitionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 6696615208799106880L;
    private JComboBox names = new JComboBox();
    private JComboBox versions = new JComboBox();
    private JComboBox architectures = new JComboBox();
    private JTextField url = new JTextField();
    private JTextField localPath = new JTextField(16);
    private JButton chooseButton = new JButton("select");
    private JButton doneButton = new JButton("done");
    private JCheckBox upload = new JCheckBox();
    private JButton defineButton = new JButton("define");
    private JFileChooser fileChooser = new JFileChooser();

    public PackageDefinitionDialog(List<String> initNames) {
        super((Frame)null, "define packages", true);
        this.names.setEditable(true);
        this.versions.setEditable(true);
        this.architectures.setEditable(true);
        JPanel content = new JPanel();
        this.setContentPane(content);
        this.names.addItem("");
        for (String n : initNames) {
            this.names.addItem(n);
        }
        content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.weightx = 4.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        content.add(new JLabel("name: "));
        content.add((Component)this.names, c);
        content.add(new JLabel("version: "));
        content.add((Component)this.versions, c);
        content.add(new JLabel("architecture: "));
        content.add((Component)this.architectures, c);
        content.add(new JLabel("URL: "));
        content.add((Component)this.url, c);
        content.add(new JLabel("upload file? "));
        content.add(this.upload);
        content.add(this.chooseButton);
        c.weightx = 1.0;
        content.add((Component)this.localPath, c);
        this.localPath.setEnabled(false);
        this.chooseButton.setEnabled(false);
        JPanel buttons = new JPanel();
        buttons.add(this.defineButton);
        buttons.add(this.doneButton);
        content.add((Component)buttons, c);
        this.upload.addActionListener(this);
        this.doneButton.addActionListener(this);
        this.chooseButton.addActionListener(this);
        this.setLocationRelativeTo(null);
    }

    public JButton getDefineButton() {
        return this.defineButton;
    }

    public JComboBox getVersions() {
        return this.versions;
    }

    public JComboBox getArchitectures() {
        return this.architectures;
    }

    public JComboBox getNames() {
        return this.names;
    }

    public String getUrl() {
        return this.url.getText();
    }

    public String getLocalPath() {
        if (this.upload.isSelected()) {
            return this.localPath.getText();
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.upload) {
            if (this.upload.isSelected()) {
                this.localPath.setEnabled(true);
                this.chooseButton.setEnabled(true);
            } else {
                this.localPath.setEnabled(false);
                this.chooseButton.setEnabled(false);
            }
        } else if (e.getSource() == this.doneButton) {
            this.setVisible(false);
        } else if (e.getSource() == this.chooseButton) {
            this.fileChooser.setSelectedFile(new File(this.localPath.getText()));
            int returnVal = this.fileChooser.showOpenDialog(null);
            if (returnVal == 0) {
                this.localPath.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

