/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.ui;

import brn.distsim.client.tableModels.ParametersTableModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class ParameterCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private boolean editingString;
    private boolean valid;
    private JTable table;
    private String[] result = new String[3];
    private JDialog dialog = new JDialog();
    private static final long serialVersionUID = 4780463575723720854L;
    private JLabel minLabel = new JLabel("min: ");
    private JLabel maxLabel = new JLabel("max: ");
    private JLabel stepLabel = new JLabel("step: ");
    private JTextField minVal = new JTextField(32);
    private JTextField maxVal = new JTextField(32);
    private JTextField stepVal = new JTextField(32);
    private JComboBox stringChooser = new JComboBox();
    private int selected;
    private JPanel content = new JPanel();
    private JPanel buttons = new JPanel();
    private JButton okButton = new JButton("ok");
    private JButton cancelButton = new JButton("cancel");

    public ParameterCellEditor() {
        this.dialog.setContentPane(this.content);
        this.dialog.setLocationRelativeTo(null);
        this.stringChooser.setEditable(true);
        this.stringChooser.addActionListener(this);
        this.content.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        this.content.add(this.minLabel);
        this.content.add((Component)this.minVal, c);
        this.content.add(this.maxLabel);
        this.content.add((Component)this.maxVal, c);
        this.content.add(this.stepLabel);
        this.content.add((Component)this.stepVal, c);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.buttons.add(this.cancelButton);
        this.buttons.add(this.okButton);
        this.content.add((Component)this.buttons, c);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        int stringStart = ((ParametersTableModel)table.getModel()).getStringStart();
        if (row < stringStart) {
            if (value != null) {
                this.result = (String[])value;
            }
            this.minVal.setText(this.result[0]);
            this.maxVal.setText(this.result[1]);
            if (this.result[2] == null || this.result[2].equals("")) {
                this.stepVal.setText("1");
            } else {
                this.stepVal.setText(this.result[2]);
            }
            this.editingString = false;
            this.valid = false;
            this.dialog.getRootPane().setDefaultButton(this.okButton);
            this.dialog.pack();
            this.dialog.setVisible(true);
            this.minVal.requestFocus();
            return new JLabel("editing");
        }
        this.stringChooser.removeAllItems();
        for (Object val : (Collection)value) {
            this.stringChooser.addItem(val);
        }
        this.stringChooser.addItem("");
        this.editingString = true;
        return this.stringChooser;
    }

    public Object getCellEditorValue() {
        if (this.editingString) {
            int size = this.stringChooser.getItemCount();
            HashSet<String> val = new HashSet<String>();
            int i = 0;
            while (i < size) {
                String item = (String)this.stringChooser.getItemAt(i);
                if (i == this.selected) {
                    val.add((String)this.stringChooser.getSelectedItem());
                } else if (item != null && !item.equals("")) {
                    val.add(item);
                }
                ++i;
            }
            return val;
        }
        if (this.valid) {
            this.result[0] = this.minVal.getText();
            this.result[1] = this.maxVal.getText();
            this.result[2] = this.stepVal.getText();
        }
        return this.result;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.valid = true;
            this.dialog.setVisible(false);
        } else if (source == this.cancelButton) {
            this.valid = false;
            this.dialog.setVisible(false);
        } else if (this.stringChooser.getSelectedIndex() != -1) {
            this.selected = this.stringChooser.getSelectedIndex();
            return;
        }
        this.fireEditingStopped();
        this.table.requestFocus();
    }
}

