/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.ui;

import brn.distsim.client.ui.RowSelectionSynchronizer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

public class ResultsPanel
extends JPanel {
    private static final long serialVersionUID = -4736197828745540013L;
    private JToolBar toolBar;
    private JComboBox tableChooser;
    private GridBagConstraints tableConstraints;
    private GridBagConstraints labelConstraints;
    private JButton focus;
    private JButton reload;
    private JPanel parents;
    private JPanel children;
    private LinkedList<JTable> parentTables;
    private LinkedList<JTable> childTables;
    private RowSelectionSynchronizer parentSynchronizer;

    public ResultsPanel() {
        GridBagLayout layout = new GridBagLayout();
        this.parents = new JPanel();
        this.parents.setLayout(new GridBagLayout());
        this.tableConstraints = new GridBagConstraints();
        this.tableConstraints.weightx = 1.0;
        this.tableConstraints.weighty = 1.0;
        this.tableConstraints.fill = 1;
        this.labelConstraints = new GridBagConstraints();
        this.labelConstraints.weighty = 1.0;
        this.labelConstraints.fill = 1;
        this.children = new JPanel();
        this.setLayout(layout);
        GridBagConstraints endRow = new GridBagConstraints();
        endRow.gridwidth = 0;
        endRow.fill = 1;
        this.tableChooser = new JComboBox();
        this.tableChooser.setActionCommand("select");
        this.reload = new JButton("reload");
        this.toolBar = new JToolBar();
        this.toolBar.add(this.tableChooser);
        this.toolBar.add(this.reload);
        this.add((Component)this.toolBar, endRow);
        endRow.weightx = 2.0;
        endRow.weighty = 2.0;
        this.add((Component)new JScrollPane(this.parents), endRow);
        this.add((Component)new JScrollPane(this.children), endRow);
        this.parentTables = new LinkedList();
        this.childTables = new LinkedList();
        this.parentSynchronizer = new RowSelectionSynchronizer();
        this.revalidate();
    }

    public void clearTables() {
        this.clearChildTables();
        this.parentSynchronizer.clear();
        this.parents.removeAll();
        this.parentTables.clear();
    }

    public void clearChildTables() {
        this.children.removeAll();
        this.childTables.clear();
    }

    public JTable addParentTable(String label, Vector captions, Vector data) {
        this.parents.add((Component)new JLabel(this.verticalFormat(label)), this.labelConstraints);
        JTable table = new JTable(data, captions);
        table.setSelectionMode(0);
        if (!captions.isEmpty()) {
            this.parents.add((Component)new JScrollPane(table), this.tableConstraints);
        } else {
            this.parents.add(new JLabel("   "));
        }
        this.parentTables.add(table);
        this.parentSynchronizer.addTable(table);
        this.revalidate();
        return table;
    }

    private String verticalFormat(String label) {
        String[] chars = label.split("");
        String formattedLabel = "<html>";
        String[] stringArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            formattedLabel = String.valueOf(formattedLabel) + c + "<br>";
            ++n2;
        }
        return String.valueOf(formattedLabel) + "</html>";
    }

    public JTable addChildTable(String label, Vector captions, Vector data) {
        this.children.add((Component)new JLabel(this.verticalFormat(label)), this.labelConstraints);
        JTable table = new JTable(data, captions);
        if (!captions.isEmpty()) {
            this.children.add((Component)new JScrollPane(table), this.tableConstraints);
        } else {
            this.children.add(new JScrollPane(table));
        }
        this.childTables.add(table);
        this.revalidate();
        return table;
    }

    public JComboBox getTableChooser() {
        return this.tableChooser;
    }

    public JButton getFocusButton() {
        return this.focus;
    }

    public JButton getReloadButton() {
        return this.reload;
    }
}

