/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.ui;

import brn.distsim.client.ui.AddRemoveToolBar;
import brn.distsim.client.ui.CheckBoxCellRenderer;
import brn.distsim.client.ui.DefinitionsCellRenderer;
import brn.distsim.client.ui.FileCellEditor;
import brn.distsim.client.ui.ParameterCellEditor;
import brn.distsim.client.ui.SelectionSynchronizer;
import brn.distsim.client.ui.TextCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationPanel
extends JPanel {
    private static final long serialVersionUID = 7137892365997004599L;
    private List<JButton> groupButtons = new LinkedList<JButton>();
    private JToolBar simulationToolBar = null;
    private AddRemoveToolBar parametersToolBar = null;
    private AddRemoveToolBar inFilesToolBar = null;
    private AddRemoveToolBar outFilesToolBar = null;
    private JTable parametersTable = null;
    private JTable filesInTable = null;
    private JTable filesOutTable = null;

    public SimulationPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagLayout gridLayout = new GridBagLayout();
        this.setLayout(gridLayout);
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.fill = 1;
        this.add(this.getParametersToolBar());
        this.add(this.getInFilesToolBar());
        this.add(this.getOutFilesToolBar());
        this.add((Component)this.getSimulationToolBar(), c);
        c.weightx = 2.0;
        c.weighty = 2.0;
        this.add((Component)new JScrollPane(this.getParametersTable()), c);
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.getFilesInTable()), c);
        c.gridheight = 0;
        this.add((Component)new JScrollPane(this.getFilesOutTable()), c);
        SelectionSynchronizer synch = new SelectionSynchronizer();
        synch.addTable(this.getParametersTable());
        synch.addTable(this.getFilesInTable());
        synch.addTable(this.getFilesOutTable());
        this.revalidate();
    }

    public List<JButton> getGroupButtons() {
        return this.groupButtons;
    }

    private JButton createButton(String text, String command, String iconPath) {
        JButton button = new JButton(new ImageIcon(ClassLoader.getSystemResource(iconPath)));
        button.setToolTipText(text);
        button.setActionCommand(command);
        this.groupButtons.add(button);
        return button;
    }

    public JToolBar getSimulationToolBar() {
        if (this.simulationToolBar == null) {
            this.simulationToolBar = new JToolBar();
            this.simulationToolBar.add(new JLabel("Groups"));
            this.simulationToolBar.add(this.createButton("commit", "commit", "toolbarButtonGraphics/general/Save24.gif"));
            this.simulationToolBar.add(this.createButton("rollback", "rollback", "toolbarButtonGraphics/general/Undo24.gif"));
            this.simulationToolBar.add(this.createButton("create group", "create", "toolbarButtonGraphics/general/Add24.gif"));
            this.simulationToolBar.add(this.createButton("clone group", "clone", "toolbarButtonGraphics/general/Copy24.gif"));
            this.simulationToolBar.add(this.createButton("delete group", "remove", "toolbarButtonGraphics/general/Delete24.gif"));
            this.simulationToolBar.add(this.createButton("create and start simulations for ALL groups", "select", "toolbarButtonGraphics/general/Export24.gif"));
            this.simulationToolBar.add(this.createButton("create and start simulations for SELECTED group", "selectSingle", "toolbarButtonGraphics/general/Export24.gif"));
        }
        return this.simulationToolBar;
    }

    public AddRemoveToolBar getParametersToolBar() {
        if (this.parametersToolBar == null) {
            this.parametersToolBar = new AddRemoveToolBar("Parameters", "parameter");
        }
        return this.parametersToolBar;
    }

    public AddRemoveToolBar getInFilesToolBar() {
        if (this.inFilesToolBar == null) {
            this.inFilesToolBar = new AddRemoveToolBar("Configuration Files", "configuration file");
        }
        return this.inFilesToolBar;
    }

    public AddRemoveToolBar getOutFilesToolBar() {
        if (this.outFilesToolBar == null) {
            this.outFilesToolBar = new AddRemoveToolBar("Results Files", "results file");
        }
        return this.outFilesToolBar;
    }

    public JTable getParametersTable() {
        if (this.parametersTable == null) {
            this.parametersTable = new JTable();
            this.parametersTable.setColumnSelectionAllowed(true);
            this.parametersTable.setRowSelectionAllowed(false);
            this.parametersTable.setSelectionMode(0);
            this.parametersTable.setDefaultEditor(Object.class, new ParameterCellEditor());
            this.parametersTable.setDefaultRenderer(Object.class, new DefinitionsCellRenderer());
            this.parametersTable.setSurrendersFocusOnKeystroke(true);
            this.parametersTable.getTableHeader().setReorderingAllowed(false);
        }
        return this.parametersTable;
    }

    public JTable getFilesInTable() {
        if (this.filesInTable == null) {
            this.filesInTable = new JTable();
            this.filesInTable.setColumnSelectionAllowed(true);
            this.filesInTable.setRowSelectionAllowed(false);
            this.filesInTable.setDefaultEditor(Object.class, new FileCellEditor());
            this.filesInTable.setDefaultRenderer(Object.class, new TextCellRenderer());
            this.filesInTable.setSelectionMode(0);
            this.filesInTable.getTableHeader().setReorderingAllowed(false);
        }
        return this.filesInTable;
    }

    public JTable getFilesOutTable() {
        if (this.filesOutTable == null) {
            this.filesOutTable = new JTable();
            this.filesOutTable.setColumnSelectionAllowed(true);
            this.filesOutTable.setRowSelectionAllowed(false);
            this.filesOutTable.setSelectionMode(0);
            this.filesOutTable.setDefaultRenderer(Boolean.class, new CheckBoxCellRenderer());
            this.filesOutTable.setDefaultRenderer(String.class, new TextCellRenderer());
            this.filesOutTable.getTableHeader().setReorderingAllowed(false);
        }
        return this.filesOutTable;
    }
}

