/*
 * Decompiled with CFR 0.152.
 */
package brn.distsim.client.ui;

import brn.distsim.client.ui.AddRemoveToolBar;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;

public class StudyPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JToolBar studyToolBar = null;
    private JButton commitButton = null;
    private JButton rollbackButton = null;
    private JButton createButton = null;
    private JButton removeButton = null;
    private JButton selectStudyButton = null;
    private JButton definePackagesButton = null;
    private AddRemoveToolBar packagesToolBar = null;
    private JTable packagesTable = null;
    private JComboBox studyNameComboBox = null;
    private JTable studyTable = null;

    public StudyPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints tableConstraints = new GridBagConstraints();
        tableConstraints.fill = 1;
        tableConstraints.weightx = 1.0;
        tableConstraints.weighty = 1.0;
        tableConstraints.gridwidth = 0;
        GridBagConstraints toolBarConstraints = new GridBagConstraints();
        toolBarConstraints.fill = 1;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getStudyToolBar(), toolBarConstraints);
        toolBarConstraints.gridwidth = 0;
        this.add((Component)this.getPackagesToolBar(), toolBarConstraints);
        this.add((Component)new JScrollPane(this.getStudyTable()), tableConstraints);
        tableConstraints.gridheight = 0;
        this.add((Component)new JScrollPane(this.getPackagesTable()), tableConstraints);
        this.revalidate();
    }

    public JToolBar getStudyToolBar() {
        if (this.studyToolBar == null) {
            this.studyToolBar = new JToolBar();
            this.studyToolBar.add(this.getCommitButton());
            this.studyToolBar.add(this.getRollbackButton());
            this.studyToolBar.add(this.getCreateButton());
            this.studyToolBar.add(this.getRemoveButton());
            this.studyToolBar.add(this.getStudyNameComboBox());
            this.studyToolBar.add(this.getSelectStudyButton());
        }
        return this.studyToolBar;
    }

    public JComboBox getStudyNameComboBox() {
        if (this.studyNameComboBox == null) {
            this.studyNameComboBox = new JComboBox();
            this.studyNameComboBox.setActionCommand("display");
            this.studyNameComboBox.setEditable(true);
        }
        return this.studyNameComboBox;
    }

    public JButton getDefinePackagesButton() {
        if (this.definePackagesButton == null) {
            this.definePackagesButton = this.createButton("define packages", "define", "toolbarButtonGraphics/general/Add24.gif");
        }
        return this.definePackagesButton;
    }

    public JButton getCommitButton() {
        if (this.commitButton == null) {
            this.commitButton = this.createButton("save studies", "commit", "toolbarButtonGraphics/general/Save24.gif");
        }
        return this.commitButton;
    }

    private JButton createButton(String text, String command, String iconPath) {
        JButton button = new JButton(new ImageIcon(ClassLoader.getSystemResource(iconPath)));
        button.setToolTipText(text);
        button.setActionCommand(command);
        return button;
    }

    public JButton getSelectStudyButton() {
        if (this.selectStudyButton == null) {
            this.selectStudyButton = this.createButton("load simulation groups for the selected study", "select", "toolbarButtonGraphics/general/Export24.gif");
        }
        return this.selectStudyButton;
    }

    public JButton getRemoveButton() {
        if (this.removeButton == null) {
            this.removeButton = this.createButton("remove study", "remove", "toolbarButtonGraphics/general/Delete24.gif");
        }
        return this.removeButton;
    }

    public JButton getRollbackButton() {
        if (this.rollbackButton == null) {
            this.rollbackButton = this.createButton("undo changes", "rollback", "toolbarButtonGraphics/general/Undo24.gif");
        }
        return this.rollbackButton;
    }

    public JButton getCreateButton() {
        if (this.createButton == null) {
            this.createButton = this.createButton("branch study", "clone", "toolbarButtonGraphics/general/Copy24.gif");
        }
        return this.createButton;
    }

    public JTable getStudyTable() {
        if (this.studyTable == null) {
            this.studyTable = new JTable();
            this.studyTable.setSelectionMode(0);
        }
        return this.studyTable;
    }

    public AddRemoveToolBar getPackagesToolBar() {
        if (this.packagesToolBar == null) {
            this.packagesToolBar = new AddRemoveToolBar("Packages", "package");
            this.packagesToolBar.add(this.getDefinePackagesButton());
        }
        return this.packagesToolBar;
    }

    public JTable getPackagesTable() {
        if (this.packagesTable == null) {
            this.packagesTable = new JTable();
            this.packagesTable.setSelectionMode(0);
        }
        return this.packagesTable;
    }
}

