/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.collections;

import de.jaret.util.collections.ListWatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class WatchableArrayList
implements List {
    private List<ListWatcher> _listeners;
    private List _content = new ArrayList();

    public void addListWatcher(ListWatcher watcher) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<ListWatcher>();
        }
        this._listeners.add(watcher);
    }

    public void removeListWatcher(ListWatcher watcher) {
        if (this._listeners != null) {
            this._listeners.remove(watcher);
        }
    }

    private void fireElementAdded(Object o) {
        if (this._listeners != null) {
            for (ListWatcher watcher : this._listeners) {
                watcher.elementAdded(o);
            }
        }
    }

    private void fireElementRemoved(Object o) {
        if (this._listeners != null) {
            for (ListWatcher watcher : this._listeners) {
                watcher.elementRemoved(o);
            }
        }
    }

    public int size() {
        return this._content.size();
    }

    public boolean isEmpty() {
        return this._content.isEmpty();
    }

    public boolean contains(Object o) {
        return this._content.contains(o);
    }

    public Iterator iterator() {
        return this._content.iterator();
    }

    public Object[] toArray() {
        return this._content.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this._content.toArray(a);
    }

    public boolean add(Object o) {
        boolean result = this._content.add(o);
        this.fireElementAdded(o);
        return result;
    }

    public boolean remove(Object o) {
        boolean wasInList = this._content.contains(o);
        boolean result = this._content.remove(o);
        if (wasInList) {
            this.fireElementRemoved(o);
        }
        return result;
    }

    public boolean containsAll(Collection c) {
        return this._content.containsAll(c);
    }

    public boolean addAll(Collection c) {
        return this._content.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        return this._content.addAll(index, c);
    }

    public boolean removeAll(Collection c) {
        return this._content.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this._content.retainAll(c);
    }

    public void clear() {
        this._content.clear();
    }

    public Object get(int index) {
        return this._content.get(index);
    }

    public Object set(int index, Object element) {
        return this._content.set(index, element);
    }

    public void add(int index, Object element) {
        this._content.add(index, element);
        this.fireElementAdded(element);
    }

    public Object remove(int index) {
        Object o = this._content.remove(index);
        this.fireElementRemoved(o);
        return o;
    }

    public int indexOf(Object o) {
        return this._content.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this._content.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this._content.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this._content.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this._content.subList(fromIndex, toIndex);
    }
}

