/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date;

import de.jaret.util.date.Interval;
import de.jaret.util.date.JaretDate;
import de.jaret.util.misc.PropertyObservableBase;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class IntervalImpl
extends PropertyObservableBase
implements Interval,
PropertyChangeListener {
    protected JaretDate _begin;
    protected JaretDate _end;

    public IntervalImpl(JaretDate from, JaretDate to) {
        this._begin = from.copy();
        this._begin.addPropertyChangeListener(this);
        this._end = to.copy();
        this._end.addPropertyChangeListener(this);
    }

    public IntervalImpl() {
    }

    public JaretDate getBegin() {
        return this._begin;
    }

    public JaretDate getEnd() {
        return this._end;
    }

    public void setBegin(JaretDate begin) {
        if (this._begin != null) {
            this._begin.removePropertyChangeListener(this);
        }
        JaretDate oldVal = this._begin;
        this._begin = begin;
        this._begin.addPropertyChangeListener(this);
        this.firePropertyChange("Begin", oldVal, begin);
    }

    public void setEnd(JaretDate end) {
        if (this._end != null) {
            this._end.removePropertyChangeListener(this);
        }
        JaretDate oldVal = this._end;
        this._end = end;
        this._end.addPropertyChangeListener(this);
        this.firePropertyChange("End", oldVal, end);
    }

    public boolean contains(JaretDate date) {
        return this.getBegin().compareTo(date) <= 0 && this.getEnd().compareTo(date) >= 0;
    }

    public static boolean containsStatic(Interval interval, JaretDate date) {
        return interval.getBegin().compareTo(date) <= 0 && interval.getEnd().compareTo(date) >= 0;
    }

    public int getSeconds() {
        return this.getEnd().diffSeconds(this.getBegin());
    }

    public String toString() {
        return this.getBegin().toDisplayString() + "--" + this.getEnd().toDisplayString();
    }

    public boolean intersects(Interval interval) {
        return IntervalImpl.intersect(this, interval);
    }

    public static boolean intersect(Interval i1, Interval i2) {
        if (i1.contains(i2.getBegin()) || i1.contains(i2.getEnd())) {
            return true;
        }
        return i2.contains(i1.getBegin()) || i2.contains(i1.getEnd());
    }

    public static boolean intersectNonIncluding(Interval i1, Interval i2) {
        if (IntervalImpl.containsNonIncluding(i1, i2.getBegin()) || IntervalImpl.containsNonIncluding(i1, i2.getEnd())) {
            return true;
        }
        if (IntervalImpl.containsNonIncluding(i2, i1.getBegin()) || IntervalImpl.containsNonIncluding(i2, i1.getEnd())) {
            return true;
        }
        return i1.getBegin().equals(i2.getBegin()) && i1.getEnd().equals(i2.getEnd());
    }

    public static boolean containsNonIncluding(Interval interval, JaretDate date) {
        return interval.getBegin().compareTo(date) < 0 && interval.getEnd().compareTo(date) > 0;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this._begin) {
            this.firePropertyChange("Begin", evt.getOldValue(), evt.getNewValue());
        } else if (evt.getSource() == this._end) {
            this.firePropertyChange("End", evt.getOldValue(), evt.getNewValue());
        }
    }
}

