/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date;

import de.jaret.util.date.JaretDateFormatter;
import de.jaret.util.misc.PropertyObservableBase;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaretDate
extends PropertyObservableBase
implements Comparable<JaretDate> {
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_SECOND = 1000L;
    private static JaretDateFormatter _jaretDateFormatter = new JaretDateFormatter();
    private Date _date;
    private Calendar _calendar;

    public JaretDate() {
        this._date = new Date();
    }

    public JaretDate(Date date) {
        this._date = (Date)date.clone();
    }

    public JaretDate(String millisecondsString) {
        long ms = Long.parseLong(millisecondsString);
        this._date = new Date(ms);
    }

    public JaretDate(long milliseconds) {
        long ms = milliseconds;
        this._date = new Date(ms);
    }

    public JaretDate(JaretDate jdate) {
        this._date = new Date(jdate.getDate().getTime());
    }

    public JaretDate(int day, int month, int year, int hours, int minutes, int seconds) {
        this();
        this.setDateTime(day, month, year, hours, minutes, seconds);
    }

    public JaretDateFormatter getJaretDateFormatter() {
        return _jaretDateFormatter;
    }

    public static void setJaretDateFormatter(JaretDateFormatter jaretDateFormatter) {
        _jaretDateFormatter = jaretDateFormatter;
    }

    public void setLocale(Locale locale) {
        _jaretDateFormatter.setLocale(locale);
        this.firePropertyChange();
    }

    public void setDateTime(int day, int month, int year, int hours, int minutes, int seconds, int milliseconds) {
        Calendar cal = this.getCalendar();
        cal.set(5, day);
        cal.set(2, month - 1);
        cal.set(1, year);
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, milliseconds);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
    }

    public void setDateTime(int day, int month, int year, int hours, int minutes, int seconds) {
        this.setDateTime(day, month, year, hours, minutes, seconds, 0);
    }

    public JaretDate setTime(int hours, int minutes, int seconds, int milliseconds) {
        Calendar cal = this.getCalendar();
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, milliseconds);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
        return this;
    }

    public JaretDate setTime(int hours, int minutes, int seconds) {
        this.setTime(hours, minutes, seconds, 0);
        return this;
    }

    public JaretDate setDate(int day, int month, int year) {
        Calendar cal = this.getCalendar();
        cal.set(5, day);
        cal.set(2, month - 1);
        cal.set(1, year);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
        return this;
    }

    public JaretDate setDate(JaretDate date) {
        this.setDate(date.getDay(), date.getMonth(), date.getYear());
        return this;
    }

    public void setMonth(int month) {
        Calendar cal = this.getCalendar();
        cal.set(2, month - 1);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
    }

    public void setDay(int day) {
        Calendar cal = this.getCalendar();
        cal.set(5, day);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
    }

    public void setHours(int hours) {
        if (hours > 23) {
            throw new IllegalArgumentException("hour must not exceedd 23");
        }
        Calendar cal = this.getCalendar();
        cal.set(11, hours);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
    }

    public void setMinutes(int minutes) {
        if (minutes > 59) {
            throw new IllegalArgumentException("minutes must not exceed 59");
        }
        Calendar cal = this.getCalendar();
        cal.set(12, minutes);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
    }

    public void setSeconds(int seconds) {
        if (seconds > 59) {
            throw new IllegalArgumentException("seconds must not exceed 59");
        }
        Calendar cal = this.getCalendar();
        cal.set(13, seconds);
        cal.set(14, 0);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
    }

    public void setMilliseconds(int milliseconds) {
        if (milliseconds > 999) {
            throw new IllegalArgumentException("milliseconds must not exceed 999");
        }
        Calendar cal = this.getCalendar();
        cal.set(14, milliseconds);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
    }

    public boolean setDateByText(String text) {
        Date date = _jaretDateFormatter.parseTextualDate(text);
        if (date == null) {
            return false;
        }
        this._date = date;
        this.firePropertyChange();
        return true;
    }

    protected Calendar getCalendar() {
        if (this._calendar == null) {
            this._calendar = Calendar.getInstance(_jaretDateFormatter.getLocale());
        }
        this._calendar.setTime(this._date);
        return this._calendar;
    }

    public long getMillisInDay() {
        Calendar cal = this.getCalendar();
        long h = cal.get(11);
        long m = cal.get(12);
        long s = cal.get(13);
        return h * 3600000L + m * 60000L + s * 1000L;
    }

    public Date getDate() {
        return this._date;
    }

    public String toDisplayString() {
        return _jaretDateFormatter.generateDisplayString(this);
    }

    public String toDisplayStringDate() {
        return _jaretDateFormatter.generateDisplayStringDate(this);
    }

    public String toDisplayStringTime(boolean seconds) {
        return _jaretDateFormatter.toDisplayStringTime(this, seconds);
    }

    public String toDisplayStringTime() {
        return this.toDisplayStringTime(false);
    }

    public String toString() {
        return Long.toString(this._date.getTime());
    }

    public void setToNow() {
        this._date.setTime(System.currentTimeMillis());
        this.firePropertyChange();
    }

    public double diffMinutes(JaretDate date) {
        return (double)this.diffMilliSeconds(date) / 60000.0;
    }

    public int diffSeconds(JaretDate date) {
        return (int)((this._date.getTime() - date.getDate().getTime()) / 1000L);
    }

    public long diffSecondsL(JaretDate date) {
        return (this._date.getTime() - date.getDate().getTime()) / 1000L;
    }

    public long diffMilliSeconds(JaretDate date) {
        return this._date.getTime() - date.getDate().getTime();
    }

    public JaretDate advanceMonths(int months) {
        Calendar cal = this.getCalendar();
        cal.add(2, months);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
        return this;
    }

    public JaretDate advanceYears(int years) {
        Calendar cal = this.getCalendar();
        cal.add(1, years);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
        return this;
    }

    public JaretDate advanceDays(int days) {
        Calendar cal = this.getCalendar();
        cal.add(6, days);
        this._date.setTime(cal.getTimeInMillis());
        this.firePropertyChange();
        return this;
    }

    public JaretDate advanceDays(double days) {
        this._date.setTime(this._date.getTime() + (long)(days * 24.0 * 60.0 * 60.0 * 1000.0));
        this.firePropertyChange();
        return this;
    }

    public JaretDate backDays(double days) {
        this._date.setTime(this._date.getTime() - (long)(days * 24.0 * 60.0 * 60.0 * 1000.0));
        this.firePropertyChange();
        return this;
    }

    public JaretDate advanceHours(double hours) {
        this._date.setTime(this._date.getTime() + (long)(hours * 60.0 * 60.0 * 1000.0));
        this.firePropertyChange();
        return this;
    }

    public JaretDate backHours(double hours) {
        this._date.setTime(this._date.getTime() - (long)(hours * 60.0 * 60.0 * 1000.0));
        this.firePropertyChange();
        return this;
    }

    public JaretDate advanceMinutes(double minutes) {
        this._date.setTime(this._date.getTime() + (long)(minutes * 60.0 * 1000.0));
        this.firePropertyChange();
        return this;
    }

    public JaretDate backMinutes(double minutes) {
        this._date.setTime(this._date.getTime() - (long)(minutes * 60.0 * 1000.0));
        this.firePropertyChange();
        return this;
    }

    public JaretDate advanceSeconds(double seconds) {
        this._date.setTime(this._date.getTime() + (long)(seconds * 1000.0));
        this.firePropertyChange();
        return this;
    }

    public JaretDate advanceMillis(long millis) {
        this._date.setTime(this._date.getTime() + millis);
        this.firePropertyChange();
        return this;
    }

    public JaretDate backSeconds(double seconds) {
        this._date.setTime(this._date.getTime() - (long)(seconds * 1000.0));
        this.firePropertyChange();
        return this;
    }

    public boolean equals(Object o) {
        return this._date.equals(((JaretDate)o).getDate());
    }

    public int hashCode() {
        return this._date.hashCode();
    }

    @Override
    public int compareTo(JaretDate date) {
        return this._date.compareTo(date._date);
    }

    public long compareTimeTo(JaretDate date) {
        return this.getMillisInDay() - date.getMillisInDay();
    }

    public int compareDateTo(JaretDate date) {
        int result = this.getYear() - date.getYear();
        if (result == 0) {
            result = this.getDayOfYear() - date.getDayOfYear();
        }
        return result;
    }

    public JaretDate copy() {
        return new JaretDate(this);
    }

    public int getMonth() {
        Calendar cal = this.getCalendar();
        return cal.get(2) + 1;
    }

    public String getMonthString() {
        return _jaretDateFormatter.getMonthString(this.getMonth() - 1);
    }

    public String getShortMonthString() {
        return _jaretDateFormatter.getShortMonthString(this.getMonth() - 1);
    }

    public int getWeekOfYear() {
        Calendar cal = this.getCalendar();
        return cal.get(3);
    }

    public String getDayOfWeekString() {
        return _jaretDateFormatter.getDayOfWeekString(this.getDayOfWeek());
    }

    public String getShortDayOfWeekString() {
        return _jaretDateFormatter.getShortDayOfWeekString(this.getDayOfWeek());
    }

    public int getDayOfWeek() {
        Calendar cal = this.getCalendar();
        return cal.get(7);
    }

    public boolean isWeekendDay() {
        return this.getDayOfWeek() == 7 || this.getDayOfWeek() == 1;
    }

    public int getDay() {
        Calendar cal = this.getCalendar();
        return cal.get(5);
    }

    public int getHours() {
        Calendar cal = this.getCalendar();
        return cal.get(11);
    }

    public int getMinutes() {
        Calendar cal = this.getCalendar();
        return cal.get(12);
    }

    public int getSeconds() {
        Calendar cal = this.getCalendar();
        return cal.get(13);
    }

    public int getDayOfYear() {
        Calendar cal = this.getCalendar();
        return cal.get(6);
    }

    public int getYear() {
        Calendar cal = this.getCalendar();
        return cal.get(1);
    }

    private void firePropertyChange() {
        this.firePropertyChange("date", null, this);
    }

    public void clearTime() {
        this.setHours(0);
        this.setMinutes(0);
        this.setSeconds(0);
        this.setMilliseconds(0);
    }

    public static JaretDate getFirstDayOfAWeek(int week, int year) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(1, year);
        cal.set(3, week);
        cal.set(7, cal.getFirstDayOfWeek());
        JaretDate d = new JaretDate(cal.getTime());
        d.clearTime();
        return d;
    }
}

