/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date;

import de.jaret.util.date.JaretDate;
import de.jaret.util.misc.FormatHelper;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class JaretDateFormatter {
    Locale _locale;
    private DateFormat _df;
    private DateFormat _df2;
    private DateFormatSymbols _dateFormatSymbols;
    private SimpleDateFormat _dfTimeSeconds;
    private SimpleDateFormat _dfTimeNoSeconds;

    public JaretDateFormatter(Locale locale) {
        this.setLocale(locale);
    }

    public JaretDateFormatter() {
        this(Locale.getDefault());
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        this._df = DateFormat.getDateTimeInstance(2, 2, this._locale);
        this._df2 = DateFormat.getDateInstance(3, this._locale);
        this._df.setLenient(false);
        this._df2.setLenient(false);
    }

    public Date parseTextualDate(String text) {
        Date date = null;
        try {
            date = this._df2.parse(text);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public boolean equals(Object obj) {
        JaretDateFormatter jdf = (JaretDateFormatter)obj;
        return jdf.getLocale().equals(this._locale);
    }

    public int hashCode() {
        return this._locale.hashCode();
    }

    public String generateDisplayString(JaretDate date) {
        return this._df.format(date.getDate());
    }

    public String generateDisplayStringDate(JaretDate date) {
        return this._df2.format(date.getDate());
    }

    public static String secondsToDisplayString(int sec) {
        int hours = sec / 3600;
        int minutes = sec % 3600 / 60;
        int seconds = sec % 60;
        String str = FormatHelper.NFInt2Digits().format(hours) + ":" + FormatHelper.NFInt2Digits().format(minutes) + ":" + FormatHelper.NFInt2Digits().format(seconds);
        return str;
    }

    public String getDayOfWeekString(int dayOfWeek) {
        if (this._dateFormatSymbols == null) {
            this._dateFormatSymbols = new DateFormatSymbols(this._locale);
        }
        return this._dateFormatSymbols.getWeekdays()[dayOfWeek];
    }

    public String getMonthString(int month) {
        if (this._dateFormatSymbols == null) {
            this._dateFormatSymbols = new DateFormatSymbols(this._locale);
        }
        return this._dateFormatSymbols.getMonths()[month];
    }

    public String getShortDayOfWeekString(int dayOfWeek) {
        if (this._dateFormatSymbols == null) {
            this._dateFormatSymbols = new DateFormatSymbols(this._locale);
        }
        return this._dateFormatSymbols.getShortWeekdays()[dayOfWeek];
    }

    public String getShortMonthString(int month) {
        if (this._dateFormatSymbols == null) {
            this._dateFormatSymbols = new DateFormatSymbols(this._locale);
        }
        return this._dateFormatSymbols.getShortMonths()[month];
    }

    public String toDisplayStringTime(JaretDate date, boolean seconds) {
        if (this._dfTimeSeconds == null) {
            this._dfTimeSeconds = new SimpleDateFormat("HH:mm:ss", this._locale);
            this._dfTimeNoSeconds = new SimpleDateFormat("HH:mm", this._locale);
        }
        if (seconds) {
            return this._dfTimeSeconds.format(date.getDate());
        }
        return this._dfTimeNoSeconds.format(date.getDate());
    }
}

