/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date.holidayenumerator;

import de.jaret.util.date.holidayenumerator.HolidayEnumerator;
import de.jaret.util.date.holidayenumerator.NamedDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HolidayEnumeratorBase
implements HolidayEnumerator {
    protected Map<Integer, Map<Integer, Map<Integer, NamedDate>>> _yearMap = new HashMap<Integer, Map<Integer, Map<Integer, NamedDate>>>();
    protected static final Calendar CALENDAR = new GregorianCalendar();
    protected Locale _locale;
    protected String _regionId;

    protected abstract void fillMap(int var1);

    @Override
    public String[] getAvailableRegionIds() {
        return new String[0];
    }

    public String toString() {
        return this._regionId != null ? this._regionId : "NONE";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HolidayEnumerator)) {
            return false;
        }
        HolidayEnumerator he = (HolidayEnumerator)obj;
        if (!this._locale.equals(he.getLocale())) {
            return false;
        }
        if (this._regionId == null && he.getRegionId() == null) {
            return true;
        }
        if (this._regionId != null) {
            return this._regionId.equals(he.getRegionId());
        }
        if (he.getRegionId() != null) {
            return he.getRegionId().equals(this._regionId);
        }
        return false;
    }

    public int hashCode() {
        return this._locale.hashCode() + 13 * (this._regionId != null ? this._regionId.hashCode() : 0);
    }

    protected void init() {
        this._yearMap = new HashMap<Integer, Map<Integer, Map<Integer, NamedDate>>>();
    }

    private NamedDate getNamedDate(int year, int month, int day) {
        Map<Integer, NamedDate> mMap;
        Map<Integer, Map<Integer, NamedDate>> yMap;
        if (this._yearMap == null) {
            this.init();
        }
        if ((yMap = this._yearMap.get(year)) == null) {
            this.fillMap(year);
            yMap = this._yearMap.get(year);
        }
        if ((mMap = yMap.get(month)) != null) {
            return mMap.get(day);
        }
        return null;
    }

    protected void addNamedDate(int year, int month, int day, boolean isHoliday, String name) {
        Map<Integer, NamedDate> mMap;
        Map<Integer, Map<Integer, NamedDate>> yMap = this._yearMap.get(year);
        if (yMap == null) {
            yMap = new HashMap<Integer, Map<Integer, NamedDate>>();
            this._yearMap.put(year, yMap);
        }
        if ((mMap = yMap.get(month)) == null) {
            mMap = new HashMap<Integer, NamedDate>();
            yMap.put(month, mMap);
        }
        Date date = this.getDate(year, month, day, 0);
        NamedDateImpl namedDate = new NamedDateImpl(date, name, isHoliday);
        mMap.put(day, namedDate);
    }

    protected void addNamedDate(int year, int month, int day, int dayOffset, boolean isHoliday, String name) {
        Date date = this.getDate(year, month, day, dayOffset);
        EasyDate ed = new EasyDate(date);
        year = ed.year;
        month = ed.month;
        day = ed.day;
        this.addNamedDate(year, month, day, isHoliday, name);
    }

    protected void addNamedDate(EasyDate ed, boolean isHoliday, String name) {
        int year = ed.year;
        int month = ed.month;
        int day = ed.day;
        this.addNamedDate(year, month, day, isHoliday, name);
    }

    protected Date getDate(int year, int month, int day, int dayOffset) {
        CALENDAR.set(1, year);
        CALENDAR.set(2, month);
        CALENDAR.set(5, day);
        CALENDAR.set(11, 0);
        CALENDAR.set(12, 0);
        CALENDAR.set(13, 0);
        CALENDAR.set(14, 0);
        CALENDAR.add(6, dayOffset);
        return CALENDAR.getTime();
    }

    protected int getWeekday(Date date) {
        CALENDAR.setTime(date);
        return CALENDAR.get(7);
    }

    @Override
    public boolean isHoliday(Date date) {
        EasyDate ed = new EasyDate(date);
        NamedDate d = this.getNamedDate(ed.year, ed.month, ed.day);
        if (d == null) {
            return false;
        }
        return d.isHoliday();
    }

    @Override
    public boolean isSpecialDay(Date date) {
        EasyDate ed = new EasyDate(date);
        NamedDate d = this.getNamedDate(ed.year, ed.month, ed.day);
        if (d == null) {
            return false;
        }
        return !d.isHoliday();
    }

    @Override
    public String getDayName(Date date) {
        EasyDate ed = new EasyDate(date);
        NamedDate d = this.getNamedDate(ed.year, ed.month, ed.day);
        if (d == null) {
            return null;
        }
        return d.getName();
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        this.init();
    }

    @Override
    public String getRegionId() {
        return this._regionId;
    }

    public void setRegionId(String regionId) {
        this._regionId = regionId;
        this.init();
    }

    @Override
    public List<NamedDate> getNamedDays(int year, boolean includeSpecialDays) {
        ArrayList<NamedDate> result = new ArrayList<NamedDate>();
        for (int month = 0; month < 12; ++month) {
            result.addAll(this.getNamedDays(year, month, includeSpecialDays));
        }
        return result;
    }

    @Override
    public List<NamedDate> getNamedDays(int year, int month, boolean includeSpecialDays) {
        Map<Integer, NamedDate> mMap;
        Map<Integer, Map<Integer, NamedDate>> yMap;
        ArrayList<NamedDate> result = new ArrayList<NamedDate>();
        if (this._yearMap == null) {
            this.init();
        }
        if ((yMap = this._yearMap.get(year)) == null) {
            this.fillMap(year);
            yMap = this._yearMap.get(year);
        }
        if ((mMap = yMap.get(month)) != null) {
            for (Integer day : mMap.keySet()) {
                NamedDate d = mMap.get(day);
                if (!d.isHoliday() && !includeSpecialDays) continue;
                result.add(d);
            }
        }
        return result;
    }

    public EasyDate calcEaster(int year) {
        if (year < 1583 || year > 2499) {
            throw new IllegalArgumentException("Valid input from 1583 to 2499");
        }
        int jahr = year;
        int monat = -1;
        int tag = -1;
        int M = 0;
        int N = 0;
        if (1583 <= jahr && jahr <= 1699) {
            M = 22;
            N = 2;
        } else if (1700 <= jahr && jahr <= 1799) {
            M = 23;
            N = 3;
        } else if (1800 <= jahr && jahr <= 1899) {
            M = 23;
            N = 4;
        } else if (1900 <= jahr && jahr <= 2099) {
            M = 24;
            N = 5;
        } else if (2100 <= jahr && jahr <= 2199) {
            M = 24;
            N = 6;
        } else if (2200 <= jahr && jahr <= 2299) {
            M = 25;
            N = 0;
        } else if (2300 <= jahr && jahr <= 2499) {
            M = 26;
            N = 1;
        } else if (2400 <= jahr && jahr <= 2499) {
            M = 25;
            N = 1;
        }
        int a = jahr % 19;
        int b = jahr % 4;
        int c = jahr % 7;
        int d = (19 * a + M) % 30;
        int e = (2 * b + 4 * c + 6 * d + N) % 7;
        if (d + e <= 9) {
            int easter = 22 + d + e;
            monat = 2;
            tag = easter;
        } else if (d + e > 9) {
            if (d + e - 9 == 26) {
                int easter = 19;
                monat = 3;
                tag = easter;
            } else if (d + e - 9 == 25 && d == 28 && a > 10) {
                int easter = 18;
                monat = 3;
                tag = easter;
            } else {
                int easter = d + e - 9;
                monat = 3;
                tag = easter;
            }
        }
        if (monat == -1) {
            throw new RuntimeException("??? Error in easter calculation");
        }
        return new EasyDate(jahr, monat, tag);
    }

    public EasyDate nThWeekdayInMonth(int year, int month, int weekday, int nTh) {
        if (nTh > 4 || nTh < 0) {
            throw new IllegalArgumentException("nTh must be within 1..4");
        }
        EasyDate result = null;
        int n = 0;
        int daysInMonth = this.daysInMonth(year, month);
        for (int i = 0; i < daysInMonth && result == null; ++i) {
            Date d = this.getDate(year, month, 1, i);
            if (this.getWeekday(d) != weekday || ++n != nTh) continue;
            result = new EasyDate(d);
        }
        return result;
    }

    public EasyDate lastWeekdayInMonth(int year, int month, int weekday) {
        EasyDate result = null;
        int daysInMonth = this.daysInMonth(year, month);
        for (int i = 0; i < daysInMonth; ++i) {
            Date d = this.getDate(year, month, 1, i);
            if (this.getWeekday(d) != weekday) continue;
            result = new EasyDate(d);
        }
        return result;
    }

    public EasyDate fridayOrMonday(EasyDate ed) {
        if (this.getWeekday(ed.date) == 7) {
            return new EasyDate(this.getDate(ed.year, ed.month, ed.day, -1));
        }
        if (this.getWeekday(ed.date) == 1) {
            return new EasyDate(this.getDate(ed.year, ed.month, ed.day, 1));
        }
        return null;
    }

    protected int daysInMonth(int year, int month) {
        Date d = this.getDate(year, month, 1, 0);
        CALENDAR.setTime(d);
        return CALENDAR.getMaximum(5);
    }

    public EasyDate getEasyDate(int year, int month, int day) {
        return new EasyDate(year, month, day);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NamedDateImpl
    implements NamedDate,
    Comparable<NamedDate> {
        private String _name;
        private Date _date;
        private boolean _holiday;

        public NamedDateImpl(Date date, String name, boolean holiday) {
            if (date == null) {
                throw new RuntimeException("date may not be null");
            }
            this._date = date;
            this._name = name;
            this._holiday = holiday;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Date getDate() {
            return this._date;
        }

        @Override
        public boolean isHoliday() {
            return this._holiday;
        }

        public boolean equals(Object obj) {
            return this._date.equals(obj);
        }

        public int hashCode() {
            return this._date.hashCode();
        }

        public String toString() {
            return "NamedDateImpl[date=" + this._date + ";name=" + this._name + ";isHoliday=" + this._holiday + "]";
        }

        @Override
        public int compareTo(NamedDate date) {
            return this._date.compareTo(date.getDate());
        }
    }

    public class EasyDate {
        public int year;
        public int month;
        public int day;
        public Date date;

        public EasyDate(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.date = HolidayEnumeratorBase.this.getDate(year, month, day, 0);
        }

        public EasyDate(Date date) {
            CALENDAR.setTime(date);
            this.date = date;
            this.year = CALENDAR.get(1);
            this.month = CALENDAR.get(2);
            this.day = CALENDAR.get(5);
        }

        public boolean equals(int year, int month, int day) {
            return year == this.year && month == this.month && day == this.day;
        }
    }
}

