/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.date.holidayenumerator;

import de.jaret.util.date.holidayenumerator.HolidayEnumerator;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HolidayEnumeratorFactory {
    private static final String BASENAME = "de.jaret.util.date.holidayenumerator.HolidayEnumerator_";
    private static Map<String, HolidayEnumerator> __enumerators = new HashMap<String, HolidayEnumerator>();
    private static List<Locale> _availableHolidayEnumeratorLocales;

    public static HolidayEnumerator getHolidayEnumeratorInstance(Locale locale, String regionId) {
        HolidayEnumerator he = __enumerators.get(HolidayEnumeratorFactory.getHolidayEnumeratorId(locale, regionId));
        if (he != null) {
            return he;
        }
        he = HolidayEnumeratorFactory.instantiateHolidayEnumerator(locale, regionId);
        if (he != null) {
            __enumerators.put(HolidayEnumeratorFactory.getHolidayEnumeratorId(locale, regionId), he);
        }
        return he;
    }

    public static HolidayEnumerator getHolidayEnumeratorInstance(String languageAndCountry, String regionId) {
        StringTokenizer tokenizer = new StringTokenizer(languageAndCountry, "_");
        String language = null;
        String country = null;
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        if (country == null || language == null) {
            return null;
        }
        Locale locale = new Locale(language, country);
        return HolidayEnumeratorFactory.getHolidayEnumeratorInstance(locale, regionId);
    }

    private static String getHolidayEnumeratorId(Locale locale, String regionId) {
        return locale.toString() + "_" + (regionId != null ? regionId : "");
    }

    private static Class<? extends HolidayEnumerator> getHolidayEnumeratorClass(Locale locale) {
        String classname = BASENAME + locale.toString();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(classname);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private static HolidayEnumerator instantiateHolidayEnumerator(Locale locale, String regionId) {
        Class<? extends HolidayEnumerator> clazz = HolidayEnumeratorFactory.getHolidayEnumeratorClass(locale);
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<? extends HolidayEnumerator> constructor = clazz.getConstructor(String.class);
            HolidayEnumerator he = constructor.newInstance(regionId);
            return he;
        }
        catch (Exception e) {
            try {
                Constructor<? extends HolidayEnumerator> constructor = clazz.getConstructor(new Class[0]);
                HolidayEnumerator he = constructor.newInstance(new Object[0]);
                return he;
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static List<Locale> getAvailableHolidayEnumeratorLocales() {
        if (_availableHolidayEnumeratorLocales != null) {
            return _availableHolidayEnumeratorLocales;
        }
        ArrayList<Locale> result = new ArrayList<Locale>();
        Locale[] locales = Locale.getAvailableLocales();
        for (int i = 0; i < locales.length; ++i) {
            if (HolidayEnumeratorFactory.getHolidayEnumeratorClass(locales[i]) == null) continue;
            result.add(locales[i]);
        }
        _availableHolidayEnumeratorLocales = result;
        return result;
    }
}

